/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.stats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.java.decompiler.code.SwitchInstruction;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.DecHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.SwitchHelper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.SwitchExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class SwitchStatement
extends Statement {
    private List<Statement> caseStatements = new ArrayList<Statement>();
    private List<List<StatEdge>> caseEdges = new ArrayList<List<StatEdge>>();
    private List<List<Exprent>> caseValues = new ArrayList<List<Exprent>>();
    private StatEdge default_edge;
    private final List<Exprent> headexprent = new ArrayList<Exprent>(1);

    private SwitchStatement() {
        this.type = 6;
        this.headexprent.add(null);
    }

    private SwitchStatement(Statement head, Statement poststat) {
        this();
        this.first = head;
        this.stats.addWithKey(head, head.id);
        HashSet<Statement> lstNodes = new HashSet<Statement>(head.getNeighbours(1, 1));
        if (poststat != null) {
            this.post = poststat;
            lstNodes.remove(this.post);
        }
        this.default_edge = head.getSuccessorEdges(0x40000000).get(0);
        for (Statement st : lstNodes) {
            this.stats.addWithKey(st, st.id);
        }
    }

    public static Statement isHead(Statement head) {
        ArrayList lst;
        if (head.type == 8 && head.getLastBasicType() == 1 && DecHelper.isChoiceStatement(head, lst = new ArrayList())) {
            Statement post = (Statement)lst.remove(0);
            for (Statement st : lst) {
                if (!st.isMonitorEnter()) continue;
                return null;
            }
            if (DecHelper.checkStatementExceptions(lst)) {
                return new SwitchStatement(head, post);
            }
        }
        return null;
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        SwitchHelper.simplify(this);
        TextBuffer buf = new TextBuffer();
        buf.append(ExprProcessor.listToJava(this.varDefinitions, indent, tracer));
        buf.append(this.first.toJava(indent, tracer));
        if (this.isLabeled()) {
            buf.appendIndent(indent).append("label").append(this.id.toString()).append(":").appendLineSeparator();
            tracer.incrementCurrentSourceLine();
        }
        buf.appendIndent(indent).append(this.headexprent.get(0).toJava(indent, tracer)).append(" {").appendLineSeparator();
        tracer.incrementCurrentSourceLine();
        VarType switch_type = this.headexprent.get(0).getExprType();
        for (int i = 0; i < this.caseStatements.size(); ++i) {
            Statement stat = this.caseStatements.get(i);
            List<StatEdge> edges = this.caseEdges.get(i);
            List<Exprent> values = this.caseValues.get(i);
            for (int j = 0; j < edges.size(); ++j) {
                if (edges.get(j) == this.default_edge) {
                    buf.appendIndent(indent).append("default:").appendLineSeparator();
                    tracer.incrementCurrentSourceLine();
                    continue;
                }
                buf.appendIndent(indent).append("case ");
                Exprent value = values.get(j);
                if (value instanceof ConstExprent) {
                    value = value.copy();
                    ((ConstExprent)value).setConstType(switch_type);
                }
                if (value instanceof FieldExprent && ((FieldExprent)value).isStatic()) {
                    buf.append(((FieldExprent)value).getName());
                } else {
                    buf.append(value.toJava(indent, tracer));
                }
                buf.append(":").appendLineSeparator();
                tracer.incrementCurrentSourceLine();
            }
            buf.append(ExprProcessor.jmpWrapper(stat, indent + 1, false, tracer));
        }
        buf.appendIndent(indent).append("}").appendLineSeparator();
        tracer.incrementCurrentSourceLine();
        return buf;
    }

    @Override
    public void initExprents() {
        SwitchExprent swexpr = (SwitchExprent)this.first.getExprents().remove(this.first.getExprents().size() - 1);
        swexpr.setCaseValues(this.caseValues);
        this.headexprent.set(0, swexpr);
    }

    @Override
    public List<Object> getSequentialObjects() {
        ArrayList<Object> lst = new ArrayList<Object>(this.stats);
        lst.add(1, this.headexprent.get(0));
        return lst;
    }

    @Override
    public void replaceExprent(Exprent oldexpr, Exprent newexpr) {
        if (this.headexprent.get(0) == oldexpr) {
            this.headexprent.set(0, newexpr);
        }
    }

    @Override
    public void replaceStatement(Statement oldstat, Statement newstat) {
        for (int i = 0; i < this.caseStatements.size(); ++i) {
            if (this.caseStatements.get(i) != oldstat) continue;
            this.caseStatements.set(i, newstat);
        }
        super.replaceStatement(oldstat, newstat);
    }

    @Override
    public Statement getSimpleCopy() {
        return new SwitchStatement();
    }

    @Override
    public void initSimpleCopy() {
        this.first = (Statement)this.stats.get(0);
        this.default_edge = this.first.getSuccessorEdges(0x40000000).get(0);
        this.sortEdgesAndNodes();
    }

    public void sortEdgesAndNodes() {
        ArrayList lst;
        HashMap<StatEdge, Integer> mapEdgeIndex = new HashMap<StatEdge, Integer>();
        List<StatEdge> lstFirstSuccs = this.first.getSuccessorEdges(0x40000000);
        for (int i = 0; i < lstFirstSuccs.size(); ++i) {
            mapEdgeIndex.put(lstFirstSuccs.get(i), i == 0 ? lstFirstSuccs.size() : i);
        }
        BasicBlockStatement bbstat = (BasicBlockStatement)this.first;
        int[] values = ((SwitchInstruction)bbstat.getBlock().getLastInstruction()).getValues();
        ArrayList<Statement> nodes = new ArrayList<Statement>(this.stats.size() - 1);
        ArrayList edges = new ArrayList(this.stats.size() - 1);
        for (int i = 1; i < this.stats.size(); ++i) {
            Statement stat = (Statement)this.stats.get(i);
            lst = new ArrayList();
            for (StatEdge statEdge : stat.getPredecessorEdges(1)) {
                if (statEdge.getSource() != this.first) continue;
                lst.add(mapEdgeIndex.get(statEdge));
            }
            Collections.sort(lst);
            nodes.add(stat);
            edges.add(lst);
        }
        List<StatEdge> lstExitEdges = this.first.getSuccessorEdges(12);
        while (!lstExitEdges.isEmpty()) {
            StatEdge edge = lstExitEdges.get(0);
            lst = new ArrayList();
            for (int i = lstExitEdges.size() - 1; i >= 0; --i) {
                StatEdge statEdge = lstExitEdges.get(i);
                if (statEdge.getDestination() != edge.getDestination() || statEdge.getType() != edge.getType()) continue;
                lst.add(mapEdgeIndex.get(statEdge));
                lstExitEdges.remove(i);
            }
            Collections.sort(lst);
            nodes.add(null);
            edges.add(lst);
        }
        for (int i = 0; i < edges.size() - 1; ++i) {
            for (int j = edges.size() - 1; j > i; --j) {
                if ((Integer)((List)edges.get(j - 1)).get(0) <= (Integer)((List)edges.get(j)).get(0)) continue;
                edges.set(j, edges.set(j - 1, edges.get(j)));
                nodes.set(j, (Statement)nodes.set(j - 1, (Statement)nodes.get(j)));
            }
        }
        block7: for (int index = 0; index < nodes.size(); ++index) {
            Statement stat = (Statement)nodes.get(index);
            if (stat == null) continue;
            HashSet<Statement> setPreds = new HashSet<Statement>(stat.getNeighbours(1, 0));
            setPreds.remove(this.first);
            if (setPreds.isEmpty()) continue;
            Statement statement = setPreds.iterator().next();
            for (int j = 0; j < nodes.size(); ++j) {
                if (j == index - 1 || nodes.get(j) != statement) continue;
                nodes.add(j + 1, stat);
                edges.add(j + 1, edges.get(index));
                if (j > index) {
                    nodes.remove(index);
                    edges.remove(index);
                    --index;
                    continue block7;
                }
                nodes.remove(index + 1);
                edges.remove(index + 1);
                continue block7;
            }
        }
        ArrayList<List<StatEdge>> lstEdges = new ArrayList<List<StatEdge>>(edges.size());
        ArrayList<List<Exprent>> lstValues = new ArrayList<List<Exprent>>(edges.size());
        for (List list : edges) {
            ArrayList<StatEdge> lste = new ArrayList<StatEdge>(list.size());
            ArrayList<ConstExprent> lstv = new ArrayList<ConstExprent>(list.size());
            List<StatEdge> lstSuccs = this.first.getSuccessorEdges(0x40000000);
            for (Integer in : list) {
                int index = in.intValue() == lstSuccs.size() ? 0 : in;
                lste.add(lstSuccs.get(index));
                lstv.add(index == 0 ? null : new ConstExprent(values[index - 1], false, null));
            }
            lstEdges.add(lste);
            lstValues.add(lstv);
        }
        for (int i = 0; i < nodes.size(); ++i) {
            if (nodes.get(i) != null) continue;
            BasicBlockStatement basicBlockStatement = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
            StatEdge sample_edge = (StatEdge)((List)lstEdges.get(i)).get(0);
            basicBlockStatement.addSuccessor(new StatEdge(sample_edge.getType(), basicBlockStatement, sample_edge.getDestination(), sample_edge.closure));
            for (StatEdge edge : (List)lstEdges.get(i)) {
                edge.getSource().changeEdgeType(1, edge, 1);
                edge.closure.getLabelEdges().remove(edge);
                edge.getDestination().removePredecessor(edge);
                edge.getSource().changeEdgeNode(1, edge, basicBlockStatement);
                basicBlockStatement.addPredecessor(edge);
            }
            nodes.set(i, basicBlockStatement);
            this.stats.addWithKey(basicBlockStatement, basicBlockStatement.id);
            basicBlockStatement.setParent(this);
        }
        this.caseStatements = nodes;
        this.caseEdges = lstEdges;
        this.caseValues = lstValues;
    }

    public List<Exprent> getHeadexprentList() {
        return this.headexprent;
    }

    public Exprent getHeadexprent() {
        return this.headexprent.get(0);
    }

    public List<List<StatEdge>> getCaseEdges() {
        return this.caseEdges;
    }

    public List<Statement> getCaseStatements() {
        return this.caseStatements;
    }

    public StatEdge getDefault_edge() {
        return this.default_edge;
    }

    public List<List<Exprent>> getCaseValues() {
        return this.caseValues;
    }
}

