#!/usr/bin/pyhton
# =======================================================================
#                         GENERAL INFORMATION
# =======================================================================
""" Module that allows to make animation from openFoam files
"""
#
# ---------------- Module General Import and Declarations ---------------
#
import os
import numpy as np

import fluidfoam
from pylab import *
from scipy.interpolate import griddata


def animate(rep, timeRange, Scalar, Vector, xrange=(0, 0), yrange=(0, 0),
            gridSize=(0, 0), scaleV=1, write='no'):
        """ read OF Scalar and Vector and generate an animation"""

        # import modules
        import time
        #
        # Change fontsize
        #
        matplotlib.rcParams.update({'font.size': 16})

        #
        # linewidth
        #
        lw = 3
        rc('lines', linewidth=lw)
        #
        # Time duration for showing each snapshots
        #
        deltaT = 2
        #
        # read mesh
        #
        X, Y, Z = fluidfoam.readmesh(rep+'0/')

        if (xrange[0] == xrange[1]):
            xmin = np.min(X)
            xmax = np.max(X)
        else:
            xmin = xrange[0]
            xmax = xrange[1]

        if (yrange[0] == yrange[1]):
            ymin = np.min(Y)
            ymax = np.max(Y)
        else:
            ymin = yrange[0]
            ymax = yrange[1]

        if (gridSize[0] == 0):
            nx = 100
            ny = 100

        if (write != 'no'):
            baseRep = rep+"Animation/"
            cmd = "mkdir "+baseRep
            os.system(cmd)
            baseName = baseRep+'anim'

        #
        #
        # Figure size
        #
        figwidth = 16
        figheight = figwidth*(ymax-ymin)/(xmax-xmin)*scaleV

        # create a regular grid for plot and interpolate variables on it

        xv = np.linspace(xmin, xmax, nx)
        yv = np.linspace(ymin, ymax, ny)

        x, y = meshgrid(xv, yv)
        points = np.column_stack((X, Y))

        interp_method = 'linear'
        missing_value = nan

        for t in timeRange:
            print 'Reading time: ', t, ' s'

            ScalarV = fluidfoam.readscalar(rep, t+'/', Scalar)
            VectorV = fluidfoam.readvector(rep, t+'/', Vector)

            ScalarG = griddata(points, ScalarV, (x, y), method=interp_method,
                               fill_value=missing_value)
            VecGx = griddata(points, VectorV[:, 0], (x, y),
                             method=interp_method, fill_value=missing_value)
            VecGy = griddata(points, VectorV[:, 1], (x, y),
                             method=interp_method, fill_value=missing_value)
            VecGz = griddata(points, VectorV[:, 2], (x, y),
                             method=interp_method, fill_value=missing_value)
            magVecG = (VecGx**2+VecGy**2+VecGz**2)**0.5

            # Open the figure
            fig = figure(num=1, figsize=(figwidth, figheight), dpi=60,
                         facecolor='w', edgecolor='w')

            cont1 = contourf(x, y, ScalarG, 100, cmap=plt.cm.jet)
            fig.colorbar(cont1, label=Scalar)
            quiver(x[0:nx:2][0:ny:2], y[0:nx:2][0:ny:2], VecGx[0:nx:2][0:ny:2],
                   VecGy[0:nx:2][0:ny:2], magVecG[0:nx:2][0:ny:2],
                   units='width', cmap=plt.cm.jet)
            axis([xmin, xmax, ymin, ymax])
            xlabel('x (m)')
            ylabel('y (m)')

            title('t='+t+' s')

            if ((write == 'png') | (write == 'eps')):
                fileName = baseName+t.replace('.', '_')+'.'+write
                print 'writing:', fileName
                show(block=False)
                savefig(fileName)
                fig.clf()
            else:
                show()
                time.sleep(deltaT)

        return 0
