import enum

ICMP_DEFAULT_CODE = 0  # the code for ECHO_REPLY and ECHO_REQUEST


class IcmpV4Type(enum.IntEnum):
    """Enum for Type in ICMPv4 Header."""
    ECHO_REPLY = 0
    DESTINATION_UNREACHABLE = 3
    REDIRECT_MESSAGE = 5
    ECHO_REQUEST = 8
    ROUTER_ADVERTISEMENT = 9
    ROUTER_SOLICITATION = 10
    TIME_EXCEEDED = 11
    BAD_IP_HEADER = 12
    TIMESTAMP = 13
    TIMESTAMP_REPLY = 14


class IcmpV6Type(enum.IntEnum):
    """Enum for Type in ICMPv6 Header."""
    DESTINATION_UNREACHABLE = 1
    TIME_EXCEEDED = 3
    ECHO_REQUEST = 128
    ECHO_REPLY = 129
    ROUTER_SOLICITATION = 133
    ROUTER_ADVERTISEMENT = 134
    REDIRECT_MESSAGE = 137


class IcmpV4DestinationUnreachableCode(enum.IntEnum):
    """Enum for Code in ICMPv4 Header when type is DESTINATION_UNREACHABLE (3)"""
    DESTINATION_NETWORK_UNREACHABLE = 0
    DESTINATION_HOST_UNREACHABLE = 1
    DESTINATION_PROTOCOL_UNREACHABLE = 2
    DESTINATION_PORT_UNREACHABLE = 3
    FRAGMENTATION_REQUIRED = 4
    SOURCE_ROUTE_FAILED = 5
    DESTINATION_NETWORK_UNKNOWN = 6
    DESTINATION_HOST_UNKNOWN = 7
    SOURCE_HOST_ISOLATED = 8
    NETWORK_ADMINISTRATIVELY_PROHIBITED = 9
    HOST_ADMINISTRATIVELY_PROHIBITED = 10
    NETWORK_UNREACHABLE_FOR_TOS = 11
    HOST_UNREACHABLE_FOR_TOS = 12
    COMMUNICATION_ADMINISTRATIVELY_PROHIBITED = 13
    HOST_PRECEDENCE_VIOLATION = 14
    PRECEDENCE_CUTOFF_IN_EFFECT = 15


class IcmpV6DestinationUnreachableCode(enum.IntEnum):
    """Enum for Code in ICMPv6 Header when type is DESTINATION_UNREACHABLE (1)"""
    NO_ROUTE_TO_DESTINATION = 0
    COMMUNICATION_PROHIBITED = 1
    BEYOND_SCOPE = 2
    ADDRESS_UNREACHABLE = 3
    PORT_UNREACHABLE = 4
    SOURCE_ADDRESS_FAILED = 5
    REJECT_ROUTE_TO_DESTINATION = 6
    ERROR_IN_SOURCE_ROUTING_HEADER = 7


class IcmpTimeExceededCode(enum.IntEnum):
    """Enum for Code in ICMPv4 and ICMPv6 Header when type is TIME_EXCEEDED (11)"""
    TTL_EXPIRED = 0
    FRAGMENT_REASSEMBLY_TIME_EXCEEDED = 1
