# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource_py3 import ProxyResource


class RedisLinkedServerWithProperties(ProxyResource):
    """Response to put/get linked server (with properties) for Redis cache.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param linked_redis_cache_id: Required. Fully qualified resourceId of the
     linked redis cache.
    :type linked_redis_cache_id: str
    :param linked_redis_cache_location: Required. Location of the linked redis
     cache.
    :type linked_redis_cache_location: str
    :param server_role: Required. Role of the linked server. Possible values
     include: 'Primary', 'Secondary'
    :type server_role: str or ~azure.mgmt.redis.models.ReplicationRole
    :ivar provisioning_state: Terminal state of the link between primary and
     secondary redis cache.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'linked_redis_cache_id': {'required': True},
        'linked_redis_cache_location': {'required': True},
        'server_role': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'linked_redis_cache_id': {'key': 'properties.linkedRedisCacheId', 'type': 'str'},
        'linked_redis_cache_location': {'key': 'properties.linkedRedisCacheLocation', 'type': 'str'},
        'server_role': {'key': 'properties.serverRole', 'type': 'ReplicationRole'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, linked_redis_cache_id: str, linked_redis_cache_location: str, server_role, **kwargs) -> None:
        super(RedisLinkedServerWithProperties, self).__init__(**kwargs)
        self.linked_redis_cache_id = linked_redis_cache_id
        self.linked_redis_cache_location = linked_redis_cache_location
        self.server_role = server_role
        self.provisioning_state = None
