/*
 * Decompiled with CFR 0.152.
 */
package nc.vo.framework.rsa;

public class DES {
    private int[] subkey1 = new int[16];
    private int[] subkey2 = new int[16];
    private static final boolean[] ks = new boolean[]{false, false, true, true, true, true, true, true, false, true, true, true, true, true, true, false};
    private static final int[][] kp = new int[][]{{0, 262144, 0x1000000, 0x1040000, 1024, 263168, 0x1000400, 0x1040400, 0x200000, 0x240000, 0x1200000, 19136512, 0x200400, 0x240400, 18875392, 19137536, 1, 262145, 0x1000001, 0x1040001, 1025, 263169, 0x1000401, 0x1040401, 0x200001, 2359297, 0x1200001, 19136513, 2098177, 2360321, 18875393, 19137537, 0x2000000, 0x2040000, 0x3000000, 0x3040000, 0x2000400, 0x2040400, 0x3000400, 0x3040400, 0x2200000, 0x2240000, 0x3200000, 52690944, 0x2200400, 0x2240400, 52429824, 52691968, 0x2000001, 33816577, 0x3000001, 50593793, 33555457, 33817601, 50332673, 50594817, 0x2200001, 35913729, 52428801, 52690945, 35652609, 35914753, 52429825, 52691969}, {0, 2, 2048, 2050, 0x8000000, 0x8000002, 0x8000800, 0x8000802, 65536, 65538, 67584, 67586, 0x8010000, 134283266, 0x8010800, 134285314, 256, 258, 2304, 2306, 0x8000100, 134217986, 0x8000900, 134220034, 65792, 65794, 67840, 67842, 0x8010100, 134283522, 134285568, 134285570, 16, 18, 2064, 2066, 0x8000010, 134217746, 0x8000810, 134219794, 65552, 65554, 67600, 67602, 0x8010010, 134283282, 0x8010810, 134285330, 272, 274, 2320, 2322, 0x8000110, 134218002, 134220048, 134220050, 65808, 65810, 67856, 67858, 0x8010110, 134283538, 134285584, 134285586}, {0, 4, 4096, 4100, 0x10000000, 0x10000004, 0x10001000, 0x10001004, 32, 36, 4128, 4132, 0x10000020, 268435492, 0x10001020, 268439588, 524288, 524292, 528384, 528388, 0x10080000, 268959748, 0x10081000, 268963844, 524320, 524324, 528416, 528420, 268959776, 268959780, 268963872, 268963876, 0x20000000, 0x20000004, 0x20001000, 536875012, 0x30000000, 0x30000004, 0x30001000, 805310468, 0x20000020, 0x20000024, 0x20001020, 536875044, 0x30000020, 805306404, 805310496, 805310500, 0x20080000, 537395204, 537399296, 537399300, 0x30080000, 805830660, 805834752, 805834756, 0x20080020, 537395236, 537399328, 537399332, 805830688, 805830692, 805834784, 805834788}, {0, 0x100000, 8, 0x100008, 512, 0x100200, 520, 1049096, 0x4000000, 0x4100000, 0x4000008, 68157448, 0x4000200, 68157952, 67109384, 68157960, 8192, 0x102000, 8200, 1056776, 8704, 0x102200, 8712, 1057288, 0x4002000, 68165632, 67117064, 68165640, 0x4002200, 68166144, 67117576, 68166152, 131072, 0x120000, 131080, 1179656, 131584, 0x120200, 131592, 1180168, 0x4020000, 68288512, 67239944, 68288520, 0x4020200, 68289024, 67240456, 68289032, 139264, 0x122000, 139272, 1187848, 139776, 0x122200, 139784, 1188360, 0x4022000, 68296704, 67248136, 68296712, 0x4022200, 68297216, 67248648, 68297224}, {0, 512, 131072, 131584, 1, 513, 131073, 131585, 0x8000000, 0x8000200, 0x8020000, 0x8020200, 0x8000001, 134218241, 134348801, 134349313, 0x200000, 0x200200, 0x220000, 0x220200, 0x200001, 0x200201, 0x220001, 0x220201, 0x8200000, 0x8200200, 0x8220000, 0x8220200, 136314881, 136315393, 136445953, 136446465, 2, 514, 131074, 131586, 3, 515, 131075, 131587, 0x8000002, 0x8000202, 0x8020002, 0x8020202, 0x8000003, 134218243, 134348803, 134349315, 0x200002, 0x200202, 0x220002, 0x220202, 0x200003, 0x200203, 0x220003, 0x220203, 0x8200002, 0x8200202, 0x8220002, 0x8220202, 136314883, 136315395, 136445955, 136446467}, {0, 16, 0x20000000, 0x20000010, 0x100000, 0x100010, 0x20100000, 0x20100010, 2048, 2064, 0x20000800, 536872976, 0x100800, 0x100810, 537921536, 537921552, 0x4000000, 0x4000010, 0x24000000, 603979792, 0x4100000, 0x4100010, 605028352, 605028368, 0x4000800, 67110928, 603981824, 603981840, 68159488, 68159504, 605030400, 605030416, 4, 20, 0x20000004, 536870932, 0x100004, 0x100014, 537919492, 537919508, 2052, 2068, 536872964, 536872980, 1050628, 1050644, 537921540, 537921556, 0x4000004, 0x4000014, 0x24000004, 603979796, 0x4100004, 0x4100014, 605028356, 605028372, 0x4000804, 67110932, 603981828, 603981844, 68159492, 68159508, 605030404, 605030420}, {0, 4096, 65536, 69632, 0x2000000, 0x2001000, 0x2010000, 0x2011000, 32, 4128, 65568, 69664, 0x2000020, 0x2001020, 0x2010020, 0x2011020, 262144, 266240, 327680, 331776, 0x2040000, 33820672, 0x2050000, 33886208, 262176, 266272, 327712, 331808, 0x2040020, 33820704, 0x2050020, 33886240, 8192, 12288, 73728, 77824, 0x2002000, 0x2003000, 0x2012000, 33632256, 8224, 12320, 73760, 77856, 0x2002020, 0x2003020, 0x2012020, 33632288, 270336, 274432, 335872, 339968, 0x2042000, 33828864, 0x2052000, 33894400, 270368, 274464, 335904, 340000, 0x2042020, 33828896, 0x2052020, 33894432}, {0, 1024, 0x1000000, 0x1000400, 256, 1280, 0x1000100, 0x1000500, 0x10000000, 0x10000400, 0x11000000, 0x11000400, 0x10000100, 0x10000500, 0x11000100, 0x11000500, 524288, 525312, 0x1080000, 17302528, 524544, 525568, 0x1080100, 17302784, 0x10080000, 268960768, 0x11080000, 285737984, 0x10080100, 268961024, 0x11080100, 285738240, 8, 1032, 0x1000008, 16778248, 264, 1288, 0x1000108, 16778504, 0x10000008, 268436488, 0x11000008, 285213704, 0x10000108, 268436744, 0x11000108, 285213960, 524296, 525320, 0x1080008, 17302536, 524552, 525576, 0x1080108, 17302792, 0x10080008, 268960776, 0x11080008, 285737992, 0x10080108, 268961032, 0x11080108, 285738248}};
    private static final int[][] spbox = new int[][]{{0x808200, 0, 32768, 0x808202, 0x808002, 33282, 2, 32768, 512, 0x808200, 0x808202, 512, 0x800202, 0x808002, 0x800000, 2, 514, 0x800200, 0x800200, 33280, 33280, 0x808000, 0x808000, 0x800202, 32770, 0x800002, 0x800002, 32770, 0, 514, 33282, 0x800000, 32768, 0x808202, 2, 0x808000, 0x808200, 0x800000, 0x800000, 512, 0x808002, 32768, 33280, 0x800002, 512, 2, 0x800202, 33282, 0x808202, 32770, 0x808000, 0x800202, 0x800002, 514, 33282, 0x808200, 514, 0x800200, 0x800200, 0, 32770, 33280, 0, 0x808002}, {1074282512, 0x40004000, 16384, 540688, 524288, 16, 1074266128, 0x40004010, 0x40000010, 1074282512, 0x40084000, 0x40000000, 0x40004000, 524288, 16, 1074266128, 540672, 524304, 0x40004010, 0, 0x40000000, 16384, 540688, 0x40080000, 524304, 0x40000010, 0, 540672, 16400, 0x40084000, 0x40080000, 16400, 0, 540688, 1074266128, 524288, 0x40004010, 0x40080000, 0x40084000, 16384, 0x40080000, 0x40004000, 16, 1074282512, 540688, 16, 16384, 0x40000000, 16400, 0x40084000, 524288, 0x40000010, 524304, 0x40004010, 0x40000010, 524304, 540672, 0, 0x40004000, 16400, 0x40000000, 1074266128, 1074282512, 540672}, {260, 0x4010100, 0, 0x4010004, 0x4000100, 0, 65796, 0x4000100, 65540, 0x4000004, 0x4000004, 65536, 0x4010104, 65540, 0x4010000, 260, 0x4000000, 4, 0x4010100, 256, 65792, 0x4010000, 0x4010004, 65796, 0x4000104, 65792, 65536, 0x4000104, 4, 0x4010104, 256, 0x4000000, 0x4010100, 0x4000000, 65540, 260, 65536, 0x4010100, 0x4000100, 0, 256, 65540, 0x4010104, 0x4000100, 0x4000004, 256, 0, 0x4010004, 0x4000104, 65536, 0x4000000, 0x4010104, 4, 65796, 65792, 0x4000004, 0x4010000, 0x4000104, 260, 0x4010000, 65796, 4, 0x4010004, 65792}, {-2143285248, -2147479488, -2147479488, 64, 0x401040, -2143289280, -2143289344, -2147479552, 0, 0x401000, 0x401000, -2143285184, -2147483584, 0, 0x400040, -2143289344, Integer.MIN_VALUE, 4096, 0x400000, -2143285248, 64, 0x400000, -2147479552, 4160, -2143289280, Integer.MIN_VALUE, 4160, 0x400040, 4096, 0x401040, -2143285184, -2147483584, 0x400040, -2143289344, 0x401000, -2143285184, -2147483584, 0, 0, 0x401000, 4160, 0x400040, -2143289280, Integer.MIN_VALUE, -2143285248, -2147479488, -2147479488, 64, -2143285184, -2147483584, Integer.MIN_VALUE, 4096, -2143289344, -2147479552, 0x401040, -2143289280, -2147479552, 4160, 0x400000, -2143285248, 64, 0x400000, 4096, 0x401040}, {128, 17039488, 0x1040000, 553648256, 262144, 128, 0x20000000, 0x1040000, 537133184, 262144, 0x1000080, 537133184, 553648256, 553910272, 262272, 0x20000000, 0x1000000, 0x20040000, 0x20040000, 0, 0x20000080, 553910400, 553910400, 0x1000080, 553910272, 0x20000080, 0, 0x21000000, 17039488, 0x1000000, 0x21000000, 262272, 262144, 553648256, 128, 0x1000000, 0x20000000, 0x1040000, 553648256, 537133184, 0x1000080, 0x20000000, 553910272, 17039488, 537133184, 128, 0x1000000, 553910272, 553910400, 262272, 0x21000000, 553910400, 0x1040000, 0, 0x20040000, 0x21000000, 262272, 0x1000080, 0x20000080, 262144, 0, 0x20040000, 17039488, 0x20000080}, {0x10000008, 0x10200000, 8192, 270540808, 0x10200000, 8, 270540808, 0x200000, 0x10002000, 0x202008, 0x200000, 0x10000008, 0x200008, 0x10002000, 0x10000000, 8200, 0, 0x200008, 268443656, 8192, 0x202000, 268443656, 8, 270532616, 270532616, 0, 0x202008, 0x10202000, 8200, 0x202000, 0x10202000, 0x10000000, 0x10002000, 8, 270532616, 0x202000, 270540808, 0x200000, 8200, 0x10000008, 0x200000, 0x10002000, 0x10000000, 8200, 0x10000008, 270540808, 0x202000, 0x10200000, 0x202008, 0x10202000, 0, 270532616, 8, 8192, 0x10200000, 0x202008, 8192, 0x200008, 268443656, 0, 0x10202000, 0x10000000, 0x200008, 268443656}, {0x100000, 0x2100001, 33555457, 0, 1024, 33555457, 0x100401, 34604032, 34604033, 0x100000, 0, 0x2000001, 1, 0x2000000, 0x2100001, 1025, 0x2000400, 0x100401, 0x100001, 0x2000400, 0x2000001, 0x2100000, 34604032, 0x100001, 0x2100000, 1024, 1025, 34604033, 0x100400, 1, 0x2000000, 0x100400, 0x2000000, 0x100400, 0x100000, 33555457, 33555457, 0x2100001, 0x2100001, 1, 0x100001, 0x2000000, 0x2000400, 0x100000, 34604032, 1025, 0x100401, 34604032, 1025, 0x2000001, 34604033, 0x2100000, 0x100400, 0, 1, 34604033, 0, 0x100401, 0x2100000, 1024, 0x2000001, 0x2000400, 1024, 0x100001}, {0x8000820, 2048, 131072, 0x8020820, 0x8000000, 0x8000820, 32, 0x8000000, 131104, 0x8020000, 0x8020820, 133120, 0x8020800, 133152, 2048, 32, 0x8020000, 0x8000020, 0x8000800, 2080, 133120, 131104, 0x8020020, 0x8020800, 2080, 0, 0, 0x8020020, 0x8000020, 0x8000800, 133152, 131072, 133152, 131072, 0x8020800, 2048, 32, 0x8020020, 2048, 133152, 0x8000800, 32, 0x8000020, 0x8020000, 0x8020020, 0x8000000, 131072, 0x8000820, 0, 0x8020820, 131104, 0x8000020, 0x8020000, 0x8000800, 0x8000820, 0, 0x8020820, 133120, 133120, 2080, 2080, 131104, 0x8000000, 0x8020800}};

    public DES(long key) {
        this.setKey(key);
    }

    public long bytes2long(byte[] rd) {
        long dd = 0L;
        for (int i = 0; i <= 7; ++i) {
            dd = dd << 8 | (long)rd[i] & 0xFFL;
        }
        return dd;
    }

    public long decrypt(long d) {
        d = this.ip(d);
        int l = (int)(d >>> 32);
        int r = (int)d;
        for (int i = 15; i >= 0; --i) {
            int t = l;
            l = r;
            r = t;
            int t1 = (t >>> 3 | t << 29) ^ this.subkey1[i];
            int t2 = (t << 1 | t >>> 31) ^ this.subkey2[i];
            l ^= spbox[0][t1 >>> 24 & 0x3F] | spbox[1][t2 >>> 24 & 0x3F] | spbox[2][t1 >>> 16 & 0x3F] | spbox[3][t2 >>> 16 & 0x3F] | spbox[4][t1 >>> 8 & 0x3F] | spbox[5][t2 >>> 8 & 0x3F] | spbox[6][t1 & 0x3F] | spbox[7][t2 & 0x3F];
        }
        d = (long)l << 32 | (long)r & 0xFFFFFFFFL;
        return this.rip(d);
    }

    public long encrypt(long d) {
        d = this.ip(d);
        int l = (int)(d >>> 32);
        int r = (int)d;
        for (int i = 0; i <= 15; ++i) {
            int t1 = (r >>> 3 | r << 29) ^ this.subkey1[i];
            int t2 = (r << 1 | r >>> 31) ^ this.subkey2[i];
            int t = l ^= spbox[0][t1 >>> 24 & 0x3F] | spbox[1][t2 >>> 24 & 0x3F] | spbox[2][t1 >>> 16 & 0x3F] | spbox[3][t2 >>> 16 & 0x3F] | spbox[4][t1 >>> 8 & 0x3F] | spbox[5][t2 >>> 8 & 0x3F] | spbox[6][t1 & 0x3F] | spbox[7][t2 & 0x3F];
            l = r;
            r = t;
        }
        d = (long)l << 32 | (long)r & 0xFFFFFFFFL;
        return this.rip(d);
    }

    private long ip(long d) {
        long t = (d << 36 ^ d) & 0xF0F0F0F000000000L;
        d ^= t >>> 36 | t;
        t = (d << 48 ^ d) & 0xFFFF000000000000L;
        d ^= t >>> 48 | t;
        t = (d << 30 ^ d) & 0x3333333300000000L;
        d ^= t >>> 30 | t;
        t = (d << 24 ^ d) & 0xFF00FF00000000L;
        d ^= t >>> 24 | t;
        t = (d << 33 ^ d) & 0xAAAAAAAA00000000L;
        return d ^= t >>> 33 | t;
    }

    public void long2bytes(long sd, byte[] dd) {
        for (int i = 7; i >= 0; --i) {
            dd[i] = (byte)sd;
            sd >>>= 8;
        }
    }

    private long rip(long d) {
        long t = (d << 33 ^ d) & 0xAAAAAAAA00000000L;
        d ^= t >>> 33 | t;
        t = (d << 24 ^ d) & 0xFF00FF00000000L;
        d ^= t >>> 24 | t;
        t = (d << 30 ^ d) & 0x3333333300000000L;
        d ^= t >>> 30 | t;
        t = (d << 48 ^ d) & 0xFFFF000000000000L;
        d ^= t >>> 48 | t;
        t = (d << 36 ^ d) & 0xF0F0F0F000000000L;
        return d ^= t >>> 36 | t;
    }

    public void setKey(long key) {
        long t = (key << 36 ^ key) & 0xF0F0F0F000000000L;
        key ^= t >>> 36 | t;
        t = (key << 18 ^ key) & 0xCCCC0000CCCC0000L;
        key ^= t | t >>> 18;
        t = (key << 9 ^ key) & 0xAA00AA00AA00AA00L;
        int d = (int)((key ^= t | t >>> 9) >>> 28 & 0xFFFFFF0L | key >>> 24 & 0xFL);
        int c = (int)(key << 20 & 0xFF00000L | key << 4 & 0xFF000L | key >>> 12 & 0xFF0L | key >>> 28 & 0xFL);
        for (int i = 0; i < 16; ++i) {
            if (ks[i]) {
                c = (c << 2 | c >>> 26) & 0xFFFFFFF;
                d = (d << 2 | d >>> 26) & 0xFFFFFFF;
            } else {
                c = (c << 1 | c >>> 27) & 0xFFFFFFF;
                d = (d << 1 | d >>> 27) & 0xFFFFFFF;
            }
            int t1 = kp[0][c >>> 22 & 0x3F] | kp[1][c >>> 16 & 0x30 | c >>> 15 & 0xF] | kp[2][c >>> 9 & 0x3C | c >>> 8 & 3] | kp[3][c >>> 3 & 0x20 | c >>> 1 & 0x18 | c & 7];
            int t2 = kp[4][c >>> 22 & 0x3F] | kp[5][c >>> 15 & 0x30 | c >>> 14 & 0xF] | kp[6][c >>> 7 & 0x3F] | kp[7][c >>> 1 & 0x3C | c & 3];
            this.subkey1[i] = t1 & 0xFF000000 | (t1 & 0xFF00) << 8 | (t2 & 0xFF000000) >>> 16 | (t2 & 0xFF00) >>> 8;
            this.subkey2[i] = (t1 & 0xFF0000) << 8 | (t1 & 0xFF) << 16 | (t2 & 0xFF0000) >>> 8 | t2 & 0xFF;
        }
    }
}

