from unittest import mock

from tests.providers.alibabacloud.alibabacloud_fixtures import (
    set_mocked_alibabacloud_provider,
)


class DummyConfig:
    def __init__(self, enabled: bool):
        self.enabled = enabled


class TestSecurityCenterVulnerabilityScanEnabled:
    def test_missing_types_or_levels_fail(self):
        securitycenter_client = mock.MagicMock()
        securitycenter_client.audited_account = "1234567890"
        securitycenter_client.region = "cn-hangzhou"
        securitycenter_client.vul_configs = {
            "yum": DummyConfig(enabled=True),
            "cve": DummyConfig(enabled=False),
        }
        securitycenter_client.concern_necessity = ["asap"]  # missing "later"

        with (
            mock.patch(
                "prowler.providers.common.provider.Provider.get_global_provider",
                return_value=set_mocked_alibabacloud_provider(),
            ),
            mock.patch(
                "prowler.providers.alibabacloud.services.securitycenter.securitycenter_vulnerability_scan_enabled.securitycenter_vulnerability_scan_enabled.securitycenter_client",
                new=securitycenter_client,
            ),
        ):
            from prowler.providers.alibabacloud.services.securitycenter.securitycenter_vulnerability_scan_enabled.securitycenter_vulnerability_scan_enabled import (
                securitycenter_vulnerability_scan_enabled,
            )

            check = securitycenter_vulnerability_scan_enabled()
            result = check.execute()

            assert len(result) == 1
            assert result[0].status == "FAIL"

    def test_all_types_and_levels_pass(self):
        securitycenter_client = mock.MagicMock()
        securitycenter_client.audited_account = "1234567890"
        securitycenter_client.region = "cn-hangzhou"
        securitycenter_client.vul_configs = {
            key: DummyConfig(enabled=True)
            for key in ["yum", "cve", "sys", "cms", "emg"]
        }
        securitycenter_client.concern_necessity = ["asap", "later"]

        with (
            mock.patch(
                "prowler.providers.common.provider.Provider.get_global_provider",
                return_value=set_mocked_alibabacloud_provider(),
            ),
            mock.patch(
                "prowler.providers.alibabacloud.services.securitycenter.securitycenter_vulnerability_scan_enabled.securitycenter_vulnerability_scan_enabled.securitycenter_client",
                new=securitycenter_client,
            ),
        ):
            from prowler.providers.alibabacloud.services.securitycenter.securitycenter_vulnerability_scan_enabled.securitycenter_vulnerability_scan_enabled import (
                securitycenter_vulnerability_scan_enabled,
            )

            check = securitycenter_vulnerability_scan_enabled()
            result = check.execute()

            assert len(result) == 1
            assert result[0].status == "PASS"
