from prowler.lib.check.models import Check, Check_Report_Azure
from prowler.providers.azure.services.entra.entra_client import entra_client


class entra_policy_default_users_cannot_create_security_groups(Check):
    def execute(self) -> Check_Report_Azure:
        findings = []

        for tenant_domain, auth_policy in entra_client.authorization_policy.items():
            report = Check_Report_Azure(metadata=self.metadata(), resource=auth_policy)
            report.subscription = f"Tenant: {tenant_domain}"
            report.resource_name = getattr(auth_policy, "name", "Authorization Policy")
            report.resource_id = getattr(auth_policy, "id", "authorizationPolicy")
            report.status = "FAIL"
            report.status_extended = "Non-privileged users are able to create security groups via the Access Panel and the Azure administration portal."

            if getattr(
                auth_policy, "default_user_role_permissions", None
            ) and not getattr(
                auth_policy.default_user_role_permissions,
                "allowed_to_create_security_groups",
                True,
            ):
                report.status = "PASS"
                report.status_extended = "Non-privileged users are not able to create security groups via the Access Panel and the Azure administration portal."

            findings.append(report)

        return findings
