# Generated by Django 5.1.13 on 2025-10-31 09:04

import uuid

import django.db.models.deletion
from django.db import migrations, models

import api.rls


class Migration(migrations.Migration):
    dependencies = [
        ("api", "0056_remove_provider_unique_provider_uids_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="ThreatScoreSnapshot",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("inserted_at", models.DateTimeField(auto_now_add=True)),
                (
                    "compliance_id",
                    models.CharField(
                        help_text="Compliance framework ID (e.g., 'prowler_threatscore_aws')",
                        max_length=100,
                    ),
                ),
                (
                    "overall_score",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Overall ThreatScore percentage (0-100)",
                        max_digits=5,
                    ),
                ),
                (
                    "score_delta",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="Score change compared to previous snapshot (positive = improvement)",
                        max_digits=5,
                        null=True,
                    ),
                ),
                (
                    "section_scores",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        help_text="ThreatScore breakdown by section",
                    ),
                ),
                (
                    "critical_requirements",
                    models.JSONField(
                        blank=True,
                        default=list,
                        help_text="List of critical failed requirements (risk >= 4)",
                    ),
                ),
                (
                    "total_requirements",
                    models.IntegerField(
                        default=0, help_text="Total number of requirements evaluated"
                    ),
                ),
                (
                    "passed_requirements",
                    models.IntegerField(
                        default=0, help_text="Number of requirements with PASS status"
                    ),
                ),
                (
                    "failed_requirements",
                    models.IntegerField(
                        default=0, help_text="Number of requirements with FAIL status"
                    ),
                ),
                (
                    "manual_requirements",
                    models.IntegerField(
                        default=0, help_text="Number of requirements with MANUAL status"
                    ),
                ),
                (
                    "total_findings",
                    models.IntegerField(
                        default=0,
                        help_text="Total number of findings across all requirements",
                    ),
                ),
                (
                    "passed_findings",
                    models.IntegerField(
                        default=0, help_text="Number of findings with PASS status"
                    ),
                ),
                (
                    "failed_findings",
                    models.IntegerField(
                        default=0, help_text="Number of findings with FAIL status"
                    ),
                ),
                (
                    "provider",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="threatscore_snapshots",
                        related_query_name="threatscore_snapshot",
                        to="api.provider",
                    ),
                ),
                (
                    "scan",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="threatscore_snapshots",
                        related_query_name="threatscore_snapshot",
                        to="api.scan",
                    ),
                ),
                (
                    "tenant",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="api.tenant"
                    ),
                ),
            ],
            options={
                "db_table": "threatscore_snapshots",
                "abstract": False,
            },
        ),
        migrations.AddIndex(
            model_name="threatscoresnapshot",
            index=models.Index(
                fields=["tenant_id", "scan_id"], name="threatscore_snap_t_scan_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="threatscoresnapshot",
            index=models.Index(
                fields=["tenant_id", "provider_id"], name="threatscore_snap_t_prov_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="threatscoresnapshot",
            index=models.Index(
                fields=["tenant_id", "inserted_at"], name="threatscore_snap_t_time_idx"
            ),
        ),
        migrations.AddConstraint(
            model_name="threatscoresnapshot",
            constraint=api.rls.RowLevelSecurityConstraint(
                "tenant_id",
                name="rls_on_threatscoresnapshot",
                statements=["SELECT", "INSERT", "UPDATE", "DELETE"],
            ),
        ),
    ]
