/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.core.CollectionUtilities;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorType;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.IfElseStatement;
import com.strobel.decompiler.languages.java.ast.NullReferenceExpression;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.TryCatchStatement;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.patterns.AnyNode;
import com.strobel.decompiler.patterns.Choice;
import com.strobel.decompiler.patterns.DeclaredVariableBackReference;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.NamedNode;
import java.util.ArrayList;
import javax.lang.model.element.Modifier;

public class MergeResourceTryStatementsVisitor
extends ContextTrackingVisitor<Void> {
    private final BlockStatement _emptyResource;

    public MergeResourceTryStatementsVisitor(DecompilerContext context) {
        super(context);
        VariableDeclarationStatement rv = new VariableDeclarationStatement(new AnyNode().toType(), "$any$", new AnyNode().toExpression());
        rv.addModifier(Modifier.FINAL);
        Expression rr = new DeclaredVariableBackReference("resourceDeclaration").toExpression();
        this._emptyResource = new BlockStatement(new NamedNode("resourceDeclaration", rv).toStatement(), new NamedNode("resourceDisposal", new Choice(new ExpressionStatement(rr.clone().invoke("close", new Expression[0])), new IfElseStatement(-34, new BinaryOperatorExpression(rr.clone(), BinaryOperatorType.INEQUALITY, new NullReferenceExpression()), (Statement)new BlockStatement(new ExpressionStatement(rr.clone().invoke("close", new Expression[0])))))).toStatement());
    }

    @Override
    public Void visitTryCatchStatement(TryCatchStatement node, Void data) {
        super.visitTryCatchStatement(node, data);
        if (node.getDeclaredResources().isEmpty() && node.getExternalResources().isEmpty()) {
            return null;
        }
        ArrayList<AstNode> resources = new ArrayList<AstNode>();
        TryCatchStatement current = node;
        while (current.getCatchClauses().isEmpty() && current.getFinallyBlock().isNull()) {
            TryCatchStatement parentTry;
            Object parent;
            Match m = this._emptyResource.match(current.getTryBlock());
            if (m.success()) {
                VariableDeclarationStatement innerResource = (VariableDeclarationStatement)CollectionUtilities.first(m.get("resourceDeclaration"));
                current.getTryBlock().getStatements().clear();
                current.getDeclaredResources().add(innerResource);
            }
            if (!((parent = current.getParent()) instanceof BlockStatement) || !(((AstNode)parent).getParent() instanceof TryCatchStatement) || !(parentTry = (TryCatchStatement)((AstNode)parent).getParent()).getTryBlock().getStatements().hasSingleElement()) break;
            if (!current.getDeclaredResources().isEmpty()) {
                resources.addAll(0, current.getDeclaredResources());
            }
            if (!current.getExternalResources().isEmpty()) {
                resources.addAll(0, current.getExternalResources());
            }
            current = parentTry;
        }
        BlockStatement tryContent = node.getTryBlock();
        if (current != node) {
            for (AstNode resource : resources) {
                resource.remove();
                if (resource instanceof VariableDeclarationStatement) {
                    current.getDeclaredResources().add((VariableDeclarationStatement)resource);
                    continue;
                }
                current.getExternalResources().add((IdentifierExpression)resource);
            }
            tryContent.remove();
            current.setTryBlock(tryContent);
            BlockStatement block = current.getFinallyBlock();
            if (!block.isNull() && block.getStatements().isEmpty()) {
                block.remove();
            }
        }
        return null;
    }
}

