/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.DepthFirstAstVisitor;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.transforms.IAstTransform;

public abstract class ContextTrackingVisitor<TResult>
extends DepthFirstAstVisitor<Void, TResult>
implements IAstTransform {
    protected final DecompilerContext context;

    protected ContextTrackingVisitor(DecompilerContext context) {
        this.context = VerifyArgument.notNull(context, "context");
    }

    protected final boolean inConstructor() {
        MethodDefinition currentMethod = this.context.getCurrentMethod();
        return currentMethod != null && currentMethod.isConstructor();
    }

    protected final boolean inStaticInitializer() {
        MethodDefinition currentMethod = this.context.getCurrentMethod();
        return currentMethod != null && currentMethod.isTypeInitializer();
    }

    protected final boolean inMethod() {
        return this.context.getCurrentMethod() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TResult visitTypeDeclaration(TypeDeclaration typeDeclaration, Void p) {
        TypeDefinition oldType = this.context.getCurrentType();
        MethodDefinition oldMethod = this.context.getCurrentMethod();
        try {
            this.context.setCurrentType(typeDeclaration.getUserData(Keys.TYPE_DEFINITION));
            this.context.setCurrentMethod(null);
            TResult TResult = this.visitTypeDeclarationOverride(typeDeclaration, p);
            return TResult;
        }
        finally {
            this.context.setCurrentType(oldType);
            this.context.setCurrentMethod(oldMethod);
        }
    }

    protected TResult visitTypeDeclarationOverride(TypeDeclaration typeDeclaration, Void p) {
        return (TResult)super.visitTypeDeclaration(typeDeclaration, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TResult visitMethodDeclaration(MethodDeclaration node, Void p) {
        assert (this.context.getCurrentMethod() == null);
        try {
            this.context.setCurrentMethod(node.getUserData(Keys.METHOD_DEFINITION));
            TResult TResult = this.visitMethodDeclarationOverride(node, p);
            return TResult;
        }
        finally {
            this.context.setCurrentMethod(null);
        }
    }

    protected TResult visitMethodDeclarationOverride(MethodDeclaration node, Void p) {
        return (TResult)super.visitMethodDeclaration(node, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TResult visitConstructorDeclaration(ConstructorDeclaration node, Void p) {
        assert (this.context.getCurrentMethod() == null);
        try {
            this.context.setCurrentMethod(node.getUserData(Keys.METHOD_DEFINITION));
            Object s = super.visitConstructorDeclaration(node, p);
            return (TResult)s;
        }
        finally {
            this.context.setCurrentMethod(null);
        }
    }

    @Override
    public void run(AstNode compilationUnit) {
        compilationUnit.acceptVisitor(this, null);
    }
}

