#!/usr/bin/python3.5
# -*- coding: utf-8 -*-

NUM_WORKERS = 5
from core.scrapers import PacketStorm, CXSecurity, ZeroDay, Vulners, \
    NationaVulnerabilityDB, WpvulndbB
from common.print_messages import show_results
from common.writers import write_html, write_txt
from common.writers import open_url
from common.print_messages import GENERATE_TXT_FILE


class ExploitFinder(object):
    def __init__(self, args=None):
        self.parameters = args
        self.key_words = self.parameters.keywords.split(',')
        self.list_scrapers = [PacketStorm,
                              CXSecurity,
                              Vulners,
                              NationaVulnerabilityDB,
                              WpvulndbB
                              ]

    def run(self, ):
        all_data = {}
        for word_search in self.key_words:
            l_result = []
            l_threads = []
            for scraper_class in self.list_scrapers:
                scraper_instance = scraper_class(word_search)
                scraper_instance.start()
                l_threads.append(scraper_instance)
            [l_result.append(
                {'{0}'.format(th.name_class): th.join()}) for th in l_threads]
            all_data[word_search] = l_result
            show_results(word_search, l_result)
        if self.parameters.html_out:
            write_html(all_data)
            open_url('out.html')
        if self.parameters.txt_out:
            write_txt(all_data)
            print(GENERATE_TXT_FILE)
