#!/usr/bin/env python
'''
@author: Matthew C. Jones, CPA, CISA, OSCP
IS Audits & Consulting, LLC
TJS Deemer Dana LLP

Output functions

See README.md for licensing information and credits

'''

import os

def write_outfile(path, filename, output_text, overwrite=False):
    if output_text:
        if not os.path.exists(path):
            os.makedirs(path)
            
        outfile = os.path.join(path, filename)
        
        if overwrite==True:
            file = open(outfile,'w+')
        else:
            file = open(outfile, 'a+')
            
        file.write(output_text)
        file.close
        

def write_html_index(output_dir):
    '''
    write out an html index page containing links to all of the various files that are
    in the output directory
    
    Accepts output_dir (string) and config (ConfigParser object) from main script
    
    NOTE - output directory variables in main module are full paths, while these
            are folder names only; This is to allow building of relative href
            links in HTML output
    
    '''
    
    
    if os.path.exists(os.path.join(output_dir,"index.html")):
        os.remove(os.path.join(output_dir,"index.html"))
    html_title = "Reconnaissance Results"
    html_body = "<h1>"+html_title+"</h1>\n"
    
    #TODO - make this dynamic!!!!
    html_body += "<h2>Domains</h2>\n"
    html_body += "<iframe src='summary/domains.txt' width=100% height=0px frameborder=0 onload='javascript:resizeIframe(this);'></iframe>\n"
    html_body += "<h2>Hostnames</h2>\n"
    html_body += "<iframe src='summary/hostnames.txt' width=100% height=0px frameborder=0 onload='javascript:resizeIframe(this);'></iframe>\n"
    html_body += "<h2>Hosts</h2>\n"
    html_body += "<iframe src='summary/hosts.txt' width=100% height=0px frameborder=0 onload='javascript:resizeIframe(this);'></iframe>\n"
    html_body += "<h2>Emails</h2>\n"
    html_body += "<iframe src='summary/people.txt' width=100% height=0px frameborder=0 onload='javascript:resizeIframe(this);'></iframe>\n"
    html_body += "<h2>Tool Output</h2>\n"
    
    
    #-----------------------------------------------------------
    # Output data
    
    for dirname in sorted(os.listdir(output_dir)):
        if (not dirname == "db") and (not dirname == "summary"):
            html_body += "<h3>" + dirname +"</h3>\n"
        
            try:
                for fname in sorted(os.listdir(os.path.join(output_dir,dirname))):
                    html_body += " <a href='" + dirname +"/"+ fname + "'>" + fname + "</a><br>\n"
            except:
                pass
        
            html_body += "<br>\n"
    
    
    #-----------------------------------------------------------
    # Output footer
    
    html_body += "<br><hr><br>\n"
    html_body += "Generated by pasv-agrsv recon script by IS Audits & Consulting, LLC - "
    html_body += "<a href=https://github.com/isaudits/pasv-agrsv/>https://github.com/isaudits/pasv-agrsv/</a><br><br>\n"
    
    input_file = open(os.path.join("templates","index.html"))
    html_out = input_file.read()
    html_out = html_out.replace("<!--title-->",html_title)
    html_out = html_out.replace("<!--body-->",html_body)
    write_outfile(output_dir, "index.html", html_out)

if __name__ == '__main__':
    #self test code goes here!!!
    write_html_index("../output/default")