/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner.plugin;

import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.AbstractAppParamPlugin;
import org.parosproxy.paros.network.HttpMessage;

public class TestCrossSiteScript
extends AbstractAppParamPlugin {
    private static final String[] XSS = new String[]{"<SCRIPT>alert(\"" + Constant.getEyeCatcher() + '\"' + ");</SCRIPT>", "<SCRIPT>alert(" + Constant.getEyeCatcher() + ");</SCRIPT>", "bob@<SCRipt>alert(" + Constant.getEyeCatcher() + ")</scrIPT>.parosproxy.org"};

    public int getId() {
        return 40003;
    }

    public String getName() {
        return "Cross site scripting";
    }

    public String[] getDependency() {
        return null;
    }

    public String getDescription() {
        String string = "Cross-site scripting or HTML injection is possible.  Malicious script may be injected into the browser which appeared to be genuine content from the original site.  These scripts can be used to execute arbitrary code or steal customer sensitive information such as user password or cookies.\r\nVery often this is in the form of a hyperlink with the injected script embeded in the query strings.  However, XSS is possible via FORM POST data, cookies, user data sent from another user or shared data retrieved from database.\r\nCurrently this check does not verify XSS from cookie or database.  They should be checked manually if the application retrieve database records from another user's input.";
        return string;
    }

    public int getCategory() {
        return 4;
    }

    public String getSolution() {
        String string = "Do not trust client side input even if there is client side validation.  Sanitize potentially danger characters in the server side.  Very often filtering the <, >, \" characters prevented injected script to be executed in most cases.  However, sometimes other danger meta-characters such as ' , (, ), /, &, ; etc are also needed.\r\nIn addition (or if these characters are needed), HTML encode meta-characters in the response.  For example, encode < as &lt;\r\n";
        return string;
    }

    public String getReference() {
        String string = "<ul><li>The OWASP guide at http://www.owasp.org/documentation/guide</li><li>http://www.technicalinfo.net/papers/CSS.html</li><li>http://www.cgisecurity.org/articles/xss-faq.shtml</li><li>http://www.cert.org/tech_tips/malicious_code_FAQ.html</li><li>http://sandsprite.com/Sleuth/papers/RealWorld_XSS_1.html</li></ul>";
        return string;
    }

    public void init() {
    }

    public void scan(HttpMessage httpMessage, String string, String string2) {
        String string3 = null;
        int n = 0;
        for (int i = 0; i < XSS.length; ++i) {
            httpMessage = this.getNewMsg();
            this.setParameter(httpMessage, string, XSS[i]);
            try {
                this.sendAndReceive(httpMessage);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            string3 = httpMessage.getResponseBody().toString();
            n = string3.indexOf(XSS[i]);
            if (n == -1) continue;
            if (i == 1) {
                if (string3.charAt(n - 1) == '\"' || string3.charAt(n + XSS[i].length()) == '\"') continue;
                this.bingo(2, 0, null, string + "=" + XSS[i], null, httpMessage);
                return;
            }
            this.bingo(2, 1, null, string + "=" + XSS[i], null, httpMessage);
            return;
        }
    }
}

