---
title: "Offensive Security macOS Researcher Exam Report"
author: ["student@youremailaddress.com", "OSID: XXXX"]
date: "2022-11-08"
subject: "Markdown"
keywords: [Markdown, Example]
subtitle: "OSMR Exam Report"
lang: "en"
titlepage: true
titlepage-color: "FFEF96"
titlepage-text-color: "50394C"
titlepage-rule-color: "50394C"
titlepage-rule-height: 2
book: true
classoption: oneside
code-block-font-size: \scriptsize
---
# Offensive-Security OSMR Exam Documentation

The Offensive Security OSMR exam documentation contains all efforts that were conducted in order to pass the Offensive Security macOS Researcher exam.
This report will be graded from a standpoint of correctness and fullness to all aspects of the exam.
The purpose of this report is to ensure that the student has the technical knowledge required to pass the qualifications for the Offensive Security macOS Researcher certification.

## Objective

The objective of this exam is to solve four given assignments as described in the control panel.
The student is tasked with following a methodical approach in analyzing and solving the assignments.
The exam report is meant to be a writeup of the steps taken to solve the assignment, including any analysis performed and code written.

An example page has already been created for you at the latter portions of this document that should give you sample information on what is expected to pass this exam.
Use the sample report as a guideline to get you through the reporting, while removing any headlines that are not relevant to a specific assignment.

## Requirements

The student will be required to fill out this exam documentation fully and to include the following sections:

- High-Level summary of assignment solutions.
- Methodology walkthrough and detailed outline of steps taken through analysis and all written code.
- Each finding with included screenshots, walkthrough, sample code or reference.
- Screenshots of proofs.

# High-Level Summary

A brief description of the assignments that were solved, including the overall exploitation steps.

## Assignment X

## proof.txt / local.txt / secret.txt

Provide the contents of local.txt, proof.txt or secret.txt.

## Initial Analysis

Provide relevant techniques and methods used to perform enumeration and discovery of the application and/or the environment.
The steps taken should be reproducible and easy to understand.
Include any custom code or references to public tools.

## Vulnerability Discovery

Provide relevant analysis steps to locate vulnerability inside the application or environment, this includes results from static analysis and/or dynamic analysis.
Explain the vulnerability identified.

Only the steps that ended up working are required.

## Exploit or Bypass Creation

Provide a description of steps to create the exploit or security control bypass.
At the end of this section the full exploit (or bypass) code should be developed while an explanation of each step should be performed.

## Screenshots

The exam control panel contains a section available to submit your proof files.
The contents of the local.txt, proof.txt or secret.txt files obtained from your exam machines must be submitted in the control panel before your exam has ended.
Note that the control panel will not indicate whether the submitted proof is correct or not.

Each local.txt, proof.txt or secret.txt found must be shown in a screenshot that includes the contents of the file, as well as the IP address of the target by using ipconfig.
