/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.connector;

import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.ManagedConnectionMetaData;
import oracle.jdbc.connector.OracleManagedConnection;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDatabaseMetaData;

public class OracleManagedConnectionMetaData
implements ManagedConnectionMetaData {
    private OracleManagedConnection m_omc = null;
    private OracleDatabaseMetaData m_dbmd = null;

    OracleManagedConnectionMetaData(OracleManagedConnection oracleManagedConnection) throws ResourceException {
        try {
            this.m_omc = oracleManagedConnection;
            OracleConnection oracleConnection = (OracleConnection)oracleManagedConnection.getPhysicalConnection();
            this.m_dbmd = (OracleDatabaseMetaData)oracleConnection.getMetaData();
        }
        catch (Exception exception) {
            EISSystemException eISSystemException = new EISSystemException("Exception: " + exception.getMessage());
            eISSystemException.setLinkedException(exception);
            throw eISSystemException;
        }
    }

    public String getEISProductName() throws ResourceException {
        try {
            return this.m_dbmd.getDatabaseProductName();
        }
        catch (SQLException sQLException) {
            EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
            eISSystemException.setLinkedException((Exception)sQLException);
            throw eISSystemException;
        }
    }

    public String getEISProductVersion() throws ResourceException {
        try {
            return this.m_dbmd.getDatabaseProductVersion();
        }
        catch (Exception exception) {
            EISSystemException eISSystemException = new EISSystemException("Exception: " + exception.getMessage());
            eISSystemException.setLinkedException(exception);
            throw eISSystemException;
        }
    }

    public int getMaxConnections() throws ResourceException {
        try {
            return this.m_dbmd.getMaxConnections();
        }
        catch (SQLException sQLException) {
            EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
            eISSystemException.setLinkedException((Exception)sQLException);
            throw eISSystemException;
        }
    }

    public String getUserName() throws ResourceException {
        try {
            return this.m_dbmd.getUserName();
        }
        catch (SQLException sQLException) {
            EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
            eISSystemException.setLinkedException((Exception)sQLException);
            throw eISSystemException;
        }
    }
}

