/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.util.cmd;

import com.openstego.desktop.util.cmd.CmdLineOption;
import com.openstego.desktop.util.cmd.CmdLineOptions;
import java.util.ArrayList;
import java.util.List;

public class CmdLineParser {
    private final CmdLineOptions parsedOptions = new CmdLineOptions();
    private final List<String> nonStdArgList = new ArrayList<String>();
    private boolean nonStdMixedWithStdOptions = false;

    public CmdLineParser(CmdLineOptions stdOptions, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            CmdLineOption option;
            String arg = args[i];
            String value = null;
            int index = arg.indexOf("=");
            if (index >= 0) {
                value = arg.substring(index + 1);
                arg = arg.substring(0, index);
            }
            if ((option = stdOptions.getOption(arg)) == null) {
                this.nonStdArgList.add(arg);
                continue;
            }
            if (!this.nonStdMixedWithStdOptions && this.nonStdArgList.size() > 0) {
                this.nonStdMixedWithStdOptions = true;
            }
            if (option.takesArg()) {
                if (value != null) {
                    option.setValue(value);
                } else {
                    if (++i < args.length) {
                        arg = args[i];
                    }
                    if (stdOptions.getOption(arg) == null) {
                        option.setValue(arg);
                    }
                }
            }
            this.parsedOptions.add(option);
        }
    }

    public boolean isValid() {
        if (this.nonStdMixedWithStdOptions) {
            return false;
        }
        List<CmdLineOption> list = this.parsedOptions.getList();
        for (CmdLineOption cmdLineOption : list) {
            CmdLineOption option = cmdLineOption;
            if (!option.takesArg() || option.getValue() != null) continue;
            return false;
        }
        return true;
    }

    public String getOptionValue(String name) {
        return this.parsedOptions.getStringValue(name);
    }

    public String getOptionName(int index) {
        return this.parsedOptions.getOption(index).getName();
    }

    public List<CmdLineOption> getParsedOptionsAsList() {
        return this.parsedOptions.getList();
    }

    public List<String> getNonStdOptions() {
        return this.nonStdArgList;
    }

    public CmdLineOptions getParsedOptions() {
        return this.parsedOptions;
    }

    public int getNumOfOptions() {
        return this.parsedOptions.size() + this.nonStdArgList.size();
    }
}

