/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.ui;

import com.openstego.desktop.OpenStego;
import com.openstego.desktop.OpenStegoBulkException;
import com.openstego.desktop.OpenStegoConfig;
import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.OpenStegoPlugin;
import com.openstego.desktop.ui.HelpAboutDialog;
import com.openstego.desktop.ui.OpenStegoFrame;
import com.openstego.desktop.util.CommonUtil;
import com.openstego.desktop.util.LabelUtil;
import com.openstego.desktop.util.ui.WorkerTask;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class OpenStegoUI
extends OpenStegoFrame {
    private static final long serialVersionUID = -7485426167074985636L;
    private static final int READ_EXTENSIONS = 1;
    private static final int WRITE_EXTENSIONS = 2;
    private static final String SIG_FILE_EXTENSION = ".sig";
    private static final LabelUtil labelUtil = LabelUtil.getInstance("OpenStego");
    private static String lastFolder = null;
    private final OpenStegoPlugin<?> dhPlugin;
    private final OpenStegoPlugin<?> wmPlugin;

    public OpenStegoUI(OpenStegoPlugin<?> dhPlugin, OpenStegoPlugin<?> wmPlugin) {
        super(dhPlugin, wmPlugin);
        this.dhPlugin = dhPlugin;
        this.wmPlugin = wmPlugin;
        this.resetGUI();
        URL iconURL = this.getClass().getResource("/images/OpenStegoIcon.png");
        if (iconURL != null) {
            this.setIconImage(new ImageIcon(iconURL).getImage());
        }
        Listener listener = new Listener();
        this.addWindowListener(listener);
        this.getFileExitMenuItem().addActionListener(listener);
        this.getHelpAboutMenuItem().addActionListener(listener);
        this.getEmbedButton().addActionListener(listener);
        this.getExtractButton().addActionListener(listener);
        this.getGenSigButton().addActionListener(listener);
        this.getSignWmButton().addActionListener(listener);
        this.getVerifyWmButton().addActionListener(listener);
        this.getEmbedPanel().getMsgFileButton().addActionListener(listener);
        this.getEmbedPanel().getCoverFileButton().addActionListener(listener);
        this.getEmbedPanel().getStegoFileButton().addActionListener(listener);
        this.getEmbedPanel().getRunEmbedButton().addActionListener(listener);
        this.getExtractPanel().getInputStegoFileButton().addActionListener(listener);
        this.getExtractPanel().getOutputFolderButton().addActionListener(listener);
        this.getExtractPanel().getRunExtractButton().addActionListener(listener);
        this.getGenSigPanel().getSignatureFileButton().addActionListener(listener);
        this.getGenSigPanel().getRunGenSigButton().addActionListener(listener);
        this.getEmbedWmPanel().getFileForWmButton().addActionListener(listener);
        this.getEmbedWmPanel().getSignatureFileButton().addActionListener(listener);
        this.getEmbedWmPanel().getOutputWmFileButton().addActionListener(listener);
        this.getEmbedWmPanel().getRunEmbedWmButton().addActionListener(listener);
        this.getVerifyWmPanel().getInputFileButton().addActionListener(listener);
        this.getVerifyWmPanel().getSignatureFileButton().addActionListener(listener);
        this.getVerifyWmPanel().getRunVerifyWmButton().addActionListener(listener);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - this.getWidth() / 2, screenSize.height / 2 - this.getHeight() / 2);
    }

    protected void resetGUI() {
        this.pack();
        this.getEmbedPanel().getMsgFileTextField().setText("");
        this.getEmbedPanel().getCoverFileTextField().setText("");
        this.getEmbedPanel().getStegoFileTextField().setText("");
        this.getEmbedPanel().getPasswordTextField().setText("");
        this.getEmbedPanel().getConfPasswordTextField().setText("");
        this.getEmbedPanel().getMsgFileTextField().requestFocus();
        try {
            this.dhPlugin.resetConfig();
            if (this.getEmbedPanel().getPluginOptionPanel() != null) {
                this.getEmbedPanel().getPluginOptionPanel().setGUIFromConfig((OpenStegoConfig)this.dhPlugin.getConfig());
            }
        }
        catch (OpenStegoException e) {
            this.handleException(e);
        }
    }

    private void embedData() {
        String outputFileName = this.getEmbedPanel().getStegoFileTextField().getText();
        File outputFile = new File(outputFileName);
        List<File> coverFileList = CommonUtil.parseFileList(this.getEmbedPanel().getCoverFileTextField().getText(), ";");
        String password = new String(this.getEmbedPanel().getPasswordTextField().getPassword());
        String confPassword = new String(this.getEmbedPanel().getConfPasswordTextField().getPassword());
        if (!this.checkMandatory(this.getEmbedPanel().getMsgFileTextField(), labelUtil.getString("gui.label.dhEmbed.msgFile"))) {
            return;
        }
        if (!this.checkMandatory(this.getEmbedPanel().getCoverFileTextField(), labelUtil.getString("gui.label.dhEmbed.coverFile"))) {
            return;
        }
        if (!this.checkMandatory(this.getEmbedPanel().getStegoFileTextField(), labelUtil.getString("gui.label.dhEmbed.stegoFile"))) {
            return;
        }
        if (coverFileList.size() <= 1) {
            if (coverFileList.size() == 0 && !this.getEmbedPanel().getCoverFileTextField().getText().trim().equals("")) {
                JOptionPane.showMessageDialog(this, labelUtil.getString("gui.msg.err.dhEmbed.coverFileNotFound", this.getEmbedPanel().getCoverFileTextField().getText()), labelUtil.getString("gui.msg.title.err"), 0);
                this.getEmbedPanel().getCoverFileTextField().requestFocus();
                return;
            }
            if (outputFile.isDirectory()) {
                JOptionPane.showMessageDialog(this, labelUtil.getString("gui.msg.err.dhEmbed.outputShouldBeFile"), labelUtil.getString("gui.msg.title.err"), 0);
                this.getEmbedPanel().getStegoFileTextField().requestFocus();
                return;
            }
        } else if (!outputFile.isDirectory()) {
            JOptionPane.showMessageDialog(this, labelUtil.getString("gui.msg.err.dhEmbed.outputShouldBeDir"), labelUtil.getString("gui.msg.title.err"), 0);
            this.getEmbedPanel().getStegoFileTextField().requestFocus();
            return;
        }
        if (!password.equals(confPassword)) {
            JOptionPane.showMessageDialog(this, labelUtil.getString("gui.msg.err.dhEmbed.passwordMismatch"), labelUtil.getString("gui.msg.title.err"), 0);
            this.getEmbedPanel().getConfPasswordTextField().requestFocus();
            return;
        }
        if (this.getEmbedPanel().getPluginOptionPanel() != null && !this.getEmbedPanel().getPluginOptionPanel().validateEmbedAction()) {
            return;
        }
        WorkerTask task = new WorkerTask(this, coverFileList, coverFileList.size() > 1){

            @Override
            protected Object doInBackground() throws Exception {
                int processCount = 0;
                int skipCount = 0;
                List coverFileList = (List)this.data;
                String cryptAlgo = (String)OpenStegoUI.this.getEmbedPanel().getEncryptionAlgoComboBox().getSelectedItem();
                String password = new String(OpenStegoUI.this.getEmbedPanel().getPasswordTextField().getPassword());
                String dataFileName = OpenStegoUI.this.getEmbedPanel().getMsgFileTextField().getText();
                String outputFileName = OpenStegoUI.this.getEmbedPanel().getStegoFileTextField().getText();
                File outputFile = new File(outputFileName);
                OpenStegoUI.this.dhPlugin.resetConfig();
                Object config = OpenStegoUI.this.dhPlugin.getConfig();
                ((OpenStegoConfig)config).setUseCompression(true);
                ((OpenStegoConfig)config).setUseEncryption(true);
                ((OpenStegoConfig)config).setEncryptionAlgorithm(cryptAlgo);
                ((OpenStegoConfig)config).setPassword(password);
                if (OpenStegoUI.this.getEmbedPanel().getPluginOptionPanel() != null) {
                    OpenStegoUI.this.getEmbedPanel().getPluginOptionPanel().setConfigFromGUI((OpenStegoConfig)config);
                }
                OpenStego openStego = new OpenStego(OpenStegoUI.this.dhPlugin, (OpenStegoConfig)config);
                if (coverFileList.isEmpty()) {
                    coverFileList.add(null);
                }
                OpenStegoBulkException bulkException = new OpenStegoBulkException();
                for (int i = 0; i < coverFileList.size(); ++i) {
                    this.setProgress(i * 100 / coverFileList.size());
                    File cvrFile = (File)coverFileList.get(i);
                    if (outputFile.isDirectory()) {
                        outputFileName = outputFile.getPath() + File.separator + (cvrFile == null ? "Output" : cvrFile.getName());
                    }
                    if (!OpenStegoUI.this.dhPlugin.getWritableFileExtensions().contains(outputFileName.substring(outputFileName.lastIndexOf(46) + 1).toLowerCase())) {
                        outputFileName = outputFileName + "." + OpenStegoUI.this.dhPlugin.getWritableFileExtensions().get(0);
                    }
                    if (new File(outputFileName).exists() && JOptionPane.showConfirmDialog(this.parent, labelUtil.getString("gui.msg.warn.fileExists", outputFileName), labelUtil.getString("gui.msg.title.warn"), 0, 2) == 1) {
                        if (coverFileList.size() == 1) {
                            this.cancel(true);
                            return null;
                        }
                        ++skipCount;
                        continue;
                    }
                    ++processCount;
                    try {
                        byte[] stegoData = openStego.embedData(dataFileName == null || dataFileName.equals("") ? null : new File(dataFileName), cvrFile, outputFileName);
                        CommonUtil.writeFile(stegoData, outputFileName);
                        continue;
                    }
                    catch (OpenStegoException e) {
                        bulkException.add(cvrFile == null ? "-" : cvrFile.getName(), e);
                    }
                }
                bulkException.throwIfRequired();
                return new Integer[]{processCount, skipCount};
            }

            @Override
            public void done() {
                Integer[] val;
                super.done();
                if (this.isCancelled()) {
                    return;
                }
                try {
                    val = (Integer[])this.get();
                }
                catch (InterruptedException exc) {
                    exc.printStackTrace();
                    return;
                }
                catch (ExecutionException exc) {
                    OpenStegoUI.this.handleException(exc);
                    return;
                }
                JOptionPane.showMessageDialog(this.parent, labelUtil.getString("gui.msg.success.dhEmbed", val[0], val[1]), labelUtil.getString("gui.msg.title.success"), 1);
                ((OpenStegoUI)this.parent).resetGUI();
            }
        };
        task.start();
    }

    private void extractData() {
        if (!this.checkMandatory(this.getExtractPanel().getInputStegoFileTextField(), labelUtil.getString("gui.label.dhExtract.stegoFile"))) {
            return;
        }
        if (!this.checkMandatory(this.getExtractPanel().getOutputFolderTextField(), labelUtil.getString("gui.label.dhExtract.outputDir"))) {
            return;
        }
        WorkerTask task = new WorkerTask(this, null, false){

            @Override
            protected Object doInBackground() throws Exception {
                OpenStegoUI.this.dhPlugin.resetConfig();
                Object config = OpenStegoUI.this.dhPlugin.getConfig();
                OpenStego openStego = new OpenStego(OpenStegoUI.this.dhPlugin, (OpenStegoConfig)config);
                ((OpenStegoConfig)config).setPassword(new String(OpenStegoUI.this.getExtractPanel().getExtractPwdTextField().getPassword()));
                String stegoFileName = OpenStegoUI.this.getExtractPanel().getInputStegoFileTextField().getText();
                String outputFolder = OpenStegoUI.this.getExtractPanel().getOutputFolderTextField().getText();
                List<?> stegoOutput = openStego.extractData(new File(stegoFileName));
                String outputFileName = (String)stegoOutput.get(0);
                File file = new File(outputFolder + File.separator + outputFileName);
                if (file.exists() && JOptionPane.showConfirmDialog(this.parent, labelUtil.getString("gui.msg.warn.fileExists", outputFileName), labelUtil.getString("gui.msg.title.warn"), 0, 2) == 1) {
                    this.cancel(true);
                }
                CommonUtil.writeFile((byte[])stegoOutput.get(1), outputFolder + File.separator + outputFileName);
                return outputFileName;
            }

            @Override
            public void done() {
                String outputFileName;
                super.done();
                if (this.isCancelled()) {
                    return;
                }
                try {
                    outputFileName = (String)this.get();
                }
                catch (InterruptedException exc) {
                    exc.printStackTrace();
                    return;
                }
                catch (ExecutionException exc) {
                    OpenStegoUI.this.handleException(exc);
                    return;
                }
                JOptionPane.showMessageDialog(this.parent, labelUtil.getString("gui.msg.success.dhExtract", outputFileName), labelUtil.getString("gui.msg.title.success"), 1);
                OpenStegoUI.this.getExtractPanel().getInputStegoFileTextField().setText("");
                OpenStegoUI.this.getExtractPanel().getOutputFolderTextField().setText("");
                OpenStegoUI.this.getExtractPanel().getExtractPwdTextField().setText("");
                OpenStegoUI.this.getExtractPanel().getInputStegoFileTextField().requestFocus();
            }
        };
        task.start();
    }

    private void generateSignature() throws OpenStegoException {
        this.wmPlugin.resetConfig();
        Object config = this.wmPlugin.getConfig();
        String inputKey = this.getGenSigPanel().getInputKeyTextField().getText();
        String sigFileName = this.getGenSigPanel().getSignatureFileTextField().getText();
        File sigFile = new File(sigFileName);
        if (!this.checkMandatory(this.getGenSigPanel().getInputKeyTextField(), labelUtil.getString("gui.label.wmGenSig.inputKey"))) {
            return;
        }
        if (!this.checkMandatory(this.getGenSigPanel().getSignatureFileTextField(), labelUtil.getString("gui.label.wmGenSig.sigFile"))) {
            return;
        }
        ((OpenStegoConfig)config).setPassword(inputKey);
        OpenStego openStego = new OpenStego(this.wmPlugin, (OpenStegoConfig)config);
        if (sigFile.exists() && JOptionPane.showConfirmDialog(this, labelUtil.getString("gui.msg.warn.fileExists", sigFileName), labelUtil.getString("gui.msg.title.warn"), 0, 2) == 1) {
            return;
        }
        byte[] sigData = openStego.generateSignature();
        CommonUtil.writeFile(sigData, sigFile);
        JOptionPane.showMessageDialog(this, labelUtil.getString("gui.msg.success.wmGenSig"), labelUtil.getString("gui.msg.title.success"), 1);
        this.getGenSigPanel().getInputKeyTextField().setText("");
        this.getGenSigPanel().getSignatureFileTextField().setText("");
        this.getGenSigPanel().getInputKeyTextField().requestFocus();
    }

    private void embedMark() {
        List<File> inputFileList = CommonUtil.parseFileList(this.getEmbedWmPanel().getFileForWmTextField().getText(), ";");
        File outputFile = new File(this.getEmbedWmPanel().getOutputWmFileTextField().getText());
        if (!this.checkMandatory(this.getEmbedWmPanel().getFileForWmTextField(), labelUtil.getString("gui.label.wmEmbed.fileForWm"))) {
            return;
        }
        if (!this.checkMandatory(this.getEmbedWmPanel().getSignatureFileTextField(), labelUtil.getString("gui.label.wmEmbed.sigFile"))) {
            return;
        }
        if (!this.checkMandatory(this.getEmbedWmPanel().getOutputWmFileTextField(), labelUtil.getString("gui.label.wmEmbed.outputWmFile"))) {
            return;
        }
        if (inputFileList.size() <= 1) {
            if (inputFileList.size() == 0 && !this.getEmbedWmPanel().getFileForWmTextField().getText().trim().equals("")) {
                JOptionPane.showMessageDialog(this, labelUtil.getString("gui.msg.err.wmEmbed.inputFileNotFound", this.getEmbedWmPanel().getFileForWmTextField().getText()), labelUtil.getString("gui.msg.title.err"), 0);
                this.getEmbedWmPanel().getFileForWmTextField().requestFocus();
                return;
            }
            if (outputFile.isDirectory()) {
                JOptionPane.showMessageDialog(this, labelUtil.getString("gui.msg.err.wmEmbed.outputShouldBeFile"), labelUtil.getString("gui.msg.title.err"), 0);
                this.getEmbedWmPanel().getOutputWmFileTextField().requestFocus();
                return;
            }
        } else if (!outputFile.isDirectory()) {
            JOptionPane.showMessageDialog(this, labelUtil.getString("gui.msg.err.wmEmbed.outputShouldBeDir"), labelUtil.getString("gui.msg.title.err"), 0);
            this.getEmbedWmPanel().getOutputWmFileTextField().requestFocus();
            return;
        }
        WorkerTask task = new WorkerTask(this, inputFileList, inputFileList.size() > 1){

            @Override
            protected Object doInBackground() throws Exception {
                int processCount = 0;
                int skipCount = 0;
                List inputFileList = (List)this.data;
                OpenStegoUI.this.wmPlugin.resetConfig();
                OpenStego openStego = new OpenStego(OpenStegoUI.this.wmPlugin, (OpenStegoConfig)OpenStegoUI.this.wmPlugin.getConfig());
                String sigFileName = OpenStegoUI.this.getEmbedWmPanel().getSignatureFileTextField().getText();
                String outputFileName = OpenStegoUI.this.getEmbedWmPanel().getOutputWmFileTextField().getText();
                File outputFile = new File(outputFileName);
                OpenStegoBulkException bulkException = new OpenStegoBulkException();
                for (int i = 0; i < inputFileList.size(); ++i) {
                    this.setProgress(i * 100 / inputFileList.size());
                    File inputFile = (File)inputFileList.get(i);
                    if (outputFile.isDirectory()) {
                        outputFileName = outputFile.getPath() + File.separator + inputFile.getName();
                    }
                    if (!OpenStegoUI.this.wmPlugin.getWritableFileExtensions().contains(outputFileName.substring(outputFileName.lastIndexOf(46) + 1).toLowerCase())) {
                        outputFileName = outputFileName + "." + OpenStegoUI.this.wmPlugin.getWritableFileExtensions().get(0);
                    }
                    if (new File(outputFileName).exists() && JOptionPane.showConfirmDialog(this.parent, labelUtil.getString("gui.msg.warn.fileExists", outputFileName), labelUtil.getString("gui.msg.title.warn"), 0, 2) == 1) {
                        if (inputFileList.size() == 1) {
                            this.cancel(true);
                            return null;
                        }
                        ++skipCount;
                        continue;
                    }
                    ++processCount;
                    try {
                        byte[] wmData = openStego.embedMark(sigFileName == null || sigFileName.equals("") ? null : new File(sigFileName), inputFile, outputFileName);
                        CommonUtil.writeFile(wmData, outputFileName);
                        continue;
                    }
                    catch (OpenStegoException e) {
                        bulkException.add(inputFile.getName(), e);
                    }
                }
                bulkException.throwIfRequired();
                return new Integer[]{processCount, skipCount};
            }

            @Override
            public void done() {
                Integer[] val;
                super.done();
                if (this.isCancelled()) {
                    return;
                }
                try {
                    val = (Integer[])this.get();
                }
                catch (InterruptedException exc) {
                    exc.printStackTrace();
                    return;
                }
                catch (ExecutionException exc) {
                    OpenStegoUI.this.handleException(exc);
                    return;
                }
                JOptionPane.showMessageDialog(this.parent, labelUtil.getString("gui.msg.success.wmEmbed", val[0], val[1]), labelUtil.getString("gui.msg.title.success"), 1);
                OpenStegoUI.this.getEmbedWmPanel().getFileForWmTextField().setText("");
                OpenStegoUI.this.getEmbedWmPanel().getSignatureFileTextField().setText("");
                OpenStegoUI.this.getEmbedWmPanel().getOutputWmFileTextField().setText("");
                OpenStegoUI.this.getEmbedWmPanel().getFileForWmTextField().requestFocus();
            }
        };
        task.start();
    }

    private void checkMark() {
        if (!this.checkMandatory(this.getVerifyWmPanel().getInputFileTextField(), labelUtil.getString("gui.label.wmVerify.inputWmFile"))) {
            return;
        }
        if (!this.checkMandatory(this.getVerifyWmPanel().getSignatureFileTextField(), labelUtil.getString("gui.label.wmVerify.sigFile"))) {
            return;
        }
        List<File> inputFileList = CommonUtil.parseFileList(this.getVerifyWmPanel().getInputFileTextField().getText(), ";");
        if (inputFileList.size() == 0 && !this.getVerifyWmPanel().getInputFileTextField().getText().trim().equals("")) {
            JOptionPane.showMessageDialog(this, labelUtil.getString("gui.msg.err.wmVerify.inputFileNotFound", this.getVerifyWmPanel().getInputFileTextField().getText()), labelUtil.getString("gui.msg.title.err"), 0);
            this.getVerifyWmPanel().getInputFileTextField().requestFocus();
            return;
        }
        WorkerTask task = new WorkerTask(this, inputFileList, inputFileList.size() > 1){

            @Override
            protected Object doInBackground() throws Exception {
                NumberFormat formatter = NumberFormat.getPercentInstance();
                List inputFileList = (List)this.data;
                OpenStegoUI.this.wmPlugin.resetConfig();
                OpenStego openStego = new OpenStego(OpenStegoUI.this.wmPlugin, (OpenStegoConfig)OpenStegoUI.this.wmPlugin.getConfig());
                File sigFile = new File(OpenStegoUI.this.getVerifyWmPanel().getSignatureFileTextField().getText());
                Object[][] tblData = new Object[inputFileList.size()][2];
                for (int i = 0; i < inputFileList.size(); ++i) {
                    this.setProgress(i * 100 / inputFileList.size());
                    File inputFile = (File)inputFileList.get(i);
                    double correlation = openStego.checkMark(inputFile, sigFile);
                    tblData[i][0] = inputFile.getName();
                    String color = correlation > OpenStegoUI.this.wmPlugin.getHighWatermarkLevel() ? "green" : (correlation > OpenStegoUI.this.wmPlugin.getLowWatermarkLevel() ? "#FFBF00" : "red");
                    tblData[i][1] = "<html><span style='color:" + color + "'>\u25cf " + formatter.format(correlation) + "</span></html>";
                }
                this.setProgress(100);
                return tblData;
            }

            @Override
            public void done() {
                Object[][] tblData;
                super.done();
                if (this.isCancelled()) {
                    return;
                }
                try {
                    tblData = (Object[][])this.get();
                }
                catch (InterruptedException exc) {
                    exc.printStackTrace();
                    return;
                }
                catch (ExecutionException exc) {
                    OpenStegoUI.this.handleException(exc);
                    return;
                }
                JTable table = new JTable(tblData, new Object[]{labelUtil.getString("gui.label.wmVerify.result.header.fileName"), labelUtil.getString("gui.label.wmVerify.result.header.strength")}){
                    private static final long serialVersionUID = 2555408155856491941L;

                    @Override
                    public boolean isCellEditable(int rowIndex, int colIndex) {
                        return false;
                    }
                };
                JScrollPane pane = new JScrollPane(table);
                table.setAutoResizeMode(4);
                table.setDragEnabled(false);
                table.setCellSelectionEnabled(false);
                table.setRowSelectionAllowed(false);
                table.setPreferredScrollableViewportSize(new Dimension(400, 150));
                JPanel panel = new JPanel(new BorderLayout());
                JLabel header = new JLabel(labelUtil.getString("gui.msg.success.wmVerify"));
                header.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
                panel.add((Component)header, "North");
                panel.add((Component)pane, "Center");
                JOptionPane.showMessageDialog(this.parent, panel, labelUtil.getString("gui.msg.title.results"), 1);
                OpenStegoUI.this.getVerifyWmPanel().getInputFileTextField().setText("");
                OpenStegoUI.this.getVerifyWmPanel().getSignatureFileTextField().setText("");
                OpenStegoUI.this.getVerifyWmPanel().getInputFileTextField().requestFocus();
            }
        };
        task.start();
    }

    private void selectFile(String action) throws OpenStegoException {
        JTextField textField;
        String title;
        FileBrowser browser = new FileBrowser();
        String filterDesc = null;
        List<String> allowedExts = null;
        int allowFileDir = 1;
        boolean multiSelect = false;
        OpenStegoPlugin<?> plugin = action.startsWith("BROWSE_DH_") ? this.dhPlugin : this.wmPlugin;
        int coverFileListSize = CommonUtil.parseFileList(this.getEmbedPanel().getCoverFileTextField().getText(), ";").size();
        int wmInputFileListSize = CommonUtil.parseFileList(this.getEmbedWmPanel().getFileForWmTextField().getText(), ";").size();
        switch (action) {
            case "BROWSE_DH_EMB_MSGFILE": {
                title = labelUtil.getString("gui.filer.title.dhEmbed.msgFile");
                textField = this.getEmbedPanel().getMsgFileTextField();
                break;
            }
            case "BROWSE_DH_EMB_CVRFILE": {
                title = labelUtil.getString("gui.filer.title.dhEmbed.coverFile");
                filterDesc = labelUtil.getString("gui.filer.filter.coverFiles", this.getExtensionsString(plugin, 1));
                allowedExts = this.getExtensionsList(plugin, 1);
                textField = this.getEmbedPanel().getCoverFileTextField();
                multiSelect = true;
                break;
            }
            case "BROWSE_DH_EMB_STGFILE": {
                title = labelUtil.getString("gui.filer.title.dhEmbed.stegoFile");
                if (coverFileListSize > 1) {
                    allowFileDir = 2;
                } else {
                    filterDesc = labelUtil.getString("gui.filer.filter.stegoFiles", this.getExtensionsString(plugin, 2));
                    allowedExts = this.getExtensionsList(plugin, 2);
                }
                textField = this.getEmbedPanel().getStegoFileTextField();
                break;
            }
            case "BROWSE_DH_EXT_STGFILE": {
                title = labelUtil.getString("gui.filer.title.dhExtract.stegoFile");
                filterDesc = labelUtil.getString("gui.filer.filter.stegoFiles", this.getExtensionsString(plugin, 2));
                allowedExts = this.getExtensionsList(plugin, 2);
                textField = this.getExtractPanel().getInputStegoFileTextField();
                break;
            }
            case "BROWSE_DH_EXT_OUTDIR": {
                title = labelUtil.getString("gui.filer.title.dhExtract.outputDir");
                allowFileDir = 2;
                textField = this.getExtractPanel().getOutputFolderTextField();
                break;
            }
            case "BROWSE_WM_GSG_SIGFILE": {
                title = labelUtil.getString("gui.filer.title.wmGenSig.sigFile");
                filterDesc = labelUtil.getString("gui.filer.filter.sigFiles", "*.sig");
                allowedExts = Collections.singletonList(SIG_FILE_EXTENSION);
                textField = this.getGenSigPanel().getSignatureFileTextField();
                break;
            }
            case "BROWSE_WM_EMB_INPFILE": {
                title = labelUtil.getString("gui.filer.title.wmEmbed.fileForWm");
                filterDesc = labelUtil.getString("gui.filer.filter.filesForWm", this.getExtensionsString(plugin, 1));
                allowedExts = this.getExtensionsList(plugin, 1);
                textField = this.getEmbedWmPanel().getFileForWmTextField();
                multiSelect = true;
                break;
            }
            case "BROWSE_WM_EMB_SIGFILE": {
                title = labelUtil.getString("gui.filer.title.wmEmbed.sigFile");
                filterDesc = labelUtil.getString("gui.filer.filter.sigFiles", "*.sig");
                allowedExts = Collections.singletonList(SIG_FILE_EXTENSION);
                textField = this.getEmbedWmPanel().getSignatureFileTextField();
                break;
            }
            case "BROWSE_WM_EMB_OUTFILE": {
                title = labelUtil.getString("gui.filer.title.wmEmbed.outputWmFile");
                if (wmInputFileListSize > 1) {
                    allowFileDir = 2;
                } else {
                    filterDesc = labelUtil.getString("gui.filer.filter.wmFiles", this.getExtensionsString(plugin, 2));
                    allowedExts = this.getExtensionsList(plugin, 2);
                }
                textField = this.getEmbedWmPanel().getOutputWmFileTextField();
                break;
            }
            case "BROWSE_WM_VER_INPFILE": {
                title = labelUtil.getString("gui.filer.title.wmExtract.inputWmFile");
                filterDesc = labelUtil.getString("gui.filer.filter.wmFiles", this.getExtensionsString(plugin, 2));
                allowedExts = this.getExtensionsList(plugin, 2);
                textField = this.getVerifyWmPanel().getInputFileTextField();
                multiSelect = true;
                break;
            }
            case "BROWSE_WM_VER_SIGFILE": {
                title = labelUtil.getString("gui.filer.title.wmExtract.sigFile");
                filterDesc = labelUtil.getString("gui.filer.filter.sigFiles", "*.sig");
                allowedExts = Collections.singletonList(SIG_FILE_EXTENSION);
                textField = this.getVerifyWmPanel().getSignatureFileTextField();
                break;
            }
            default: {
                throw new OpenStegoException(new RuntimeException("Unknown action: " + action));
            }
        }
        String fileName = browser.getFileName(title, filterDesc, allowedExts, allowFileDir, multiSelect);
        if (fileName != null) {
            if ((action.equals("BROWSE_DH_EMB_STGFILE") && coverFileListSize <= 1 || action.equals("BROWSE_WM_EMB_OUTFILE") && wmInputFileListSize <= 1) && !plugin.getWritableFileExtensions().contains(fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase())) {
                fileName = fileName + "." + plugin.getWritableFileExtensions().get(0);
            }
            if (action.equals("BROWSE_WM_GSG_SIGFILE") && !fileName.toLowerCase().endsWith(SIG_FILE_EXTENSION)) {
                fileName = fileName + SIG_FILE_EXTENSION;
            }
            textField.setText(fileName);
        }
    }

    private void close() {
        System.exit(0);
    }

    private void showHelpAbout() {
        HelpAboutDialog aboutDialog = new HelpAboutDialog(this);
        aboutDialog.setVisible(true);
    }

    private void handleException(Throwable ex) {
        Throwable cause;
        Object msg = ex instanceof OutOfMemoryError ? labelUtil.getString("err.memory.full") : (ex instanceof OpenStegoException ? ex.getMessage() : (ex instanceof OpenStegoBulkException ? this.getBulkMessage((OpenStegoBulkException)ex) : ((cause = ex.getCause()) instanceof OpenStegoException ? cause.getMessage() : (cause instanceof OpenStegoBulkException ? this.getBulkMessage((OpenStegoBulkException)cause) : ex.getMessage()))));
        if (msg == null || msg instanceof String && ((String)msg).trim().equals("")) {
            StringWriter writer = new StringWriter();
            ex.printStackTrace(new PrintWriter(writer));
            msg = writer.toString();
        }
        ex.printStackTrace();
        JOptionPane.showMessageDialog(this, msg, labelUtil.getString("gui.msg.title.err"), 0);
    }

    private Object getBulkMessage(OpenStegoBulkException ex) {
        int len = ex.getExceptions().size();
        if (len == 1) {
            return ex.getExceptions().get(0);
        }
        String prefix = "<html><head><style type='text/css'>table, th, td { border: 1px solid #333; }table { border-width: 0 0 1px 1px }th, td { border-width: 1px 1px 0 0 }td { background-color: white }</style></head><body><table border='0' cellspacing='0' cellpadding='5'>";
        StringBuilder sb = new StringBuilder(prefix).append("<tr><th>").append(labelUtil.getString("gui.msg.err.header.file")).append("</th><th>").append(labelUtil.getString("gui.msg.err.header.error")).append("</th></tr>");
        for (int i = 0; i < ex.getKeys().size(); ++i) {
            sb.append("<tr><td>").append(ex.getKeys().get(i)).append("</td><td>").append(ex.getExceptions().get(i).getMessage()).append("</td></tr>");
        }
        sb.append("</table></body></html>");
        return new JLabel(sb.toString());
    }

    private boolean checkMandatory(JTextField textField, String fieldName) {
        if (!textField.isEnabled()) {
            return true;
        }
        String value = textField.getText();
        if (value == null || value.trim().equals("")) {
            JOptionPane.showMessageDialog(this, labelUtil.getString("gui.msg.err.mandatoryCheck", fieldName), labelUtil.getString("gui.msg.title.err"), 0);
            textField.requestFocus();
            return false;
        }
        return true;
    }

    private String getExtensionsString(OpenStegoPlugin<?> plugin, int flag) throws OpenStegoException {
        StringBuilder output = new StringBuilder();
        List<String> list = this.getExtensionsList(plugin, flag);
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                output.append(", ");
            }
            output.append("*").append(list.get(i));
        }
        return output.toString();
    }

    private List<String> getExtensionsList(OpenStegoPlugin<?> plugin, int flag) throws OpenStegoException {
        List<String> list;
        ArrayList<String> output = new ArrayList<String>();
        if (flag == 1) {
            list = plugin.getReadableFileExtensions();
        } else if (flag == 2) {
            list = plugin.getWritableFileExtensions();
        } else {
            throw new OpenStegoException(new RuntimeException("Unknown flag: " + flag));
        }
        for (String s : list) {
            output.add("." + s);
        }
        return output;
    }

    static class FileBrowser {
        public static final int ALLOW_FILE = 1;
        public static final int ALLOW_DIRECTORY = 2;
        public static final int ALLOW_FILE_AND_DIR = 3;

        FileBrowser() {
        }

        public String getFileName(String dialogTitle, String filterDesc, List<String> allowedExts, int allowFileDir, boolean multiSelect) {
            String fileName = null;
            JFileChooser chooser = new JFileChooser(lastFolder);
            chooser.setMultiSelectionEnabled(multiSelect);
            switch (allowFileDir) {
                case 1: {
                    chooser.setFileSelectionMode(0);
                    break;
                }
                case 2: {
                    chooser.setFileSelectionMode(1);
                    break;
                }
                case 3: {
                    chooser.setFileSelectionMode(2);
                }
            }
            if (filterDesc != null) {
                chooser.setFileFilter(new FileBrowserFilter(filterDesc, allowedExts));
            }
            chooser.setDialogTitle(dialogTitle);
            int retVal = chooser.showOpenDialog(null);
            if (retVal == 0) {
                if (multiSelect) {
                    StringBuilder fileList = new StringBuilder();
                    File[] files = chooser.getSelectedFiles();
                    for (int i = 0; i < files.length; ++i) {
                        if (i != 0) {
                            fileList.append(";");
                        }
                        fileList.append(files[i].getPath());
                    }
                    fileName = fileList.toString();
                } else {
                    fileName = chooser.getSelectedFile().getPath();
                }
                lastFolder = chooser.getSelectedFile().getParent();
            }
            return fileName;
        }

        static class FileBrowserFilter
        extends FileFilter {
            private final String filterDesc;
            private final List<String> allowedExts;

            public FileBrowserFilter(String filterDesc, List<String> allowedExts) {
                this.filterDesc = filterDesc;
                this.allowedExts = allowedExts;
            }

            @Override
            public boolean accept(File file) {
                if (file != null) {
                    if (this.allowedExts == null || this.allowedExts.size() == 0 || file.isDirectory()) {
                        return true;
                    }
                    for (String allowedExt : this.allowedExts) {
                        if (!file.getName().toLowerCase().endsWith(allowedExt)) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public String getDescription() {
                return this.filterDesc;
            }
        }
    }

    class Listener
    implements ActionListener,
    WindowListener {
        Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void actionPerformed(ActionEvent ev) {
            try {
                String action = ev.getActionCommand();
                if (action.startsWith("MENU_")) {
                    if (action.equals("MENU_FILE_EXIT")) {
                        OpenStegoUI.this.close();
                        return;
                    }
                    if (!action.equals("MENU_HELP_ABOUT")) return;
                    OpenStegoUI.this.showHelpAbout();
                    return;
                }
                if (action.startsWith("BROWSE_")) {
                    OpenStegoUI.this.selectFile(action);
                    return;
                }
                if (action.startsWith("SWITCH_")) {
                    OpenStegoUI.this.getMainPanel().removeAll();
                    switch (action) {
                        case "SWITCH_DH_EMBED": {
                            OpenStegoUI.this.getMainPanel().add(OpenStegoUI.this.getEmbedPanel());
                            OpenStegoUI.this.getHeader().setText(labelUtil.getString("gui.label.panelHeader.dhEmbed"));
                            break;
                        }
                        case "SWITCH_DH_EXTRACT": {
                            OpenStegoUI.this.getMainPanel().add(OpenStegoUI.this.getExtractPanel());
                            OpenStegoUI.this.getHeader().setText(labelUtil.getString("gui.label.panelHeader.dhExtract"));
                            break;
                        }
                        case "SWITCH_WM_GENSIG": {
                            OpenStegoUI.this.getMainPanel().add(OpenStegoUI.this.getGenSigPanel());
                            OpenStegoUI.this.getHeader().setText(labelUtil.getString("gui.label.panelHeader.wmGenSig"));
                            break;
                        }
                        case "SWITCH_WM_EMBED": {
                            OpenStegoUI.this.getMainPanel().add(OpenStegoUI.this.getEmbedWmPanel());
                            OpenStegoUI.this.getHeader().setText(labelUtil.getString("gui.label.panelHeader.wmEmbed"));
                            break;
                        }
                        case "SWITCH_WM_VERIFY": {
                            OpenStegoUI.this.getMainPanel().add(OpenStegoUI.this.getVerifyWmPanel());
                            OpenStegoUI.this.getHeader().setText(labelUtil.getString("gui.label.panelHeader.wmVerify"));
                            break;
                        }
                    }
                    OpenStegoUI.this.getMainPanel().revalidate();
                    OpenStegoUI.this.getMainPanel().repaint();
                    return;
                }
                if (!action.startsWith("RUN_")) return;
                try {
                    OpenStegoUI.this.setCursor(Cursor.getPredefinedCursor(3));
                    switch (action) {
                        case "RUN_DH_EMBED": {
                            OpenStegoUI.this.embedData();
                            return;
                        }
                        case "RUN_DH_EXTRACT": {
                            OpenStegoUI.this.extractData();
                            return;
                        }
                        case "RUN_WM_GENSIG": {
                            OpenStegoUI.this.generateSignature();
                            return;
                        }
                        case "RUN_WM_EMBED": {
                            OpenStegoUI.this.embedMark();
                            return;
                        }
                        case "RUN_WM_VERIFY": {
                            OpenStegoUI.this.checkMark();
                            return;
                        }
                    }
                    return;
                }
                finally {
                    OpenStegoUI.this.setCursor(Cursor.getDefaultCursor());
                }
            }
            catch (Throwable ex) {
                OpenStegoUI.this.handleException(ex);
            }
        }

        @Override
        public void windowClosing(WindowEvent ev) {
            OpenStegoUI.this.close();
        }

        @Override
        public void windowActivated(WindowEvent ev) {
        }

        @Override
        public void windowClosed(WindowEvent ev) {
        }

        @Override
        public void windowDeactivated(WindowEvent ev) {
        }

        @Override
        public void windowDeiconified(WindowEvent ev) {
        }

        @Override
        public void windowIconified(WindowEvent ev) {
        }

        @Override
        public void windowOpened(WindowEvent ev) {
        }
    }
}

