/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.plugin.dwtdugad;

import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.plugin.dwtdugad.DWTDugadErrors;
import com.openstego.desktop.plugin.template.image.WMImagePluginTemplate;
import com.openstego.desktop.util.ImageHolder;
import com.openstego.desktop.util.ImageUtil;
import com.openstego.desktop.util.LabelUtil;
import com.openstego.desktop.util.StringUtil;
import com.openstego.desktop.util.dwt.DWT;
import com.openstego.desktop.util.dwt.Image;
import com.openstego.desktop.util.dwt.ImageTree;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Random;

public class DWTDugadPlugin
extends WMImagePluginTemplate {
    private static final LabelUtil labelUtil = LabelUtil.getInstance("DWTDUGAD");
    public static final String NAMESPACE = "DWTDUGAD";
    private static final String SIG_MARKER = "DGSG";
    private static final String WM_MARKER = "DGWM";

    public DWTDugadPlugin() {
        LabelUtil.addNamespace(NAMESPACE, "i18n.DWTDugadPluginLabels");
        DWTDugadErrors.init();
    }

    @Override
    public String getName() {
        return "DWTDugad";
    }

    @Override
    public String getDescription() {
        return labelUtil.getString("plugin.description");
    }

    @Override
    public byte[] embedData(byte[] msg, String msgFileName, byte[] cover, String coverFileName, String stegoFileName) throws OpenStegoException {
        ImageTree dwtTree;
        if (cover == null) {
            throw new OpenStegoException(null, NAMESPACE, 1);
        }
        ImageHolder image = ImageUtil.byteArrayToImage(cover, coverFileName);
        int imgType = image.getImage().getType();
        int cols = image.getImage().getWidth();
        int rows = image.getImage().getHeight();
        List<int[][]> yuv = ImageUtil.getYuvFromImage(image.getImage());
        int[][] luminance = yuv.get(0);
        Signature sig = new Signature(msg);
        DWT dwt = new DWT(cols, rows, sig.filterID, sig.decompositionLevel, sig.waveletFilterMethod);
        ImageTree s = dwtTree = dwt.forwardDWT(luminance);
        for (int i = 0; i < sig.decompositionLevel; ++i) {
            if (s.getHorizontal() == null || s.getVertical() == null || s.getDiagonal() == null) {
                throw new OpenStegoException(null, NAMESPACE, 3);
            }
            this.wmSubBand(s.getHorizontal().getImage(), sig.watermark, sig.watermarkLength, sig.alpha, sig.castingThreshold);
            this.wmSubBand(s.getVertical().getImage(), sig.watermark, sig.watermarkLength, sig.alpha, sig.castingThreshold);
            this.wmSubBand(s.getDiagonal().getImage(), sig.watermark, sig.watermarkLength, sig.alpha, sig.castingThreshold);
            s = s.getCoarse();
        }
        dwt.inverseDWT(dwtTree, luminance);
        yuv.set(0, luminance);
        image.setImage(ImageUtil.getImageFromYuv(yuv, imgType));
        return ImageUtil.imageToByteArray(image, stegoFileName, this);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] extractData(byte[] stegoData, String stegoFileName, byte[] origSigData) throws OpenStegoException {
        ImageTree dwtTree;
        ImageHolder image = ImageUtil.byteArrayToImage(stegoData, stegoFileName);
        int cols = image.getImage().getWidth();
        int rows = image.getImage().getHeight();
        int[][] luminance = ImageUtil.getYuvFromImage(image.getImage()).get(0);
        Signature sig = new Signature(origSigData);
        DWT dwt = new DWT(cols, rows, sig.filterID, sig.decompositionLevel, sig.waveletFilterMethod);
        ImageTree s = dwtTree = dwt.forwardDWT(luminance);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeBytes(WM_MARKER);
                oos.writeInt(sig.decompositionLevel);
                oos.writeDouble(sig.alpha);
                for (int i = 0; i < sig.decompositionLevel; ++i) {
                    Object[] vals = this.invWmSubBand(s.getHorizontal().getImage(), sig.watermark, sig.watermarkLength, sig.detectionThreshold);
                    oos.writeInt((Integer)vals[0]);
                    oos.writeDouble((Double)vals[1]);
                    oos.writeDouble((Double)vals[2]);
                    vals = this.invWmSubBand(s.getVertical().getImage(), sig.watermark, sig.watermarkLength, sig.detectionThreshold);
                    oos.writeInt((Integer)vals[0]);
                    oos.writeDouble((Double)vals[1]);
                    oos.writeDouble((Double)vals[2]);
                    vals = this.invWmSubBand(s.getDiagonal().getImage(), sig.watermark, sig.watermarkLength, sig.detectionThreshold);
                    oos.writeInt((Integer)vals[0]);
                    oos.writeDouble((Double)vals[1]);
                    oos.writeDouble((Double)vals[2]);
                    s = s.getCoarse();
                }
                oos.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException ioEx) {
            throw new OpenStegoException(ioEx);
        }
    }

    @Override
    public byte[] generateSignature() throws OpenStegoException {
        Random rand = new Random(StringUtil.passwordHash(this.config.getPassword()));
        Signature sig = new Signature(rand);
        return sig.getSigData();
    }

    @Override
    public double getWatermarkCorrelation(byte[] origSigData, byte[] watermarkData) throws OpenStegoException {
        int n;
        byte[] markArr = new byte[WM_MARKER.length()];
        int ok = 0;
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(watermarkData));
            n = ois.read(markArr, 0, WM_MARKER.length());
            if (n == -1 || !WM_MARKER.equals(new String(markArr))) {
                throw new OpenStegoException(null, NAMESPACE, 2);
            }
            int level = ois.readInt();
            double alpha = ois.readDouble();
            n = level * 3;
            for (int i = 0; i < level; ++i) {
                int m = ois.readInt();
                double z = ois.readDouble();
                double v = ois.readDouble();
                if (m != 0) {
                    ok += z > v * alpha ? 1 : 0;
                } else {
                    --n;
                }
                m = ois.readInt();
                z = ois.readDouble();
                v = ois.readDouble();
                if (m != 0) {
                    ok += z > v * alpha ? 1 : 0;
                } else {
                    --n;
                }
                m = ois.readInt();
                z = ois.readDouble();
                v = ois.readDouble();
                if (m != 0) {
                    ok += z > v * alpha ? 1 : 0;
                    continue;
                }
                --n;
            }
        }
        catch (IOException ioEx) {
            throw new OpenStegoException(ioEx);
        }
        return (double)ok / (double)n;
    }

    @Override
    public String getUsage() {
        return labelUtil.getString("plugin.usage");
    }

    private void wmSubBand(Image img, double[] wm, int n, double a, double threshold) {
        for (int i = 0; i < img.getWidth() * img.getHeight(); ++i) {
            if (!(Math.abs(img.getData()[i]) > threshold)) continue;
            double[] dArray = img.getData();
            int n2 = i;
            dArray[n2] = dArray[n2] + a * Math.abs(img.getData()[i]) * wm[i % n];
        }
    }

    private Object[] invWmSubBand(Image img, double[] wm, int n, double threshold) {
        int m = 0;
        double z = 0.0;
        double v = 0.0;
        for (int i = 0; i < img.getWidth() * img.getHeight(); ++i) {
            if (!(img.getData()[i] > threshold)) continue;
            z += img.getData()[i] * wm[i % n];
            v += Math.abs(img.getData()[i]);
            ++m;
        }
        return new Object[]{m, z, v};
    }

    private static class Signature {
        private final byte[] sig = "DGSG".getBytes(StandardCharsets.UTF_8);
        private int watermarkLength = 1000;
        private int waveletFilterMethod = 2;
        private int filterID = 1;
        private int decompositionLevel = 3;
        private double alpha = 0.2;
        private double castingThreshold = 40.0;
        private double detectionThreshold = 50.0;
        private final double[] watermark;

        public Signature(Random rand) {
            this.watermark = new double[this.watermarkLength];
            for (int i = 0; i < this.watermarkLength; i += 2) {
                double x2;
                double x1;
                double x;
                while ((x = (x1 = 2.0 * rand.nextDouble() - 1.0) * x1 + (x2 = 2.0 * rand.nextDouble() - 1.0) * x2) >= 1.0) {
                }
                double r = Math.sqrt(-2.0 * Math.log(x) / x);
                this.watermark[i] = x1 *= r;
                this.watermark[i + 1] = x2 *= r;
            }
        }

        public Signature(byte[] sigData) throws OpenStegoException {
            byte[] inputSig = new byte[this.sig.length];
            try {
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(sigData));
                int n = ois.read(inputSig, 0, this.sig.length);
                if (n == -1 || !new String(this.sig).equals(new String(inputSig))) {
                    throw new OpenStegoException(null, DWTDugadPlugin.NAMESPACE, 2);
                }
                this.watermarkLength = ois.readInt();
                this.waveletFilterMethod = ois.readInt();
                this.filterID = ois.readInt();
                this.decompositionLevel = ois.readInt();
                this.alpha = ois.readDouble();
                this.castingThreshold = ois.readDouble();
                this.detectionThreshold = ois.readDouble();
                this.watermark = new double[this.watermarkLength];
                for (int i = 0; i < this.watermarkLength; ++i) {
                    this.watermark[i] = ois.readDouble();
                }
            }
            catch (IOException ioEx) {
                throw new OpenStegoException(ioEx);
            }
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public byte[] getSigData() throws OpenStegoException {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                byte[] byArray;
                try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                    oos.write(this.sig);
                    oos.writeInt(this.watermarkLength);
                    oos.writeInt(this.waveletFilterMethod);
                    oos.writeInt(this.filterID);
                    oos.writeInt(this.decompositionLevel);
                    oos.writeDouble(this.alpha);
                    oos.writeDouble(this.castingThreshold);
                    oos.writeDouble(this.detectionThreshold);
                    for (int i = 0; i < this.watermarkLength; ++i) {
                        oos.writeDouble(this.watermark[i]);
                    }
                    oos.flush();
                    byArray = baos.toByteArray();
                }
                return byArray;
            }
            catch (IOException ioEx) {
                throw new OpenStegoException(ioEx);
            }
        }
    }
}

