#!/usr/bin/env python
##
# omnibus - deadbits
# malware patrol search
##
from http import get

from common import warning
from common import get_apikey


class Plugin(object):
    def __init__(self, artifact):
        self.artifact = artifact
        self.artifact['data']['malwarepatrol'] = None
        self.api_key = get_apikey('malwarepatrol')
        if self.api_key == '':
            raise TypeError('API keys cannot be left blank | set all keys in etc/apikeys.json')
        self.headers = {'User-Agent': 'OSINT Omnibus (https://github.com/InQuest/Omnibus)'}


    def run(self):
        url = 'http://lists.malwarepatrol.net/cgi/getfile?receipt=%s&product=8&list=smoothwall' % self.api_key

        try:
            status, response = get(url, headers=self.headers)

            if status:
                for line in response.content.split('\n'):
                    if line.startswith('#') or len(line) > 2:
                        continue

                    if line.startswith(self.artifact['name']):
                        self.artifact['data']['malwarepatrol'] = 'found'
                    else:
                        self.artifact['data']['malwarepatrol'] = 'not listed'
        except Exception as err:
            warning('Caught exception in module (%s)' % str(err))


def main(artifact):
    plugin = Plugin(artifact)
    plugin.run()
    return plugin.artifact
