#!/usr/bin/env python

__description__ = 'MSG plugin for oledump.py'
__author__ = 'Didier Stevens'
__version__ = '0.0.5'
__date__ = '2024/04/07'

"""

Source code put in public domain by Didier Stevens, no Copyright
https://DidierStevens.com
Use at your own risk

History:
  2017/12/16: start
  2017/12/17: 0.0.2 added options -d and -a
  2017/12/30: removed option -a (becomes default) and -d; and added option -n
  2018/07/14: 0.0.3 added option -k
  2019/11/04: 0.0.4 added tag 1009
  2024/04/06: 0.0.5 added properties stream parsing
  2024/04/07: continue

Todo:
"""

import struct
import re
import optparse

class cMSG(cPluginParent):
    macroOnly = False
    indexQuiet = True
    name = 'MSG plugin'

    def __init__(self, name, stream, options):
        self.streamname = name
        self.stream = stream
        self.options = options
        self.ran = False

    def Analyze(self):
        result = []

        #http://www.fileformat.info/format/outlookmsg/
        dCodes = {
          '001A': 'Message class',
          '0037': 'Subject',
          '003D': 'Subject prefix',
          '0040': 'Received by name',
          '0042': 'Sent repr name',
          '0044': 'Rcvd repr name',
          '004D': 'Org author name',
          '0050': 'Reply rcipnt names',
          '005A': 'Org sender name',
          '0064': 'Sent repr adrtype',
          '0065': 'Sent repr email',
          '0070': 'Topic',
          '0075': 'Rcvd by adrtype',
          '0076': 'Rcvd by email',
          '0077': 'Repr adrtype',
          '0078': 'Repr email',
          '007D': 'Message header',
          '0C1A': 'Sender name',
          '0C1E': 'Sender adr type',
          '0C1F': 'Sender email',
          '0E02': 'Display BCC',
          '0E03': 'Display CC',
          '0E04': 'Display To',
          '0E1D': 'Subject (normalized)',
          '0E28': 'Recvd account1(?)',
          '0E29': 'Recvd account2(?)',
          '1000': 'Message body',
          '1008': 'RTF sync body tag',
          '1009': 'RTF Compressed',
          '1035': 'Message ID (?)',
          '1046': 'Sender email(?)',
          '3001': 'Display name',
          '3002': 'Address type',
          '3003': 'Email address',
          '39FE': '7-bit email (?)',
          '39FF': '7-bit display name',
          '3701': 'Attachment data',
          '3703': 'Attach extension',
          '3704': 'Attach filename',
          '3707': 'Attach long filename',
          '370E': 'Attach mime tag',
          '3712': 'Attach ID (?)',
          '3A00': 'Account',
          '3A02': 'Callback phone no',
          '3A05': 'Generation',
          '3A06': 'Given name',
          '3A08': 'Business phone',
          '3A09': 'Home phone',
          '3A0A': 'Initials',
          '3A0B': 'Keyword',
          '3A0C': 'Language',
          '3A0D': 'Location',
          '3A11': 'Surname',
          '3A15': 'Postal address',
          '3A16': 'Company name',
          '3A17': 'Title',
          '3A18': 'Department',
          '3A19': 'Office location',
          '3A1A': 'Primary phone',
          '3A1B': 'Business phone 2',
          '3A1C': 'Mobile phone',
          '3A1D': 'Radio phone no',
          '3A1E': 'Car phone no',
          '3A1F': 'Other phone',
          '3A20': 'Transmit dispname',
          '3A21': 'Pager',
          '3A22': 'User certificate',
          '3A23': 'Primary Fax',
          '3A24': 'Business Fax',
          '3A25': 'Home Fax',
          '3A26': 'Country',
          '3A27': 'Locality',
          '3A28': 'State/Province',
          '3A29': 'Street address',
          '3A2A': 'Postal Code',
          '3A2B': 'Post Office Box',
          '3A2C': 'Telex',
          '3A2D': 'ISDN',
          '3A2E': 'Assistant phone',
          '3A2F': 'Home phone 2',
          '3A30': 'Assistant',
          '3A44': 'Middle name',
          '3A45': 'Dispname prefix',
          '3A46': 'Profession',
          '3A48': 'Spouse name',
          '3A4B': 'TTYTTD radio phone',
          '3A4C': 'FTP site',
          '3A4E': 'Manager name',
          '3A4F': 'Nickname',
          '3A51': 'Business homepage',
          '3A57': 'Company main phone',
          '3A58': 'Childrens names',
          '3A59': 'Home City',
          '3A5A': 'Home Country',
          '3A5B': 'Home Postal Code',
          '3A5C': 'Home State/Provnce',
          '3A5D': 'Home Street',
          '3A5F': 'Other adr City',
          '3A60': 'Other adr Country',
          '3A61': 'Other adr PostCode',
          '3A62': 'Other adr Province',
          '3A63': 'Other adr Street',
          '3A64': 'Other adr PO box',
          '3FF7': 'Server   (?)',
          '3FF8': 'Creator1 (?)',
          '3FFA': 'Creator2 (?)',
          '3FFC': 'To email (?)',
          '403D': 'To adrtype(?)',
          '403E': 'To email (?)',
          '5FF6': 'To       (?)'
        }

        dTypes = {'001E': 'ASC', '001F': 'UNI', '0102': 'BIN'}

        dPropertyTypes = {
            0x0000: 'PtypUnspecified',
            0x0001: 'PtypNull',
            0x0002: 'PtypInteger16',
            0x0003: 'PtypInteger32',
            0x0004: 'PtypFloating32',
            0x0005: 'PtypFloating64',
            0x0006: 'PtypCurrency',
            0x0007: 'PtypFloatingTime',
            0x000A: 'PtypErrorCode',
            0x000B: 'PtypBoolean',
            0x000D: 'PtypObject',
            0x0014: 'PtypInteger64',
            0x001E: 'PtypString8',
            0x001F: 'PtypString',
            0x0040: 'PtypTime',
            0x0048: 'PtypGuid',
            0x00FB: 'PtypServerId',
            0x00FD: 'PtypRestriction',
            0x00FE: 'PtypRuleAction',
            0x0102: 'PtypBinary',
            0x1002: 'PtypMultipleInteger16',
            0x1003: 'PtypMultipleInteger32',
            0x1004: 'PtypMultipleFloating32',
            0x1005: 'PtypMultipleFloating64',
            0x1006: 'PtypMultipleCurrency',
            0x1007: 'PtypMultipleFloatingTime',
            0x1014: 'PtypMultipleInteger64',
            0x101E: 'PtypMultipleString8',
            0x101F: 'PtypMultipleString',
            0x1040: 'PtypMultipleTime',
            0x1048: 'PtypMultipleGuid',
            0x1102: 'PtypMultipleBinary',
        }

# https://github.com/JasonSchlauch/mfcmapi/blob/master/GenTagArray.h
        dPropertyIDs = {
            0x0001: 'PidTagAcknowledgementMode',
            0x0001: 'PidTagTemplateData',
            0x0002: 'PidTagAlternateRecipientAllowed',
            0x0003: 'PidTagAuthorizingUsers',
            0x0004: 'PidTagAutoForwardComment',
            0x0004: 'PidTagScriptData',
            0x0005: 'PidTagAutoForwarded',
            0x0006: 'PidTagContentConfidentialityAlgorithmId',
            0x0007: 'PidTagContentCorrelator',
            0x0008: 'PidTagContentIdentifier',
            0x0009: 'PidTagContentLength',
            0x000a: 'PidTagContentReturnRequested',
            0x000b: 'PidTagConversationKey',
            0x000c: 'PidTagConversionEits',
            0x000d: 'PidTagConversionWithLossProhibited',
            0x000e: 'PidTagConvertedEits',
            0x000f: 'PidTagDeferredDeliveryTime',
            0x0010: 'PidTagDeliverTime',
            0x0011: 'PidTagDiscardReason',
            0x0012: 'PidTagDisclosureOfRecipients',
            0x0013: 'PidTagDistributionListExpansionHistory',
            0x0014: 'PidTagDistributionListExpansionProhibited',
            0x0015: 'PidTagExpiryTime',
            0x0016: 'PidTagImplicitConversionProhibited',
            0x0017: 'PidTagImportance',
            0x0018: 'PidTagIpmId',
            0x0019: 'PidTagLatestDeliveryTime',
            0x001a: 'PidTagMessageClass',
            0x001b: 'PidTagMessageDeliveryId',
            0x001e: 'PidTagMessageSecurityLabel',
            0x001f: 'PidTagObsoletedMessageIds',
            0x0020: 'PidTagOriginallyIntendedRecipientName',
            0x0021: 'PidTagOriginalEits',
            0x0022: 'PidTagOriginatorCertificate',
            0x0023: 'PidTagOriginatorDeliveryReportRequested',
            0x0024: 'PidTagOriginatorReturnAddress',
            0x0025: 'PidTagParentKey',
            0x0026: 'PidTagPriority',
            0x0027: 'PidTagOriginCheck',
            0x0028: 'PidTagProofOfSubmissionRequested',
            0x0029: 'PidTagReadReceiptRequested',
            0x002a: 'PidTagReceiptTime',
            0x002b: 'PidTagRecipientReassignmentProhibited',
            0x002c: 'PidTagRedirectionHistory',
            0x002d: 'PidTagRelatedMessageIds',
            0x002e: 'PidTagOriginalSensitivity',
            0x002f: 'PidTagLanguages',
            0x0030: 'PidTagReplyTime',
            0x0031: 'PidTagReportTag',
            0x0032: 'PidTagReportTime',
            0x0033: 'PidTagReturnedMessageid',
            0x0034: 'PidTagSecurity',
            0x0035: 'PidTagIncompleteCopy',
            0x0036: 'PidTagSensitivity',
            0x0037: 'PidTagSubject',
            0x0038: 'PidTagSubjectMessageId',
            0x0039: 'PidTagClientSubmitTime',
            0x003a: 'PidTagReportName',
            0x003b: 'PidTagSentRepresentingSearchKey',
            0x003c: 'PidTagX400ContentType',
            0x003d: 'PidTagSubjectPrefix',
            0x003e: 'PidTagNonReceiptReason',
            0x003f: 'PidTagReceivedByEntryId',
            0x0040: 'PidTagReceivedByName',
            0x0041: 'PidTagSentRepresentingEntryId',
            0x0042: 'PidTagSentRepresentingName',
            0x0043: 'PidTagReceivedRepresentingEntryId',
            0x0044: 'PidTagReceivedRepresentingName',
            0x0045: 'PidTagReportEntryId',
            0x0046: 'PidTagReadReceiptEntryId',
            0x0047: 'PidTagMessageSubmissionId',
            0x0048: 'PidTagProviderSubmitTime',
            0x0049: 'PidTagOriginalSubject',
            0x004a: 'PidTagDiscVal',
            0x004b: 'PidTagOriginalMessageClass',
            0x004c: 'PidTagOriginalAuthorEntryId',
            0x004d: 'PidTagOriginalAuthorName',
            0x004e: 'PidTagOriginalSubmitTime',
            0x004f: 'PidTagReplyRecipientEntries',
            0x0050: 'PidTagReplyRecipientNames',
            0x0051: 'PidTagReceivedBySearchKey',
            0x0052: 'PidTagReceivedRepresentingSearchKey',
            0x0053: 'PidTagReadReceiptSearchKey',
            0x0054: 'PidTagReportSearchKey',
            0x0055: 'PidTagOriginalDeliveryTime',
            0x0056: 'PidTagOriginalAuthorSearchKey',
            0x0057: 'PidTagMessageToMe',
            0x0058: 'PidTagMessageCcMe',
            0x0059: 'PidTagMessageRecipientMe',
            0x005a: 'PidTagOriginalSenderName',
            0x005b: 'PidTagOriginalSenderEntryId',
            0x005c: 'PidTagOriginalSenderSearchKey',
            0x005d: 'PidTagOriginalSentRepresentingName',
            0x005e: 'PidTagOriginalSentRepresentingEntryId',
            0x005f: 'PidTagOriginalSentRepresentingSearchKey',
            0x0060: 'PidTagStartDate',
            0x0061: 'PidTagEndDate',
            0x0062: 'PidTagOwnerAppointmentId',
            0x0063: 'PidTagResponseRequested',
            0x0064: 'PidTagSentRepresentingAddressType',
            0x0065: 'PidTagSentRepresentingEmailAddress',
            0x0066: 'PidTagOriginalSenderAddressType',
            0x0067: 'PidTagOriginalSenderEmailAddress',
            0x0068: 'PidTagOriginalSentRepresentingAddressType',
            0x0069: 'PidTagOriginalSentRepresentingEmailAddress',
            0x0070: 'PidTagConversationTopic',
            0x0071: 'PidTagConversationIndex',
            0x0072: 'PidTagOriginalDisplayBcc',
            0x0073: 'PidTagOriginalDisplayCc',
            0x0074: 'PidTagOriginalDisplayTo',
            0x0075: 'PidTagReceivedByAddressType',
            0x0076: 'PidTagReceivedByEmailAddress',
            0x0077: 'PidTagReceivedRepresentingAddressType',
            0x0078: 'PidTagReceivedRepresentingEmailAddress',
            0x0079: 'PidTagOriginalAuthorAddressType',
            0x007a: 'PidTagOriginalAuthorEmailAddress',
            0x007b: 'PidTagOriginallyIntendedRecipAddrtype',
            0x007c: 'PidTagOriginallyIntendedRecipEmailAddress',
            0x007d: 'PidTagTransportMessageHeaders',
            0x007e: 'PidTagDelegation',
            0x007f: 'PidTagTnefCorrelationKey',
            0x0080: 'PidTagReportDisposition',
            0x0081: 'PidTagReportDispositionMode',
            0x0082: 'PidTagReportOriginalSender',
            0x0083: 'PidTagReportDispositionToNames',
            0x0084: 'PidTagReportDispositionToEmailAddresses',
            0x0085: 'PidTagReportDispositionOptions',
            0x0418: 'PidTagSpamTrustedSenders',
            0x0419: 'PidTagSpamTrustedRecipients',
            0x041a: 'PidTagSpamJunkSenders',
            0x041b: 'PidTagSpamThreshold',
            0x0807: 'PidTagAddressBookRoomCapacity',
            0x0809: 'PidTagAddressBookRoomDescription',
            0x0c00: 'PidTagContentIntegrityCheck',
            0x0c01: 'PidTagExplicitConversion',
            0x0c02: 'PidTagIpmReturnRequested',
            0x0c03: 'PidTagMessageToken',
            0x0c04: 'PidTagNonDeliveryReportReasonCode',
            0x0c05: 'PidTagNonDeliveryReportDiagCode',
            0x0c06: 'PidTagNonReceiptNotificationRequested',
            0x0c07: 'PidTagDeliveryPoint',
            0x0c08: 'PidTagOriginatorNonDeliveryReportRequested',
            0x0c09: 'PidTagOriginatorRequestedAlternateRecipient',
            0x0c0a: 'PidTagPhysicalDeliveryBureauFaxDelivery',
            0x0c0b: 'PidTagPhysicalDeliveryMode',
            0x0c0c: 'PidTagPhysicalDeliveryReportRequest',
            0x0c0d: 'PidTagPhysicalForwardingAddress',
            0x0c0e: 'PidTagPhysicalForwardingAddressRequested',
            0x0c0f: 'PidTagPhysicalForwardingProhibited',
            0x0c10: 'PidTagPhysicalRenditionAttributes',
            0x0c11: 'PidTagProofOfDelivery',
            0x0c12: 'PidTagProofOfDeliveryRequested',
            0x0c13: 'PidTagRecipientCertificate',
            0x0c14: 'PidTagRecipientNumberForAdvice',
            0x0c15: 'PidTagRecipientType',
            0x0c16: 'PidTagRegisteredMailType',
            0x0c17: 'PidTagReplyRequested',
            0x0c18: 'PidTagRequestedDeliveryMethod',
            0x0c19: 'PidTagSenderEntryId',
            0x0c1a: 'PidTagSenderName',
            0x0c1b: 'PidTagSupplementaryInfo',
            0x0c1c: 'PidTagTypeOfX400User',
            0x0c1d: 'PidTagSenderSearchKey',
            0x0c1e: 'PidTagSenderAddressType',
            0x0c1f: 'PidTagSenderEmailAddress',
            0x0e00: 'PidTagCurrentVersion',
            0x0e01: 'PidTagDeleteAfterSubmit',
            0x0e02: 'PidTagDisplayBcc',
            0x0e03: 'PidTagDisplayCc',
            0x0e04: 'PidTagDisplayTo',
            0x0e05: 'PidTagParentDisplay',
            0x0e06: 'PidTagMessageDeliveryTime',
            0x0e07: 'PidTagMessageFlags',
            0x0e08: 'PidTagMessageSize',
            0x0e08: 'PidTagMessageSizeExtended',
            0x0e09: 'PidTagParentEntryId',
            0x0e0a: 'PidTagSentMailEntryId',
            0x0e0c: 'PidTagCorrelate',
            0x0e0d: 'PidTagCorrelateMtsid',
            0x0e0e: 'PidTagDiscreteValues',
            0x0e0f: 'PidTagResponsibility',
            0x0e10: 'PidTagSpoolerStatus',
            0x0e11: 'PidTagTransportStatus',
            0x0e12: 'PidTagMessageRecipients',
            0x0e13: 'PidTagMessageAttachments',
            0x0e14: 'PidTagSubmitFlags',
            0x0e15: 'PidTagRecipientStatus',
            0x0e16: 'PidTagTransportKey',
            0x0e17: 'PidTagMessageStatus',
            0x0e18: 'PidTagMessageDownloadTime',
            0x0e19: 'PidTagCreationVersion',
            0x0e1a: 'PidTagModifyVersion',
            0x0e1b: 'PidTagHasAttachments',
            0x0e1c: 'PidTagBodyCrc',
            0x0e1d: 'PidTagNormalizedSubject',
            0x0e1f: 'PidTagRtfInSync',
            0x0e20: 'PidTagAttachSize',
            0x0e21: 'PidTagAttachNumber',
            0x0e22: 'PidTagPreprocess',
            0x0e23: 'PidTagInternetArticleNumber',
            0x0e25: 'PidTagOriginatingMtaCertificate',
            0x0e26: 'PidTagProofOfSubmission',
            0x0e28: 'PidTagPrimarySendAccount',
            0x0e29: 'PidTagNextSendAcct',
            0x0e2a: 'PidTagExchangeRemoteHeader',
            0x0e2b: 'PidTagToDoItemFlags',
            0x0e2c: 'PidTagSwappedToDoStore',
            0x0e2d: 'PidTagSwappedToDoData',
            0x0e30: 'PidTagReplItemid',
            0x0e33: 'PidTagReplChangenum',
            0x0e34: 'PidTagReplVersionHistory',
            0x0e38: 'PidTagReplFlags',
            0x0e3c: 'PidTagReplCopiedfromVersionhistory',
            0x0e3d: 'PidTagReplCopiedfromItemid',
            0x0e69: 'PidTagRead',
            0x0e6a: 'PidTagSecurityDescriptorAsXml',
            0x0e79: 'PidTagTrustSender',
            0x0e84: 'PidTagExchangeNTSecurityDescriptor',
            0x0e99: 'PidTagExtendedRuleMessageActions',
            0x0e9a: 'PidTagExtendedRuleMessageCondition',
            0x0e9b: 'PidTagExtendedRuleSizeLimit',
            0x0e9c: 'PidTagTnefUnprocessedProps',
            0x0ea0: 'PidTagAssociatedSharingProvider',
            0x0ea3: 'PidTagProviderItemId',
            0x0ea4: 'PidTagProviderParentItemId',
            0x0ff4: 'PidTagAccess',
            0x0ff5: 'PidTagRowType',
            0x0ff6: 'PidTagInstanceKey',
            0x0ff7: 'PidTagAccessLevel',
            0x0ff8: 'PidTagMappingSignature',
            0x0ff9: 'PidTagRecordKey',
            0x0ffa: 'PidTagStoreRecordKey',
            0x0ffb: 'PidTagStoreEntryId',
            0x0ffc: 'PidTagMiniIcon',
            0x0ffd: 'PidTagIcon',
            0x0ffe: 'PidTagObjectType',
            0x0fff: 'PidTagEntryId',
            0x0fff: 'PidTagMemberEntryId',
            0x1000: 'PidTagBody',
            0x1001: 'PidTagReportText',
            0x1002: 'PidTagOriginatorAndDistributionListExpansionHistory',
            0x1003: 'PidTagReportingDistributionListName',
            0x1004: 'PidTagReportingMessageTransferAgentCertificate',
            0x1006: 'PidTagRtfSyncBodyCrc',
            0x1007: 'PidTagRtfSyncBodyCount',
            0x1008: 'PidTagRtfSyncBodyTag',
            0x1009: 'PidTagRtfCompressed',
            0x1010: 'PidTagRtfSyncPrefixCount',
            0x1011: 'PidTagRtfSyncTrailingCount',
            0x1012: 'PidTagOriginallyIntendedRecipEntryId',
            0x1013: 'PidTagBodyHtml',
            0x1013: 'PidTagHtml',
            0x1014: 'PidTagBodyContentLocation',
            0x1015: 'PidTagBodyContentId',
            0x1016: 'PidTagNativeBody',
            0x1030: 'PidTagInternetApproved',
            0x1031: 'PidTagInternetControl',
            0x1032: 'PidTagInternetDistribution',
            0x1033: 'PidTagInternetFollowupTo',
            0x1034: 'PidTagInternetLines',
            0x1035: 'PidTagInternetMessageId',
            0x1037: 'PidTagInternetOrganization',
            0x1038: 'PidTagInternetNntpPath',
            0x1039: 'PidTagInternetReferences',
            0x1042: 'PidTagInReplyToId',
            0x1043: 'PidTagListHelp',
            0x1044: 'PidTagListSubscribe',
            0x1045: 'PidTagListUnsubscribe',
            0x1046: 'PidTagInternetReturnPath',
            0x1046: 'PidTagOriginalMessageId',
            0x1080: 'PidTagIconIndex',
            0x1081: 'PidTagLastVerbExecuted',
            0x1082: 'PidTagLastVerbExecutionTime',
            0x1090: 'PidTagFlagStatus',
            0x1091: 'PidTagFlagCompleteTime',
            0x1095: 'PidTagFollowupIcon',
            0x1096: 'PidTagBlockStatus',
            0x1097: 'PidTagItemTemporaryflags',
            0x1098: 'PidTagConflictItems',
            0x10c3: 'PidTagICalendarStartTime',
            0x10c4: 'PidTagICalendarEndTime',
            0x10c5: 'PidTagCdoRecurrenceid',
            0x10ca: 'PidTagICalendarReminderNextTime',
            0x10f0: 'PidTagImapCachedMsgsize',
            0x10f3: 'PidTagUrlComponentName',
            0x10f3: 'PidTagUrlCompName',
            0x10f4: 'PidTagAttributeHidden',
            0x10f6: 'PidTagAttributeReadOnly',
            0x3000: 'PidTagRowid',
            0x3001: 'PidTagDisplayName',
            0x3002: 'PidTagAddressType',
            0x3003: 'PidTagEmailAddress',
            0x3004: 'PidTagComment',
            0x3005: 'PidTagDepth',
            0x3006: 'PidTagProviderDisplay',
            0x3007: 'PidTagCreationTime',
            0x3008: 'PidTagLastModificationTime',
            0x3009: 'PidTagResourceFlags',
            0x300a: 'PidTagProviderDllName',
            0x300b: 'PidTagSearchKey',
            0x300c: 'PidTagProviderUid',
            0x300d: 'PidTagProviderOrdinal',
            0x3010: 'PidTagTargetEntryId',
            0x3013: 'PidTagConversationId',
            0x3016: 'PidTagConversationIndexTracking',
            0x3018: 'PidTagArchiveTag',
            0x3019: 'PidTagPolicyTag',
            0x301a: 'PidTagRetentionPeriod',
            0x301b: 'PidTagStartDateEtc',
            0x301c: 'PidTagRetentionDate',
            0x301d: 'PidTagRetentionFlags',
            0x301e: 'PidTagArchivePeriod',
            0x301f: 'PidTagArchiveDate',
            0x3301: 'PidTagFormVersion',
            0x3302: 'PidTagFormClassId',
            0x3303: 'PidTagFormContactName',
            0x3304: 'PidTagFormCategory',
            0x3305: 'PidTagFormCategorySub',
            0x3306: 'PidTagFormHostMap',
            0x3307: 'PidTagFormHidden',
            0x3308: 'PidTagFormDesignerName',
            0x3309: 'PidTagFormDesignerGuid',
            0x330a: 'PidTagFormMessageBehavior',
            0x3400: 'PidTagDefaultStore',
            0x340d: 'PidTagStoreSupportMask',
            0x340e: 'PidTagStoreState',
            0x340f: 'PidTagStoreUnicodeMask',
            0x3410: 'PidTagIpmSubtreeSearchKey',
            0x3411: 'PidTagIpmOutboxSearchKey',
            0x3412: 'PidTagIpmWastebasketSearchKey',
            0x3413: 'PidTagIpmSentMailSearchKey',
            0x3414: 'PidTagStoreProvider',
            0x3415: 'PidTagReceiveFolderSettings',
            0x3417: 'PidTagProviderIcon',
            0x3418: 'PidTagProviderDisplayName',
            0x35df: 'PidTagValidFolderMask',
            0x35e0: 'PidTagIpmSubtreeEntryId',
            0x35e2: 'PidTagIpmOutboxEntryId',
            0x35e3: 'PidTagIpmWastebasketEntryId',
            0x35e4: 'PidTagIpmSentMailEntryId',
            0x35e5: 'PidTagViewsEntryId',
            0x35e6: 'PidTagCommonViewsEntryId',
            0x35e7: 'PidTagFinderEntryId',
            0x3600: 'PidTagContainerFlags',
            0x3601: 'PidTagFolderType',
            0x3602: 'PidTagContentCount',
            0x3603: 'PidTagContentUnreadCount',
            0x3604: 'PidTagCreateTemplates',
            0x3605: 'PidTagDetailsTable',
            0x3607: 'PidTagSearch',
            0x3609: 'PidTagSelectable',
            0x360a: 'PidTagSubfolders',
            0x360b: 'PidTagStatus',
            0x360c: 'PidTagAnr',
            0x360d: 'PidTagContentSortOrder',
            0x360e: 'PidTagContainerHierarchy',
            0x360f: 'PidTagContainerContents',
            0x3610: 'PidTagFolderAssociatedContents',
            0x3611: 'PidTagDefCreateDl',
            0x3612: 'PidTagDefCreateMailuser',
            0x3613: 'PidTagContainerClass',
            0x3614: 'PidTagContainerModifyVersion',
            0x3615: 'PidTagAbProviderId',
            0x3616: 'PidTagDefaultViewEntryId',
            0x3617: 'PidTagAssociatedContentCount',
            0x36d0: 'PidTagIpmAppointmentEntryId',
            0x36d1: 'PidTagIpmContactEntryId',
            0x36d2: 'PidTagIpmJournalEntryId',
            0x36d3: 'PidTagIpmNoteEntryId',
            0x36d4: 'PidTagIpmTaskEntryId',
            0x36d5: 'PidTagRemindersOnlineEntryId',
            0x36d7: 'PidTagIpmDraftsEntryId',
            0x36d8: 'PidTagAdditionalRenEntryIds',
            0x36d9: 'PidTagAdditionalRenEntryIdsEx',
            0x36da: 'PidTagExtendedFolderFlags',
            0x36df: 'PidTagFolderWebviewinfo',
            0x36e2: 'PidTagOrdinalMost',
            0x36e3: 'PidTagUserFields',
            0x36e4: 'PidTagFreeBusyEntryIds',
            0x36e5: 'PidTagDefaultPostMessageClass',
            0x3700: 'PidTagAttachmentX400Parameters',
            0x3701: 'PidTagAttachDataObject',
            0x3701: 'PidTagAttachDataBinary',
            0x3702: 'PidTagAttachEncoding',
            0x3703: 'PidTagAttachExtension',
            0x3704: 'PidTagAttachFilename',
            0x3705: 'PidTagAttachMethod',
            0x3707: 'PidTagAttachLongFilename',
            0x3708: 'PidTagAttachPathname',
            0x3709: 'PidTagAttachRendering',
            0x370a: 'PidTagAttachTag',
            0x370b: 'PidTagRenderingPosition',
            0x370c: 'PidTagAttachTransportName',
            0x370d: 'PidTagAttachLongPathname',
            0x370e: 'PidTagAttachMimeTag',
            0x370f: 'PidTagAttachAdditionalInformation',
            0x3710: 'PidTagAttachMimeSequence',
            0x3711: 'PidTagAttachContentBase',
            0x3712: 'PidTagAttachContentId',
            0x3713: 'PidTagAttachContentLocation',
            0x3714: 'PidTagAttachFlags',
            0x3719: 'PidTagAttachPayloadProviderGuidString',
            0x371a: 'PidTagAttachPayloadClass',
            0x371b: 'PidTagTextAttachmentCharset',
            0x3900: 'PidTagDisplayType',
            0x3902: 'PidTagTemplateid',
            0x3904: 'PidTagPrimaryCapability',
            0x3905: 'PidTagDisplayTypeEx',
            0x39fe: 'PidTagSmtpAddress',
            0x39ff: 'PidTagAddressBookDisplayNamePrintable',
            0x3a00: 'PidTagAccount',
            0x3a01: 'PidTagAlternateRecipient',
            0x3a02: 'PidTagCallbackTelephoneNumber',
            0x3a03: 'PidTagConversionProhibited',
            0x3a05: 'PidTagGeneration',
            0x3a06: 'PidTagGivenName',
            0x3a07: 'PidTagGovernmentIdNumber',
            0x3a08: 'PidTagBusinessTelephoneNumber',
            0x3a09: 'PidTagHomeTelephoneNumber',
            0x3a0a: 'PidTagInitials',
            0x3a0b: 'PidTagKeyword',
            0x3a0c: 'PidTagLanguage',
            0x3a0d: 'PidTagLocation',
            0x3a0e: 'PidTagMailPermission',
            0x3a0f: 'PidTagMessageHandlingSystemCommonName',
            0x3a10: 'PidTagOrganizationalIdNumber',
            0x3a11: 'PidTagSurname',
            0x3a12: 'PidTagOriginalEntryId',
            0x3a13: 'PidTagOriginalDisplayName',
            0x3a14: 'PidTagOriginalSearchKey',
            0x3a15: 'PidTagPostalAddress',
            0x3a16: 'PidTagCompanyName',
            0x3a17: 'PidTagTitle',
            0x3a18: 'PidTagDepartmentName',
            0x3a19: 'PidTagOfficeLocation',
            0x3a1a: 'PidTagPrimaryTelephoneNumber',
            0x3a1b: 'PidTagBusiness2TelephoneNumber',
            0x3a1b: 'PidTagBusiness2TelephoneNumbers',
            0x3a1c: 'PidTagMobileTelephoneNumber',
            0x3a1d: 'PidTagRadioTelephoneNumber',
            0x3a1e: 'PidTagCarTelephoneNumber',
            0x3a1f: 'PidTagOtherTelephoneNumber',
            0x3a20: 'PidTagTransmittableDisplayName',
            0x3a21: 'PidTagPagerTelephoneNumber',
            0x3a22: 'PidTagUserCertificate',
            0x3a23: 'PidTagPrimaryFaxNumber',
            0x3a24: 'PidTagBusinessFaxNumber',
            0x3a25: 'PidTagHomeFaxNumber',
            0x3a26: 'PidTagCountry',
            0x3a27: 'PidTagLocality',
            0x3a28: 'PidTagStateOrProvince',
            0x3a29: 'PidTagStreetAddress',
            0x3a2a: 'PidTagPostalCode',
            0x3a2b: 'PidTagPostOfficeBox',
            0x3a2c: 'PidTagTelexNumber',
            0x3a2d: 'PidTagIsdnNumber',
            0x3a2e: 'PidTagAssistantTelephoneNumber',
            0x3a2f: 'PidTagHome2TelephoneNumber',
            0x3a2f: 'PidTagHome2TelephoneNumbers',
            0x3a30: 'PidTagAssistant',
            0x3a40: 'PidTagSendRichInfo',
            0x3a41: 'PidTagWeddingAnniversary',
            0x3a42: 'PidTagBirthday',
            0x3a43: 'PidTagHobbies',
            0x3a44: 'PidTagMiddleName',
            0x3a45: 'PidTagDisplayNamePrefix',
            0x3a46: 'PidTagProfession',
            0x3a47: 'PidTagPreferredByName',
            0x3a47: 'PidTagReferredByName',
            0x3a48: 'PidTagSpouseName',
            0x3a49: 'PidTagComputerNetworkName',
            0x3a4a: 'PidTagCustomerId',
            0x3a4b: 'PidTagTelecommunicationsDeviceForDeafTelephoneNumber',
            0x3a4c: 'PidTagFtpSite',
            0x3a4d: 'PidTagGender',
            0x3a4e: 'PidTagManagerName',
            0x3a4f: 'PidTagNickname',
            0x3a50: 'PidTagPersonalHomePage',
            0x3a51: 'PidTagBusinessHomePage',
            0x3a52: 'PidTagContactVersion',
            0x3a54: 'PidTagContactAddressTypes',
            0x3a57: 'PidTagCompanyMainTelephoneNumber',
            0x3a58: 'PidTagChildrensNames',
            0x3a59: 'PidTagHomeAddressCity',
            0x3a5a: 'PidTagHomeAddressCountry',
            0x3a5b: 'PidTagHomeAddressPostalCode',
            0x3a5c: 'PidTagHomeAddressStateOrProvince',
            0x3a5d: 'PidTagHomeAddressStreet',
            0x3a5e: 'PidTagHomeAddressPostOfficeBox',
            0x3a5f: 'PidTagOtherAddressCity',
            0x3a60: 'PidTagOtherAddressCountry',
            0x3a61: 'PidTagOtherAddressPostalCode',
            0x3a62: 'PidTagOtherAddressStateOrProvince',
            0x3a63: 'PidTagOtherAddressStreet',
            0x3a64: 'PidTagOtherAddressPostOfficeBox',
            0x3a70: 'PidTagUserX509Certificate',
            0x3a71: 'PidTagSendInternetEncoding',
            0x3d00: 'PidTagStoreProviders',
            0x3d01: 'PidTagAbProviders',
            0x3d02: 'PidTagTransportProviders',
            0x3d04: 'PidTagDefaultProfile',
            0x3d05: 'PidTagAbSearchPath',
            0x3d06: 'PidTagAbDefaultDir',
            0x3d07: 'PidTagAbDefaultPab',
            0x3d08: 'PidTagFilteringHooks',
            0x3d09: 'PidTagServiceName',
            0x3d0a: 'PidTagServiceDllName',
            0x3d0b: 'PidTagServiceEntryName',
            0x3d0c: 'PidTagServiceUid',
            0x3d0d: 'PidTagServiceExtraUids',
            0x3d0e: 'PidTagServices',
            0x3d0f: 'PidTagServiceSupportFiles',
            0x3d10: 'PidTagServiceDeleteFiles',
            0x3d11: 'PidTagAbSearchPathUpdate',
            0x3d12: 'PidTagProfileName',
            0x3d13: 'PidTagServiceInstallId',
            0x3d15: 'PidTagExchangeProfileSectionId',
            0x3d1b: 'PidTagAbSearchPathCustomization',
            0x3d1c: 'PidTagAbChooseDirectoryAutomatically',
            0x3e00: 'PidTagIdentityDisplay',
            0x3e01: 'PidTagIdentityEntryId',
            0x3e02: 'PidTagResourceMethods',
            0x3e03: 'PidTagResourceType',
            0x3e04: 'PidTagStatusCode',
            0x3e05: 'PidTagIdentitySearchKey',
            0x3e06: 'PidTagOwnStoreEntryId',
            0x3e07: 'PidTagResourcePath',
            0x3e08: 'PidTagStatusString',
            0x3e09: 'PidTagX400DeferredDeliveryCancel',
            0x3e0a: 'PidTagHeaderFolderEntryId',
            0x3e0b: 'PidTagRemoteProgress',
            0x3e0c: 'PidTagRemoteProgressText',
            0x3e0d: 'PidTagRemoteValidateOk',
            0x3f00: 'PidTagControlFlags',
            0x3f01: 'PidTagControlStructure',
            0x3f02: 'PidTagControlType',
            0x3f03: 'PidTagDeltaX',
            0x3f04: 'PidTagDeltaY',
            0x3f05: 'PidTagXCoordinate',
            0x3f06: 'PidTagYCoordinate',
            0x3f07: 'PidTagControlId',
            0x3f08: 'PidTagInitialDetailsPane',
            0x3f20: 'PidTagTemporaryDefaultDocument',
            0x3fde: 'PidTagInternetCodepage',
            0x3fdf: 'PidTagAutoResponseSuppress',
            0x3fe0: 'PidTagAccessControlListTable',
            0x3fe1: 'PidTagRulesTable',
            0x3fe3: 'PidTagDelegatedByRule',
            0x3fe7: 'PidTagResolveMethod',
            0x3fea: 'PidTagHasDeferredActionMessages',
            0x3feb: 'PidTagDeferredSendNumber',
            0x3fec: 'PidTagDeferredSendUnits',
            0x3fed: 'PidTagExpiryNumber',
            0x3fee: 'PidTagExpiryUnits',
            0x3fef: 'PidTagDeferredSendTime',
            0x3ff0: 'PidTagConflictEntryId',
            0x3ff1: 'PidTagMessageLocaleId',
            0x3ff8: 'PidTagCreatorName',
            0x3ff9: 'PidTagCreatorEntryId',
            0x3ffa: 'PidTagLastModifierName',
            0x3ffb: 'PidTagLastModifierEntryId',
            0x3ffd: 'PidTagMessageCodepage',
            0x401a: 'PidTagSentRepresentingFlags',
            0x4029: 'PidTagReadReceiptAddressType',
            0x402a: 'PidTagReadReceiptEmailAddress',
            0x402b: 'PidTagReadReceiptName',
            0x403e: 'PidTagOrgEmailAddress',
            0x4076: 'PidTagContentFilterSpamConfidenceLevel',
            0x4079: 'PidTagSenderIdStatus',
            0x4083: 'PidTagPurportedSenderDomain',
            0x5902: 'PidTagInternetMailOverrideFormat',
            0x5909: 'PidTagMessageEditorFormat',
            0x5d01: 'PidTagSenderSmtpAddress',
            0x5d02: 'PidTagSentRepresentingSmtpAddress',
            0x5fde: 'PidTagRecipientResourceState',
            0x5fdf: 'PidTagRecipientOrder',
            0x5fe1: 'PidTagRecipientProposed',
            0x5fe3: 'PidTagRecipientProposedStartTime',
            0x5fe4: 'PidTagRecipientProposedEndTime',
            0x5ff6: 'PidTagRecipientDisplayName',
            0x5ff7: 'PidTagRecipientEntryId',
            0x5ffb: 'PidTagRecipientTrackStatusTime',
            0x5ffd: 'PidTagRecipientFlags',
            0x5fff: 'PidTagRecipientTrackStatus',
            0x6100: 'PidTagJunkIncludeContacts',
            0x6101: 'PidTagJunkThreshold',
            0x6102: 'PidTagJunkPermanentlyDelete',
            0x6103: 'PidTagJunkAddRecipientsToSafeSendersList',
            0x6107: 'PidTagJunkPhishingEnableLinks',
            0x64f0: 'PidTagMimeSkeleton',
            0x65c2: 'PidTagReplyTemplateId',
            0x65e0: 'PidTagSourceKey',
            0x65e1: 'PidTagParentSourceKey',
            0x65e2: 'PidTagChangeKey',
            0x65e3: 'PidTagPredecessorChangeList',
            0x65e9: 'PidTagRuleMessageState',
            0x65ea: 'PidTagRuleMessageUserFlags',
            0x65eb: 'PidTagRuleMessageProvider',
            0x65eb: 'PidTagRuleMsgProvider',
            0x65ec: 'PidTagRuleMsgName',
            0x65ec: 'PidTagRuleMessageName',
            0x65ed: 'PidTagRuleMessageLevel',
            0x65ee: 'PidTagRuleMessageProviderData',
            0x65f3: 'PidTagRuleMessageSequence',
            0x6601: 'PidTagContactAddressBookUid',
            0x6602: 'PidTagContactAddressBookSortFlag',
            0x660a: 'PidTagProfileType',
            0x6610: 'PidTagContactAddressBookFolderEntryId',
            0x6611: 'PidTagContactAddressBookStoreSupportMask',
            0x6612: 'PidTagContactAddressBookStoreName',
            0x6613: 'PidTagContactAddressBookFolderName',
            0x6614: 'PidTagContactAddressBookMultipleAddressFlag',
            0x6619: 'PidTagUserEntryId',
            0x661b: 'PidTagMailboxOwnerEntryId',
            0x661c: 'PidTagMailboxOwnerName',
            0x661d: 'PidTagPstBestBodyProptag',
            0x661d: 'PidTagOutOfOfficeState',
            0x6620: 'PidTagNonIpmSubtreeEntryId',
            0x6620: 'PidTagContactAddressBookFolderEntryIds',
            0x6621: 'PidTagContactAddressBookStoreSupportMasks',
            0x6622: 'PidTagSchedulePlusFreeBusyEntryId',
            0x6622: 'PidTagContactAddressBookStoreNames',
            0x6623: 'PidTagContactAddressBookFolderNames',
            0x6624: 'PidTagContactAddressBookDisplayNames',
            0x6625: 'PidTagContactAddressBookMultipleAddressFlags',
            0x6626: 'PidTagContactAddressBookStoreEntryIds',
            0x6633: 'PidTagPstLrNoRestrictions',
            0x6635: 'PidTagProfileOabCountAttemptedFulldn',
            0x6635: 'PidTagPstHiddenCount',
            0x6636: 'PidTagProfileOabCountAttemptedIncrdn',
            0x6636: 'PidTagPstHiddenUnread',
            0x6639: 'PidTagRights',
            0x663a: 'PidTagHasRules',
            0x663b: 'PidTagAddressBookEntryId',
            0x663e: 'PidTagHierarchyChangeNumber',
            0x6645: 'PidTagClientActions',
            0x6646: 'PidTagDamOriginalEntryId',
            0x6647: 'PidTagDamBackPatched',
            0x6648: 'PidTagRuleError',
            0x6649: 'PidTagRuleActionType',
            0x664a: 'PidTagHasNamedProperties',
            0x6650: 'PidTagRuleActionNumber',
            0x6651: 'PidTagRuleFolderEntryId',
            0x6662: 'PidTagRecipientNumber',
            0x666a: 'PidTagProhibitReceiveQuota',
            0x666c: 'PidTagInConflict',
            0x666d: 'PidTagMaximumSubmitMessageSize',
            0x666e: 'PidTagProhibitSendQuota',
            0x6670: 'PidTagLongTermEntryIdFromTable',
            0x6671: 'PidTagMemberId',
            0x6671: 'PidTagShortTermEntryIdFromObject',
            0x6672: 'PidTagMemberName',
            0x6672: 'PidTagShortTermParentEntryIdFromObject',
            0x6673: 'PidTagMemberRights',
            0x6674: 'PidTagRuleId',
            0x6675: 'PidTagRuleIds',
            0x6676: 'PidTagRuleSequence',
            0x6677: 'PidTagRuleState',
            0x6678: 'PidTagRuleUserFlags',
            0x6679: 'PidTagRuleCondition',
            0x6680: 'PidTagRuleActions',
            0x6681: 'PidTagRuleProvider',
            0x6682: 'PidTagRuleName',
            0x6683: 'PidTagRuleLevel',
            0x6684: 'PidTagRuleProviderData',
            0x668f: 'PidTagDeletedOn',
            0x66a1: 'PidTagLocaleId',
            0x66b3: 'PidTagNormalMessageSize',
            0x66c3: 'PidTagCodePageId',
            0x66fa: 'PidTagLatestPstEnsure',
            0x6700: 'PidTagWizardNoPstPage',
            0x6700: 'PidTagPstPath',
            0x6701: 'PidTagPstRememberPassword',
            0x6701: 'PidTagWizardNoPabPage',
            0x6703: 'PidTagPstPasswordSzOld',
            0x6704: 'PidTagAddressBookManageDistributionList',
            0x6704: 'PidTagPstPasswordSzNew',
            0x6705: 'PidTagSortLocaleId',
            0x6705: 'PidTagPstIpmsubTreeDescendant',
            0x6707: 'PidTagUrlName',
            0x6708: 'PidTagSubfolder',
            0x6709: 'PidTagLocalCommitTime',
            0x670e: 'PidTagFlatUrlName',
            0x671c: 'PidTagPublicFolderAdministrativeDescription',
            0x671d: 'PidTagPublicFolderProxy',
            0x6740: 'PidTagSentMailSvrEID',
            0x6741: 'PidTagDeferredActionMessageOriginalEntryId',
            0x6748: 'PidTagFolderId',
            0x6749: 'PidTagParentFolderId',
            0x674a: 'PidTagMid',
            0x674d: 'PidTagInstID',
            0x674e: 'PidTagInstanceNum',
            0x674f: 'PidTagAddressBookMessageId',
            0x6770: 'PidTagPstConfigurationFlags',
            0x6771: 'PidTagPstPathHint',
            0x6772: 'PidTagPstSubTreeContainer',
            0x67a4: 'PidTagChangeNumber',
            0x67aa: 'PidTagAssociated',
            0x67f1: 'PidTagLtpParentNid',
            0x67f2: 'PidTagLtpRowId',
            0x67f3: 'PidTagLtpRowVer',
            0x67ff: 'PidTagPstPassword',
            0x6800: 'PidTagOfflineAddressBookName',
            0x6801: 'PidTagOfflineAddressBookSequence',
            0x6801: 'PidTagVoiceMessageDuration',
            0x6802: 'PidTagOfflineAddressBookContainerGuid',
            0x6802: 'PidTagSenderTelephoneNumber',
            0x6802: 'PidTagRwRulesStream',
            0x6803: 'PidTagOfflineAddressBookMessageClass',
            0x6803: 'PidTagSendOutlookRecallReport',
            0x6803: 'PidTagVoiceMessageSenderName',
            0x6804: 'PidTagFaxNumberOfPages',
            0x6804: 'PidTagOfflineAddressBookDistinguishedName',
            0x6805: 'PidTagVoiceMessageAttachmentOrder',
            0x6805: 'PidTagOfflineAddressBookTruncatedProperties',
            0x6806: 'PidTagCallId',
            0x682f: 'PidTagMapiFormComposeCommand',
            0x6834: 'PidTagSearchFolderLastUsed',
            0x683a: 'PidTagSearchFolderExpiration',
            0x6841: 'PidTagScheduleInfoResourceType',
            0x6841: 'PidTagSearchFolderTemplateId',
            0x6842: 'PidTagScheduleInfoDelegatorWantsCopy',
            0x6842: 'PidTagSearchFolderId',
            0x6842: 'PidTagWlinkGroupHeaderID',
            0x6843: 'PidTagScheduleInfoDontMailDelegates',
            0x6844: 'PidTagSearchFolderRecreateInfo',
            0x6844: 'PidTagScheduleInfoDelegateNames',
            0x6845: 'PidTagSearchFolderDefinition',
            0x6845: 'PidTagScheduleInfoDelegateEntryIds',
            0x6846: 'PidTagSearchFolderStorageType',
            0x6846: 'PidTagGatewayNeedsToRefresh',
            0x6847: 'PidTagFreeBusyPublishStart',
            0x6847: 'PidTagSearchFolderTag',
            0x6847: 'PidTagWlinkSaveStamp',
            0x6848: 'PidTagFreeBusyPublishEnd',
            0x6848: 'PidTagSearchFolderEfpFlags',
            0x6849: 'PidTagWlinkType',
            0x6849: 'PidTagFreeBusyMessageEmailAddress',
            0x684a: 'PidTagWlinkFlags',
            0x684a: 'PidTagScheduleInfoDelegateNamesW',
            0x684b: 'PidTagScheduleInfoDelegatorWantsInfo',
            0x684b: 'PidTagWlinkOrdinal',
            0x684c: 'PidTagWlinkEntryId',
            0x684d: 'PidTagWlinkRecordKey',
            0x684e: 'PidTagWlinkStoreEntryId',
            0x684f: 'PidTagWlinkFolderType',
            0x684f: 'PidTagScheduleInfoMonthsMerged',
            0x6850: 'PidTagWlinkGroupClsid',
            0x6850: 'PidTagScheduleInfoFreeBusyMerged',
            0x6851: 'PidTagWlinkGroupName',
            0x6851: 'PidTagScheduleInfoMonthsTentative',
            0x6852: 'PidTagWlinkSection',
            0x6852: 'PidTagScheduleInfoFreeBusyTentative',
            0x6853: 'PidTagWlinkCalendarColor',
            0x6853: 'PidTagScheduleInfoMonthsBusy',
            0x6854: 'PidTagWlinkAddressBookEID',
            0x6854: 'PidTagScheduleInfoFreeBusyBusy',
            0x6855: 'PidTagScheduleInfoMonthsAway',
            0x6856: 'PidTagScheduleInfoFreeBusyAway',
            0x6868: 'PidTagFreeBusyRangeTimestamp',
            0x6869: 'PidTagFreeBusyCountMonths',
            0x686a: 'PidTagScheduleInfoAppointmentTombstone',
            0x686b: 'PidTagDelegateFlags',
            0x686c: 'PidTagScheduleInfoFreeBusy',
            0x686d: 'PidTagScheduleInfoAutoAcceptAppointments',
            0x686e: 'PidTagScheduleInfoDisallowRecurringAppts',
            0x686f: 'PidTagScheduleInfoDisallowOverlappingAppts',
            0x6890: 'PidTagWlinkClientID',
            0x6891: 'PidTagWlinkAddressBookStoreEID',
            0x6892: 'PidTagWlinkROGroupType',
            0x6904: 'PidTagNonDeliveryReportFromEntryId',
            0x6905: 'PidTagNonDeliveryReportFromName',
            0x6906: 'PidTagNonDeliveryReportFromSearchKey',
            0x7001: 'PidTagViewDescriptorBinary',
            0x7002: 'PidTagViewDescriptorStrings',
            0x7003: 'PidTagViewDescriptorFlags',
            0x7004: 'PidTagViewDescriptorLinkTo',
            0x7005: 'PidTagViewDescriptorViewFolder',
            0x7006: 'PidTagViewDescriptorName',
            0x7007: 'PidTagViewDescriptorVersion',
            0x7c06: 'PidTagRoamingDatatypes',
            0x7c07: 'PidTagRoamingDictionary',
            0x7c08: 'PidTagRoamingXmlStream',
            0x7c09: 'PidTagRoamingBinary',
            0x7d01: 'PidTagProcessed',
            0x7ff9: 'PidTagExceptionReplaceTime',
            0x7ffa: 'PidTagAttachmentLinkId',
            0x7ffb: 'PidTagExceptionStartTime',
            0x7ffc: 'PidTagExceptionEndTime',
            0x7ffd: 'PidTagAttachmentFlags',
            0x7ffe: 'PidTagAttachmentHidden',
            0x7fff: 'PidTagAttachmentContactPhoto',
            0x8004: 'PidTagAddressBookFolderPathname',
            0x8005: 'PidTagAddressBookManager',
            0x8005: 'PidTagAddressBookManagerDistinguishedName',
            0x8006: 'PidTagAddressBookHomeMessageDatabase',
            0x8009: 'PidTagAddressBookMember',
            0x800c: 'PidTagAddressBookOwner',
            0x800e: 'PidTagAddressBookReports',
            0x800f: 'PidTagAddressBookProxyAddresses',
            0x8011: 'PidTagAddressBookTargetAddress',
            0x8015: 'PidTagAddressBookPublicDelegates',
            0x8024: 'PidTagAddressBookOwnerBackLink',
            0x802d: 'PidTagAddressBookExtensionAttribute1',
            0x803c: 'PidTagAddressBookObjectDistinguishedName',
            0x806a: 'PidTagAddressBookDeliveryContentLength',
            0x8073: 'PidTagAddressBookDistributionListMemberSubmitAccepted',
            0x8093: 'PidTagEmailAddress1',
            0x8170: 'PidTagAddressBookNetworkAddress',
            0x8c61: 'PidTagAddressBookExtensionAttribute15',
            0x8c6a: 'PidTagAddressBookX509Certificate',
            0x8c6d: 'PidTagAddressBookObjectGuid',
            0x8c8e: 'PidTagAddressBookPhoneticGivenName',
            0x8c8f: 'PidTagAddressBookPhoneticSurname',
            0x8c90: 'PidTagAddressBookPhoneticDepartmentName',
            0x8c91: 'PidTagAddressBookPhoneticCompanyName',
            0x8c92: 'PidTagAddressBookPhoneticDisplayName',
            0x8c93: 'PidTagAddressBookDisplayTypeExtended',
            0x8c94: 'PidTagAddressBookHierarchicalShowInDepartments',
            0x8c96: 'PidTagAddressBookRoomContainers',
            0x8c97: 'PidTagAddressBookHierarchicalDepartmentMembers',
            0x8c98: 'PidTagAddressBookHierarchicalRootDepartment',
            0x8c99: 'PidTagAddressBookHierarchicalParentDepartment',
            0x8c9a: 'PidTagAddressBookHierarchicalChildDepartments',
            0x8c9e: 'PidTagThumbnailPhoto',
            0x8ca0: 'PidTagAddressBookSeniorityIndex',
            0x8ca8: 'PidTagAddressBookOrganizationalUnitRootDistinguishedName',
            0x8cac: 'PidTagAddressBookSenderHintTranslations',
            0x8cb5: 'PidTagAddressBookModerationEnabled',
            0x8cc2: 'PidTagSpokenName',
            0x8cd8: 'PidTagAddressBookAuthorizedSenders',
            0x8cd9: 'PidTagAddressBookUnauthorizedSenders',
            0x8cda: 'PidTagAddressBookDistributionListMemberSubmitRejected',
            0x8cdb: 'PidTagAddressBookDistributionListRejectMessagesFromDLMembers',
            0x8cdd: 'PidTagAddressBookHierarchicalIsHierarchicalGroup',
            0x8ce2: 'PidTagAddressBookDistributionListMemberCount',
            0x8ce3: 'PidTagAddressBookDistributionListExternalMemberCount',
            0xfffb: 'PidTagAddressBookIsMaster',
            0xfffc: 'PidTagAddressBookParentEntryId',
            0xfffd: 'PidTagAddressBookContainerId',
        }

# extracted with scripts from MS site https://learn.microsoft.com/en-us/office/client-developer/outlook/mapi/mapping-canonical-property-names-to-mapi-names
        dPropertyIDs = {
            0x00000001: 'PidLidAttendeeCriticalChange',
            0x00000002: 'PidLidWhere',
            0x00000003: 'PidLidGlobalObjectId',
            0x00000004: 'PidLidIsSilent',
            0x00000005: 'PidLidIsRecurring',
            0x0000000A: 'PidLidIsException',
            0x0000000C: 'PidLidTimeZone',
            0x0000001A: 'PidLidOwnerCriticalChange',
            0x0000001C: 'PidLidCalendarType',
            0x00000023: 'PidLidCleanGlobalObjectId',
            0x00000024: 'PidLidAppointmentMessageClass',
            0x00000026: 'PidLidMeetingType',
            0x00000028: 'PidLidOldLocation',
            0x00000029: 'PidLidOldWhenStartWhole',
            0x0000002A: 'PidLidOldWhenEndWhole',
            0x00002328: 'PidLidCategories',
            0x0001: 'PidTagAcknowledgementMode',
            0x0002: 'PidTagAlternateRecipientAllowed',
            0x00020310: 'PidNameXSharingFlavor',
            0x0003: 'PidTagAuthorizingUsers',
            0x0004: 'PidTagAutoForwardComment',
            0x0005: 'PidTagAutoForwarded',
            0x0006: 'PidTagContentConfidentialityAlgorithmId',
            0x0007: 'PidTagContentCorrelator',
            0x0008: 'PidTagContentIdentifier',
            0x0009: 'PidTagContentLength',
            0x000A: 'PidTagContentReturnRequested',
            0x000B: 'PidTagConversationKey',
            0x000C: 'PidTagConversionEits',
            0x000D: 'PidTagConversionWithLossProhibited',
            0x000E: 'PidTagConvertedEits',
            0x000F: 'PidTagDeferredDeliveryTime',
            0x0010: 'PidTagDeliverTime',
            0x0011: 'PidTagDiscardReason',
            0x0012: 'PidTagDisclosureOfRecipients',
            0x0013: 'PidTagDistributionListExpansionHistory',
            0x0014: 'PidTagDistributionListExpansionProhibited',
            0x0015: 'PidTagExpiryTime',
            0x0016: 'PidTagImplicitConversionProhibited',
            0x0017: 'PidTagImportance',
            0x0019: 'PidTagLatestDeliveryTime',
            0x001A: 'PidTagMessageClass',
            0x001B: 'PidTagMessageDeliveryId',
            0x001E: 'PidTagMessageSecurityLabel',
            0x001F: 'PidTagObsoletedMessageIds',
            0x0020: 'PidTagOriginallyIntendedRecipientName',
            0x0021: 'PidTagOriginalEits',
            0x0022: 'PidTagOriginatorCertificate',
            0x0023: 'PidTagOriginatorDeliveryReportRequested',
            0x0024: 'PidTagOriginatorReturnAddress',
            0x0026: 'PidTagPriority',
            0x0027: 'PidTagOriginCheck',
            0x0028: 'PidTagProofOfSubmissionRequested',
            0x0029: 'PidTagReadReceiptRequested',
            0x002A: 'PidTagReceiptTime',
            0x002B: 'PidTagRecipientReassignmentProhibited',
            0x002C: 'PidTagRedirectionHistory',
            0x002D: 'PidTagRelatedMessageIds',
            0x002E: 'PidTagOriginalSensitivity',
            0x002F: 'PidTagLanguages',
            0x0030: 'PidTagReplyTime',
            0x0031: 'PidTagReportTag',
            0x0032: 'PidTagReportTime',
            0x0033: 'PidTagReturnedMessageid',
            0x0035: 'PidTagIncompleteCopy',
            0x0036: 'PidTagSensitivity',
            0x0037: 'PidTagSubject',
            0x0038: 'PidTagSubjectMessageId',
            0x0039: 'PidTagClientSubmitTime',
            0x003A: 'PidTagReportName',
            0x003B: 'PidTagSentRepresentingSearchKey',
            0x003C: 'PidTagX400ContentType',
            0x003D: 'PidTagSubjectPrefix',
            0x003E: 'PidTagNonReceiptReason',
            0x003F: 'PidTagReceivedByEntryId',
            0x0040: 'PidTagReceivedByName',
            0x0041: 'PidTagSentRepresentingEntryId',
            0x0042: 'PidTagSentRepresentingName',
            0x0043: 'PidTagReceivedRepresentingEntryId',
            0x0044: 'PidTagReceivedRepresentingName',
            0x0045: 'PidTagReportEntryId',
            0x0046: 'PidTagReadReceiptEntryId',
            0x0047: 'PidTagMessageSubmissionId',
            0x0048: 'PidTagProviderSubmitTime',
            0x0049: 'PidTagOriginalSubject',
            0x004B: 'PidTagOriginalMessageClass',
            0x004C: 'PidTagOriginalAuthorEntryId',
            0x004D: 'PidTagOriginalAuthorName',
            0x004E: 'PidTagOriginalSubmitTime',
            0x004F: 'PidTagReplyRecipientEntries',
            0x0050: 'PidTagReplyRecipientNames',
            0x0051: 'PidTagReceivedBySearchKey',
            0x0052: 'PidTagReceivedRepresentingSearchKey',
            0x0053: 'PidTagReadReceiptSearchKey',
            0x0054: 'PidTagReportSearchKey',
            0x0055: 'PidTagOriginalDeliveryTime',
            0x0056: 'PidTagOriginalAuthorSearchKey',
            0x0057: 'PidTagMessageToMe',
            0x0058: 'PidTagMessageCcMe',
            0x0059: 'PidTagMessageRecipientMe',
            0x005A: 'PidTagOriginalSenderName',
            0x005B: 'PidTagOriginalSenderEntryId',
            0x005C: 'PidTagOriginalSenderSearchKey',
            0x005D: 'PidTagOriginalSentRepresentingName',
            0x005E: 'PidTagOriginalSentRepresentingEntryId',
            0x005F: 'PidTagOriginalSentRepresentingSearchKey',
            0x0060: 'PidTagStartDate',
            0x0061: 'PidTagEndDate',
            0x0062: 'PidTagOwnerAppointmentId',
            0x0063: 'PidTagResponseRequested',
            0x0064: 'PidTagSentRepresentingAddressType',
            0x0065: 'PidTagSentRepresentingEmailAddress',
            0x0066: 'PidTagOriginalSenderAddressType',
            0x0067: 'PidTagOriginalSenderEmailAddress',
            0x0068: 'PidTagOriginalSentRepresentingAddressType',
            0x0069: 'PidTagOriginalSentRepresentingEmailAddress',
            0x0070: 'PidTagConversationTopic',
            0x0071: 'PidTagConversationIndex',
            0x0072: 'PidTagOriginalDisplayBcc',
            0x0073: 'PidTagOriginalDisplayCc',
            0x0074: 'PidTagOriginalDisplayTo',
            0x0075: 'PidTagReceivedByAddressType',
            0x0076: 'PidTagReceivedByEmailAddress',
            0x0077: 'PidTagReceivedRepresentingAddressType',
            0x0078: 'PidTagReceivedRepresentingEmailAddress',
            0x0079: 'PidTagOriginalAuthorAddressType',
            0x007A: 'PidTagOriginalAuthorEmailAddress',
            0x007B: 'PidTagOriginallyIntendedRecipAddrtype',
            0x007C: 'PidTagOriginallyIntendedRecipEmailAddress',
            0x007D: 'PidTagTransportMessageHeaders',
            0x007F: 'PidTagTnefCorrelationKey',
            0x0080: 'PidTagReportDisposition',
            0x0081: 'PidTagReportDispositionMode',
            0x0082: 'PidTagReportOriginalSender',
            0x0083: 'PidTagReportDispositionToNames',
            0x0084: 'PidTagReportDispositionToEmailAddresses',
            0x0085: 'PidTagReportDispositionOptions',
            0x0C00: 'PidTagContentIntegrityCheck',
            0x0C01: 'PidTagExplicitConversion',
            0x0C02: 'PidTagIpmReturnRequested',
            0x0C04: 'PidTagNonDeliveryReportReasonCode',
            0x0C05: 'PidTagNonDeliveryReportDiagCode',
            0x0C06: 'PidTagNonReceiptNotificationRequested',
            0x0C07: 'PidTagDeliveryPoint',
            0x0C08: 'PidTagOriginatorNonDeliveryReportRequested',
            0x0C09: 'PidTagOriginatorRequestedAlternateRecipient',
            0x0C0A: 'PidTagPhysicalDeliveryBureauFaxDelivery',
            0x0C0B: 'PidTagPhysicalDeliveryMode',
            0x0C0C: 'PidTagPhysicalDeliveryReportRequest',
            0x0C0D: 'PidTagPhysicalForwardingAddress',
            0x0C0E: 'PidTagPhysicalForwardingAddressRequested',
            0x0C0F: 'PidTagPhysicalForwardingProhibited',
            0x0C10: 'PidTagPhysicalRenditionAttributes',
            0x0C11: 'PidTagProofOfDelivery',
            0x0C12: 'PidTagProofOfDeliveryRequested',
            0x0C13: 'PidTagRecipientCertificate',
            0x0C14: 'PidTagRecipientNumberForAdvice',
            0x0C15: 'PidTagRecipientType',
            0x0C16: 'PidTagRegisteredMailType',
            0x0C17: 'PidTagReplyRequested',
            0x0C18: 'PidTagRequestedDeliveryMethod',
            0x0C19: 'PidTagSenderEntryId',
            0x0C1A: 'PidTagSenderName',
            0x0C1B: 'PidTagSupplementaryInfo',
            0x0C1C: 'PidTagTypeOfX400User',
            0x0C1D: 'PidTagSenderSearchKey',
            0x0C1E: 'PidTagSenderAddressType',
            0x0C1F: 'PidTagSenderEmailAddress',
            0x0E01: 'PidTagDeleteAfterSubmit',
            0x0E02: 'PidTagDisplayBcc',
            0x0E03: 'PidTagDisplayCc',
            0x0E04: 'PidTagDisplayTo',
            0x0E05: 'PidTagParentDisplay',
            0x0E06: 'PidTagMessageDeliveryTime',
            0x0E07: 'PidTagMessageFlags',
            0x0E08: 'PidTagMessageSize',
            0x0E08: 'PidTagMessageSizeExtended',
            0x0E09: 'PidTagParentEntryId',
            0x0E0A: 'PidTagSentMailEntryId',
            0x0E0C: 'PidTagCorrelate',
            0x0E0D: 'PidTagCorrelateMtsid',
            0x0E0E: 'PidTagDiscreteValues',
            0x0E0F: 'PidTagResponsibility',
            0x0E10: 'PidTagSpoolerStatus',
            0x0E12: 'PidTagMessageRecipients',
            0x0E13: 'PidTagMessageAttachments',
            0x0E14: 'PidTagSubmitFlags',
            0x0E15: 'PidTagRecipientStatus',
            0x0E16: 'PidTagTransportKey',
            0x0E17: 'PidTagMessageStatus',
            0x0E18: 'PidTagMessageDownloadTime',
            0x0E1B: 'PidTagHasAttachments',
            0x0E1C: 'PidTagBodyCrc',
            0x0E1D: 'PidTagNormalizedSubject',
            0x0E1F: 'PidTagRtfInSync',
            0x0E20: 'PidTagAttachSize',
            0x0E21: 'PidTagAttachNumber',
            0x0E22: 'PidTagPreprocess',
            0x0E23: 'PidTagInternetArticleNumber',
            0x0E25: 'PidTagOriginatingMtaCertificate',
            0x0E26: 'PidTagProofOfSubmission',
            0x0E28: 'PidTagPrimarySendAccount',
            0x0E29: 'PidTagNextSendAcct',
            0x0E2B: 'PidTagToDoItemFlags',
            0x0E2C: 'PidTagSwappedToDoStore',
            0x0E2D: 'PidTagSwappedToDoData',
            0x0E69: 'PidTagRead',
            0x0E99: 'PidTagExtendedRuleMessageActions',
            0x0E9A: 'PidTagExtendedRuleMessageCondition',
            0x0E9B: 'PidTagExtendedRuleSizeLimit',
            0x0E9C: 'PidTagTnefUnprocessedProps',
            0x0EA00048: 'PidTagAssociatedSharingProvider',
            0x0EA3: 'PidTagProviderItemId',
            0x0EA4: 'PidTagProviderParentItemId',
            0x0EA5: 'PidTagSearchAttachments',
            0x0EA6: 'PidTagSearchRecipientEmailTo',
            0x0EA7: 'PidTagSearchRecipientEmailCc',
            0x0FF4: 'PidTagAccess',
            0x0FF5: 'PidTagRowType',
            0x0FF6: 'PidTagInstanceKey',
            0x0FF7: 'PidTagAccessLevel',
            0x0FF8: 'PidTagMappingSignature',
            0x0FF9: 'PidTagRecordKey',
            0x0FFA: 'PidTagStoreRecordKey',
            0x0FFB: 'PidTagStoreEntryId',
            0x0FFC: 'PidTagMiniIcon',
            0x0FFD: 'PidTagIcon',
            0x0FFE: 'PidTagObjectType',
            0x0FFF: 'PidTagEntryId',
            0x0FFF: 'PidTagMemberEntryId',
            0x1000: 'PidTagBody',
            0x1001: 'PidTagReportText',
            0x1002: 'PidTagOriginatorAndDistributionListExpansionHistory',
            0x1003: 'PidTagReportingDistributionListName',
            0x1004: 'PidTagReportingMessageTransferAgentCertificate',
            0x1006: 'PidTagRtfSyncBodyCrc',
            0x1007: 'PidTagRtfSyncBodyCount',
            0x1008: 'PidTagRtfSyncBodyTag',
            0x1009: 'PidTagRtfCompressed',
            0x1010: 'PidTagRtfSyncPrefixCount',
            0x1011: 'PidTagRtfSyncTrailingCount',
            0x1012: 'PidTagOriginallyIntendedRecipEntryId',
            0x1013: 'PidTagBodyHtml',
            0x1013: 'PidTagHtml',
            0x1014: 'PidTagBodyContentLocation',
            0x1030: 'PidTagInternetApproved',
            0x1031: 'PidTagInternetControl',
            0x1032: 'PidTagInternetDistribution',
            0x1033: 'PidTagInternetFollowupTo',
            0x1034: 'PidTagInternetLines',
            0x1035: 'PidTagInternetMessageId',
            0x1037: 'PidTagInternetOrganization',
            0x1038: 'PidTagInternetNntpPath',
            0x1039: 'PidTagInternetReferences',
            0x1042: 'PidTagInReplyToId',
            0x1043: 'PidTagListHelp',
            0x1044: 'PidTagListSubscribe',
            0x1045: 'PidTagListUnsubscribe',
            0x1046: 'PidTagInternetReturnPath',
            0x1080: 'PidTagIconIndex',
            0x1081: 'PidTagLastVerbExecuted',
            0x1082: 'PidTagLastVerbExecutionTime',
            0x1090: 'PidTagFlagStatus',
            0x1091: 'PidTagFlagCompleteTime',
            0x1095: 'PidTagFollowupIcon',
            0x1097: 'PidTagItemTemporaryflags',
            0x1098: 'PidTagConflictItems',
            0x10F0: 'PidTagImapCachedMsgsize',
            0x10F3: 'PidTagUrlComponentName',
            0x3000: 'PidTagRowid',
            0x3001: 'PidTagDisplayName',
            0x3002: 'PidTagAddressType',
            0x3003: 'PidTagEmailAddress',
            0x3004: 'PidTagComment',
            0x3005: 'PidTagDepth',
            0x3006: 'PidTagProviderDisplay',
            0x3007: 'PidTagCreationTime',
            0x3008: 'PidTagLastModificationTime',
            0x3009: 'PidTagResourceFlags',
            0x300A: 'PidTagProviderDllName',
            0x300B: 'PidTagSearchKey',
            0x300C: 'PidTagProviderUid',
            0x300D: 'PidTagProviderOrdinal',
            0x3301: 'PidTagFormVersion',
            0x3302: 'PidTagFormClassId',
            0x3303: 'PidTagFormContactName',
            0x3304: 'PidTagFormCategory',
            0x3305: 'PidTagFormCategorySub',
            0x3306: 'PidTagFormHostMap',
            0x3307: 'PidTagFormHidden',
            0x3308: 'PidTagFormDesignerName',
            0x3309: 'PidTagFormDesignerGuid',
            0x330A: 'PidTagFormMessageBehavior',
            0x3400: 'PidTagDefaultStore',
            0x340D: 'PidTagStoreSupportMask',
            0x340E: 'PidTagStoreState',
            0x340F: 'PidTagStoreUnicodeMask',
            0x3414: 'PidTagStoreProvider',
            0x3415: 'PidTagReceiveFolderSettings',
            0x3417: 'PidTagProviderIcon',
            0x3418: 'PidTagProviderDisplayName',
            0x3439000: 'PidTagInferenceEnabled',
            0x35DF: 'PidTagValidFolderMask',
            0x35E0: 'PidTagIpmSubtreeEntryId',
            0x35E2: 'PidTagIpmOutboxEntryId',
            0x35E3: 'PidTagIpmWastebasketEntryId',
            0x35E4: 'PidTagIpmSentMailEntryId',
            0x35E5: 'PidTagViewsEntryId',
            0x35E6: 'PidTagCommonViewsEntryId',
            0x35E7: 'PidTagFinderEntryId',
            0x3600: 'PidTagContainerFlags',
            0x3601: 'PidTagFolderType',
            0x3602: 'PidTagContentCount',
            0x3603: 'PidTagContentUnreadCount',
            0x3604: 'PidTagCreateTemplates',
            0x3605: 'PidTagDetailsTable',
            0x3607: 'PidTagSearch',
            0x3609: 'PidTagSelectable',
            0x360A: 'PidTagSubfolders',
            0x360B: 'PidTagStatus',
            0x360C: 'PidTagAnr',
            0x360E: 'PidTagContainerHierarchy',
            0x360F: 'PidTagContainerContents',
            0x3610: 'PidTagFolderAssociatedContents',
            0x3611: 'PidTagDefCreateDl',
            0x3612: 'PidTagDefCreateMailuser',
            0x3613: 'PidTagContainerClass',
            0x3615: 'PidTagAbProviderId',
            0x3616: 'PidTagDefaultViewEntryId',
            0x3617: 'PidTagAssociatedContentCount',
            0x36D0: 'PidTagIpmAppointmentEntryId',
            0x36D1: 'PidTagIpmContactEntryId',
            0x36D2: 'PidTagIpmJournalEntryId',
            0x36D3: 'PidTagIpmNoteEntryId',
            0x36D4: 'PidTagIpmTaskEntryId',
            0x36D5: 'PidTagRemindersOnlineEntryId',
            0x36D7: 'PidTagIpmDraftsEntryId',
            0x36D8: 'PidTagAdditionalRenEntryIds',
            0x36D9: 'PidTagAdditionalRenEntryIdsEx',
            0x36DA: 'PidTagExtendedFolderFlags',
            0x36E2: 'PidTagOrdinalMost',
            0x36E4: 'PidTagFreeBusyEntryIds',
            0x36E5: 'PidTagDefaultPostMessageClass',
            0x36EC: 'PidTagAgingPeriod',
            0x36EE: 'PidTagAgingGranularity',
            0x3701: 'PidTagAttachDataBinary',
            0x3701: 'PidTagAttachDataObject',
            0x3702: 'PidTagAttachEncoding',
            0x3703: 'PidTagAttachExtension',
            0x3704: 'PidTagAttachFilename',
            0x3705: 'PidTagAttachMethod',
            0x3707: 'PidTagAttachLongFilename',
            0x3708: 'PidTagAttachPathname',
            0x3709: 'PidTagAttachRendering',
            0x370A: 'PidTagAttachTag',
            0x370B: 'PidTagRenderingPosition',
            0x370C: 'PidTagAttachTransportName',
            0x370D: 'PidTagAttachLongPathname',
            0x370E: 'PidTagAttachMimeTag',
            0x370F: 'PidTagAttachAdditionalInformation',
            0x3710: 'PidTagAttachMimeSequence',
            0x3711: 'PidTagAttachContentBase',
            0x3712: 'PidTagAttachContentId',
            0x3713: 'PidTagAttachContentLocation',
            0x3714: 'PidTagAttachFlags',
            0x3719: 'PidTagAttachPayloadProviderGuidString',
            0x371A: 'PidTagAttachPayloadClass',
            0x371B: 'PidTagTextAttachmentCharset',
            0x3900: 'PidTagDisplayType',
            0x3902: 'PidTagTemplateid',
            0x3905: 'PidTagDisplayTypeEx',
            0x39FE: 'PidTagSmtpAddress',
            0x39FF: 'PidTag7BitDisplayName',
            0x3A00: 'PidTagAccount',
            0x3A01: 'PidTagAlternateRecipient',
            0x3A02: 'PidTagCallbackTelephoneNumber',
            0x3A03: 'PidTagConversionProhibited',
            0x3A05: 'PidTagGeneration',
            0x3A06: 'PidTagGivenName',
            0x3A07: 'PidTagGovernmentIdNumber',
            0x3A08: 'PidTagBusinessTelephoneNumber',
            0x3A09: 'PidTagHomeTelephoneNumber',
            0x3A0A: 'PidTagInitials',
            0x3A0B: 'PidTagKeyword',
            0x3A0C: 'PidTagLanguage',
            0x3A0D: 'PidTagLocation',
            0x3A0E: 'PidTagMailPermission',
            0x3A0F: 'PidTagMessageHandlingSystemCommonName',
            0x3A10: 'PidTagOrganizationalIdNumber',
            0x3A11: 'PidTagSurname',
            0x3A12: 'PidTagOriginalEntryId',
            0x3A13: 'PidTagOriginalDisplayName',
            0x3A14: 'PidTagOriginalSearchKey',
            0x3A15: 'PidTagPostalAddress',
            0x3A16: 'PidTagCompanyName',
            0x3A17: 'PidTagTitle',
            0x3A18: 'PidTagDepartmentName',
            0x3A19: 'PidTagOfficeLocation',
            0x3A1A: 'PidTagPrimaryTelephoneNumber',
            0x3A1B: 'PidTagBusiness2TelephoneNumber',
            0x3A1B: 'PidTagBusiness2TelephoneNumbers',
            0x3A1C: 'PidTagMobileTelephoneNumber',
            0x3A1D: 'PidTagRadioTelephoneNumber',
            0x3A1E: 'PidTagCarTelephoneNumber',
            0x3A1F: 'PidTagOtherTelephoneNumber',
            0x3A20: 'PidTagTransmittableDisplayName',
            0x3A21: 'PidTagPagerTelephoneNumber',
            0x3A22: 'PidTagUserCertificate',
            0x3A23: 'PidTagPrimaryFaxNumber',
            0x3A24: 'PidTagBusinessFaxNumber',
            0x3A25: 'PidTagHomeFaxNumber',
            0x3A26: 'PidTagCountry',
            0x3A27: 'PidTagLocality',
            0x3A28: 'PidTagStateOrProvince',
            0x3A29: 'PidTagStreetAddress',
            0x3A2A: 'PidTagPostalCode',
            0x3A2B: 'PidTagPostOfficeBox',
            0x3A2C: 'PidTagTelexNumber',
            0x3A2D: 'PidTagIsdnNumber',
            0x3A2E: 'PidTagAssistantTelephoneNumber',
            0x3A2F: 'PidTagHome2TelephoneNumber',
            0x3A2F: 'PidTagHome2TelephoneNumbers',
            0x3A30: 'PidTagAssistant',
            0x3A40: 'PidTagSendRichInfo',
            0x3A41: 'PidTagWeddingAnniversary',
            0x3A42: 'PidTagBirthday',
            0x3A43: 'PidTagHobbies',
            0x3A44: 'PidTagMiddleName',
            0x3A45: 'PidTagDisplayNamePrefix',
            0x3A46: 'PidTagProfession',
            0x3A47: 'PidTagPreferredByName',
            0x3A47: 'PidTagReferredByName',
            0x3A48: 'PidTagSpouseName',
            0x3A49: 'PidTagComputerNetworkName',
            0x3A4A: 'PidTagCustomerId',
            0x3A4B: 'PidTagTelecommunicationsDeviceForDeafTelephoneNumber',
            0x3A4B: 'PidTagTtyTddPhoneNumber',
            0x3A4C: 'PidTagFtpSite',
            0x3A4D: 'PidTagGender',
            0x3A4E: 'PidTagManagerName',
            0x3A4F: 'PidTagNickname',
            0x3A50: 'PidTagPersonalHomePage',
            0x3A51: 'PidTagBusinessHomePage',
            0x3A52: 'PidTagContactVersion',
            0x3A54: 'PidTagContactAddressTypes',
            0x3A57: 'PidTagCompanyMainTelephoneNumber',
            0x3A58: 'PidTagChildrensNames',
            0x3A59: 'PidTagHomeAddressCity',
            0x3A5A: 'PidTagHomeAddressCountry',
            0x3A5B: 'PidTagHomeAddressPostalCode',
            0x3A5C: 'PidTagHomeAddressStateOrProvince',
            0x3A5D: 'PidTagHomeAddressStreet',
            0x3A5E: 'PidTagHomeAddressPostOfficeBox',
            0x3A5F: 'PidTagOtherAddressCity',
            0x3A60: 'PidTagOtherAddressCountry',
            0x3A61: 'PidTagOtherAddressPostalCode',
            0x3A62: 'PidTagOtherAddressStateOrProvince',
            0x3A63: 'PidTagOtherAddressStreet',
            0x3A64: 'PidTagOtherAddressPostOfficeBox',
            0x3A70: 'PidTagUserX509Certificate',
            0x3A71: 'PidTagSendInternetEncoding',
            0x3D00: 'PidTagStoreProviders',
            0x3D01: 'PidTagAbProviders',
            0x3D02: 'PidTagTransportProviders',
            0x3D04: 'PidTagDefaultProfile',
            0x3D05: 'PidTagAbSearchPath',
            0x3D06: 'PidTagAbDefaultDir',
            0x3D07: 'PidTagAbDefaultPab',
            0x3D09: 'PidTagServiceName',
            0x3D0A: 'PidTagServiceDllName',
            0x3D0B: 'PidTagServiceEntryName',
            0x3D0C: 'PidTagServiceUid',
            0x3D0D: 'PidTagServiceExtraUids',
            0x3D0E: 'PidTagServices',
            0x3D0F: 'PidTagServiceSupportFiles',
            0x3D10: 'PidTagServiceDeleteFiles',
            0x3D11: 'PidTagAbSearchPathUpdate',
            0x3D12: 'PidTagProfileName',
            0x3D13: 'PidTagServiceInstallId',
            0x3D1C000B: 'PidTagAddressBookChooseDirectoryAutomatically',
            0x3E00: 'PidTagIdentityDisplay',
            0x3E01: 'PidTagIdentityEntryId',
            0x3E02: 'PidTagResourceMethods',
            0x3E03: 'PidTagResourceType',
            0x3E04: 'PidTagStatusCode',
            0x3E05: 'PidTagIdentitySearchKey',
            0x3E06: 'PidTagOwnStoreEntryId',
            0x3E07: 'PidTagResourcePath',
            0x3E08: 'PidTagStatusString',
            0x3E0B: 'PidTagRemoteProgress',
            0x3E0C: 'PidTagRemoteProgressText',
            0x3E0D: 'PidTagRemoteValidateOk',
            0x3F00: 'PidTagControlFlags',
            0x3F01: 'PidTagControlStructure',
            0x3F02: 'PidTagControlType',
            0x3F03: 'PidTagDeltaX',
            0x3F04: 'PidTagDeltaY',
            0x3F05: 'PidTagXCoordinate',
            0x3F06: 'PidTagYCoordinate',
            0x3F07: 'PidTagControlId',
            0x3F08: 'PidTagInitialDetailsPane',
            0x3FDE: 'PidTagInternetCodepage',
            0x3FE0: 'PidTagAccessControlListTable',
            0x3FE1: 'PidTagRulesTable',
            0x3FE3: 'PidTagDelegatedByRule',
            0x3FE7: 'PidTagResolveMethod',
            0x3FEA: 'PidTagHasDeferredActionMessages',
            0x3FEB: 'PidTagDeferredSendNumber',
            0x3FEC: 'PidTagDeferredSendUnits',
            0x3FED: 'PidTagExpiryNumber',
            0x3FEE: 'PidTagExpiryUnits',
            0x3FEF: 'PidTagDeferredSendTime',
            0x3FF0: 'PidTagConflictEntryId',
            0x3FF1: 'PidTagMessageLocaleId',
            0x3FFD: 'PidTagMessageCodepage',
            0x5902: 'PidTagInternetMailOverrideFormat',
            0x5909: 'PidTagMessageEditorFormat',
            0x5D01: 'PidTagSenderSmtpAddress',
            0x5D02: 'PidTagSentRepresentingSmtpAddress',
            0x5FE1: 'PidTagRecipientProposed',
            0x5FE3: 'PidTagRecipientProposedStartTime',
            0x5FE4: 'PidTagRecipientProposedEndTime',
            0x5FF6: 'PidTagRecipientDisplayName',
            0x5FF7: 'PidTagRecipientEntryId',
            0x5FFB: 'PidTagRecipientTrackStatusTime',
            0x5FFD: 'PidTagRecipientFlags',
            0x5FFF: 'PidTagRecipientTrackStatus',
            0x6100: 'PidTagJunkIncludeContacts',
            0x6101: 'PidTagJunkThreshold',
            0x6102: 'PidTagJunkPermanentlyDelete',
            0x6103: 'PidTagJunkAddRecipientsToSafeSendersList',
            0x6107: 'PidTagJunkPhishingEnableLinks',
            0x65C2: 'PidTagReplyTemplateId',
            0x65EB: 'PidTagRuleMsgProvider',
            0x65EC: 'PidTagRuleMsgName',
            0x65F60102: 'PidTagStoreEntryIdEmsmdbV1',
            0x6601: 'PidTagContactAddressBookUid',
            0x6602: 'PidTagContactAddressBookSortFlag',
            0x660A: 'PidTagProfileType',
            0x6610: 'PidTagContactAddressBookFolderEntryId',
            0x6611: 'PidTagContactAddressBookStoreSupportMask',
            0x6612: 'PidTagContactAddressBookStoreName',
            0x6613: 'PidTagContactAddressBookFolderName',
            0x6614: 'PidTagContactAddressBookMultipleAddressFlag',
            0x661B: 'PidTagProfileServerVersion',
            0x6620: 'PidTagContactAddressBookFolderEntryIds',
            0x6620: 'PidTagNonIpmSubtreeEntryId',
            0x6621: 'PidTagContactAddressBookStoreSupportMasks',
            0x6622: 'PidTagContactAddressBookStoreNames',
            0x6622: 'PidTagRpcOverHttpProxyServer',
            0x6623: 'PidTagContactAddressBookFolderNames',
            0x6623: 'PidTagRpcOverHttpFlags',
            0x6624: 'PidTagContactAddressBookDisplayNames',
            0x6625: 'PidTagContactAddressBookMultipleAddressFlags',
            0x6625: 'PidTagRpcOverHttpProxyPrincipalName',
            0x6626: 'PidTagContactAddressBookStoreEntryIds',
            0x6627: 'PidTagRpcOverHttpProxyAuthScheme',
            0x662A001F: 'PidTagProfileHomeServerFQDN',
            0x663B: 'PidTagProfileServerFullVersion',
            0x6662: 'PidTagRecipientNumber',
            0x666C: 'PidTagInConflict',
            0x6671: 'PidTagMemberId',
            0x6672: 'PidTagMemberName',
            0x6673: 'PidTagMemberRights',
            0x6674: 'PidTagRuleId',
            0x6676: 'PidTagRuleSequence',
            0x6677: 'PidTagRuleState',
            0x6678: 'PidTagRuleUserFlags',
            0x6679: 'PidTagRuleCondition',
            0x6680: 'PidTagRuleActions',
            0x6681: 'PidTagRuleProvider',
            0x6682: 'PidTagRuleName',
            0x6683: 'PidTagRuleLevel',
            0x6684: 'PidTagRuleProviderData',
            0x66A1: 'PidTagLocaleId',
            0x6700: 'PidTagPstPath',
            0x6700: 'PidTagWizardNoPstPage',
            0x6701: 'PidTagPstRememberPassword',
            0x6701: 'PidTagWizardNoPabPage',
            0x6703: 'PidTagPstPasswordSzOld',
            0x6704: 'PidTagPstPasswordSzNew',
            0x6770: 'PidTagPstConfigurationFlags',
            0x6771: 'PidTagPstPathHint',
            0x6834: 'PidTagSearchFolderLastUsed',
            0x683A: 'PidTagSearchFolderExpiration',
            0x6841: 'PidTagScheduleInfoResourceType',
            0x6841: 'PidTagSearchFolderTemplateId',
            0x6842: 'PidTagScheduleInfoDelegatorWantsCopy',
            0x6842: 'PidTagSearchFolderId',
            0x6843: 'PidTagScheduleInfoDontMailDelegates',
            0x6844: 'PidTagScheduleInfoDelegateNames',
            0x6845: 'PidTagScheduleInfoDelegateEntryIds',
            0x6845: 'PidTagSearchFolderDefinition',
            0x6846: 'PidTagSearchFolderStorageType',
            0x6847: 'PidTagFreeBusyPublishStart',
            0x6847: 'PidTagSearchFolderTag',
            0x6848: 'PidTagFreeBusyPublishEnd',
            0x6848: 'PidTagSearchFolderEfpFlags',
            0x684B: 'PidTagScheduleInfoDelegatorWantsInfo',
            0x684F: 'PidTagScheduleInfoMonthsMerged',
            0x6850: 'PidTagScheduleInfoFreeBusyMerged',
            0x6851: 'PidTagScheduleInfoMonthsTentative',
            0x6852: 'PidTagScheduleInfoFreeBusyTentative',
            0x6853: 'PidTagScheduleInfoMonthsBusy',
            0x6854: 'PidTagScheduleInfoFreeBusyBusy',
            0x6855: 'PidTagScheduleInfoMonthsAway',
            0x6856: 'PidTagScheduleInfoFreeBusyAway',
            0x6868: 'PidTagFreeBusyRangeTimestamp',
            0x6869: 'PidTagFreeBusyCountMonths',
            0x686A: 'PidTagScheduleInfoAppointmentTombstone',
            0x686B: 'PidTagDelegateFlags',
            0x686C: 'PidTagScheduleInfoFreeBusy',
            0x686D: 'PidTagScheduleInfoAutoAcceptAppointments',
            0x686E: 'PidTagScheduleInfoDisallowRecurringAppts',
            0x686F: 'PidTagScheduleInfoDisallowOverlappingAppts',
            0x6904: 'PidTagNonDeliveryReportFromEntryId',
            0x6905: 'PidTagNonDeliveryReportFromName',
            0x6906: 'PidTagNonDeliveryReportFromSearchKey',
            0x7006: 'PidTagViewDescriptorName',
            0x7007: 'PidTagViewDescriptorVersion',
            0x7C06: 'PidTagRoamingDatatypes',
            0x7C07: 'PidTagRoamingDictionary',
            0x7C08: 'PidTagRoamingXmlStream',
            0x7C09: 'PidTagRoamingBinary',
            0x7D01: 'PidTagProcessed',
            0x7FF9: 'PidTagExceptionReplaceTime',
            0x7FFA: 'PidTagAttachmentLinkId',
            0x7FFB: 'PidTagExceptionStartTime',
            0x7FFC: 'PidTagExceptionEndTime',
            0x7FFD: 'PidTagAttachmentFlags',
            0x7FFE: 'PidTagAttachmentHidden',
            0x7FFF: 'PidTagAttachmentContactPhoto',
            0x8005: 'PidLidFileUnder',
            0x8006: 'PidLidFileUnderId',
            0x8007: 'PidLidContactItemData',
            0x8015: 'PidLidHasPicture',
            0x801A: 'PidLidHomeAddress',
            0x801B: 'PidLidWorkAddress',
            0x801C: 'PidLidOtherAddress',
            0x8022: 'PidLidPostalAddressId',
            0x8023: 'PidLidContactCharacterSet',
            0x8025: 'PidLidAutoLog',
            0x8026: 'PidLidFileUnderList',
            0x8028: 'PidLidAddressBookProviderEmailList',
            0x8029: 'PidLidAddressBookProviderArrayType',
            0x802B: 'PidLidHtml',
            0x802C: 'PidLidYomiFirstName',
            0x802D: 'PidLidYomiLastName',
            0x802E: 'PidLidYomiCompanyName',
            0x8040: 'PidLidBusinessCardDisplayDefinition',
            0x8041: 'PidLidBusinessCardCardPicture',
            0x8045: 'PidLidWorkAddressStreet',
            0x8046: 'PidLidWorkAddressCity',
            0x8047: 'PidLidWorkAddressState',
            0x8048: 'PidLidWorkAddressPostalCode',
            0x8049: 'PidLidWorkAddressCountry',
            0x804A: 'PidLidWorkAddressPostOfficeBox',
            0x804C: 'PidLidDistributionListChecksum',
            0x804D: 'PidLidBirthdayEventEntryId',
            0x804E: 'PidLidAnniversaryEventEntryId',
            0x804F: 'PidLidContactUserField1',
            0x8050: 'PidLidContactUserField2',
            0x8051: 'PidLidContactUserField3',
            0x8052: 'PidLidContactUserField4',
            0x8053: 'PidLidDistributionListName',
            0x8054: 'PidLidDistributionListOneOffMembers',
            0x8055: 'PidLidDistributionListMembers',
            0x8062: 'PidLidInstantMessagingAddress',
            0x8080: 'PidLidEmail1DisplayName',
            0x8082: 'PidLidEmail1AddressType',
            0x8083: 'PidLidEmail1EmailAddress',
            0x8084: 'PidLidEmail1OriginalDisplayName',
            0x8085: 'PidLidEmail1OriginalEntryId',
            0x8090: 'PidLidEmail2DisplayName',
            0x8092: 'PidLidEmail2AddressType',
            0x8093: 'PidLidEmail2EmailAddress',
            0x8094: 'PidLidEmail2OriginalDisplayName',
            0x8095: 'PidLidEmail2OriginalEntryId',
            0x80A0: 'PidLidEmail3DisplayName',
            0x80A2: 'PidLidEmail3AddressType',
            0x80A3: 'PidLidEmail3EmailAddress',
            0x80A4: 'PidLidEmail3OriginalDisplayName',
            0x80A5: 'PidLidEmail3OriginalEntryId',
            0x80B0: 'PidLidFax1DisplayName',
            0x80B1: 'PidLidFax1EntryId',
            0x80B2: 'PidLidFax1AddressType',
            0x80B3: 'PidLidFax1EmailAddress',
            0x80B4: 'PidLidFax1OriginalDisplayName',
            0x80B5: 'PidLidFax1OriginalEntryId',
            0x80B6: 'PidLidFax1RichTextFormat',
            0x80B7: 'PidLidFax1EmailType',
            0x80C0: 'PidLidFax2DisplayName',
            0x80C1: 'PidLidFax2EntryId',
            0x80C2: 'PidLidFax2AddressType',
            0x80C3: 'PidLidFax2EmailAddress',
            0x80C4: 'PidLidFax2OriginalDisplayName',
            0x80C5: 'PidLidFax2OriginalEntryId',
            0x80C6: 'PidLidFax2RichTextFormat',
            0x80C7: 'PidLidFax2EmailType',
            0x80D0: 'PidLidFax3DisplayName',
            0x80D1: 'PidLidFax3EntryId',
            0x80D2: 'PidLidFax3AddressType',
            0x80D3: 'PidLidFax3EmailAddress',
            0x80D4: 'PidLidFax3OriginalDisplayName',
            0x80D5: 'PidLidFax3OriginalEntryId',
            0x80D6: 'PidLidFax3RichTextFormat',
            0x80D7: 'PidLidFax3EmailType',
            0x80D8: 'PidLidFreeBusyLocation',
            0x80D9: 'PidLidUserX509Certificate',
            0x80DA: 'PidLidHomeAddressCountryCode',
            0x80DB: 'PidLidWorkAddressCountryCode',
            0x80DC: 'PidLidOtherAddressCountryCode',
            0x80DD: 'PidLidAddressCountryCode',
            0x8101: 'PidLidTaskStatus',
            0x8102: 'PidLidPercentComplete',
            0x8104: 'PidLidTaskStartDate',
            0x8105: 'PidLidTaskDueDate',
            0x8107: 'PidLidTaskResetReminder',
            0x8108: 'PidLidTaskAccepted',
            0x8109: 'PidLidTaskDeadOccurrence',
            0x810F: 'PidLidTaskDateCompleted',
            0x8110: 'PidLidTaskActualEffort',
            0x8111: 'PidLidTaskEstimatedEffort',
            0x8112: 'PidLidTaskVersion',
            0x8113: 'PidLidTaskState',
            0x8115: 'PidLidTaskLastUpdate',
            0x8116: 'PidLidTaskRecurrence',
            0x8117: 'PidLidTaskAssigners',
            0x8119: 'PidLidTaskStatusOnComplete',
            0x811A: 'PidLidTaskHistory',
            0x811B: 'PidLidTaskUpdates',
            0x811C: 'PidLidTaskComplete',
            0x811E: 'PidLidTaskFCreator',
            0x811F: 'PidLidTaskOwner',
            0x8120: 'PidLidTaskMultipleRecipients',
            0x8121: 'PidLidTaskAssigner',
            0x8122: 'PidLidTaskLastUser',
            0x8123: 'PidLidTaskOrdinal',
            0x8125: 'PidLidTaskLastDelegate',
            0x8126: 'PidLidTaskFRecurring',
            0x8129: 'PidLidTaskOwnership',
            0x812A: 'PidLidTaskAcceptanceState',
            0x812C: 'PidLidTaskFFixOffline',
            0x8200: 'PidLidSendMeetingAsIcal',
            0x8201: 'PidLidAppointmentSequence',
            0x8202: 'PidLidAppointmentSequenceTime',
            0x8203: 'PidLidAppointmentLastSequence',
            0x8204: 'PidLidChangeHighlight',
            0x8205: 'PidLidBusyStatus',
            0x8206: 'PidLidFExceptionalBody',
            0x8207: 'PidLidAppointmentAuxiliaryFlags',
            0x8208: 'PidLidLocation',
            0x8209: 'PidLidMeetingWorkspaceUrl',
            0x820A: 'PidLidForwardInstance',
            0x820C: 'PidLidLinkedTaskItems',
            0x820D: 'PidLidAppointmentStartWhole',
            0x820E: 'PidLidAppointmentEndWhole',
            0x8213: 'PidLidAppointmentDuration',
            0x8214: 'PidLidAppointmentColor',
            0x8215: 'PidLidAppointmentSubType',
            0x8216: 'PidLidAppointmentRecur',
            0x8217: 'PidLidAppointmentStateFlags',
            0x8218: 'PidLidResponseStatus',
            0x8220: 'PidLidAppointmentReplyTime',
            0x8223: 'PidLidRecurring',
            0x8224: 'PidLidIntendedBusyStatus',
            0x8228: 'PidLidExceptionReplaceTime',
            0x8229: 'PidLidFInvited',
            0x822B: 'PidLidFExceptionalAttendees',
            0x8230: 'PidLidAppointmentReplyName',
            0x8231: 'PidLidRecurrenceType',
            0x8232: 'PidLidRecurrencePattern',
            0x8233: 'PidLidTimeZoneStruct',
            0x8234: 'PidLidTimeZoneDescription',
            0x8235: 'PidLidClipStart',
            0x8236: 'PidLidClipEnd',
            0x8237: 'PidLidOriginalStoreEntryId',
            0x8238: 'PidLidAllAttendeesString',
            0x823A: 'PidLidAutoFillLocation',
            0x823B: 'PidLidToAttendeesString',
            0x823C: 'PidLidCcAttendeesString',
            0x823D: 'PidLidAppointmentUnsendableRecipients',
            0x8250: 'PidLidAppointmentProposedStartWhole',
            0x8251: 'PidLidAppointmentProposedEndWhole',
            0x8251: 'PidLidCustomFlag',
            0x8256: 'PidLidAppointmentProposedDuration',
            0x8257: 'PidLidAppointmentCounterProposal',
            0x8259: 'PidLidAppointmentProposalNumber',
            0x825A: 'PidLidAppointmentNotAllowPropose',
            0x825E: 'PidLidAppointmentTimeZoneDefinitionStartDisplay',
            0x825F: 'PidLidAppointmentTimeZoneDefinitionEndDisplay',
            0x8260: 'PidLidAppointmentTimeZoneDefinitionRecur',
            0x8501: 'PidLidReminderDelta',
            0x8502: 'PidLidReminderTime',
            0x8503: 'PidLidReminderSet',
            0x8506: 'PidLidPrivate',
            0x850E: 'PidLidAgingDontAgeMe',
            0x8510: 'PidLidSideEffects',
            0x8514: 'PidLidSmartNoAttach',
            0x8516: 'PidLidCommonStart',
            0x8517: 'PidLidCommonEnd',
            0x8518: 'PidLidTaskMode',
            0x8519: 'PidLidTaskGlobalId',
            0x851A: 'PidLidAutoProcessState',
            0x851C: 'PidLidReminderOverride',
            0x851E: 'PidLidReminderPlaySound',
            0x851F: 'PidLidReminderFileParameter',
            0x8520: 'PidLidVerbStream',
            0x8524: 'PidLidVerbResponse',
            0x8530: 'PidLidFlagRequest',
            0x8534: 'PidLidMileage',
            0x8535: 'PidLidBilling',
            0x8536: 'PidLidNonSendableTo',
            0x8537: 'PidLidNonSendableCc',
            0x8538: 'PidLidNonSendableBcc',
            0x8539: 'PidLidCompanies',
            0x853A: 'PidLidContacts',
            0x8540: 'PidLidPropertyDefinitionStream',
            0x8543: 'PidLidNonSendToTrackStatus',
            0x8544: 'PidLidNonSendCcTrackStatus',
            0x8545: 'PidLidNonSendableBccTrackStatus',
            0x8549: 'PidLidRecallTime',
            0x8552: 'PidLidCurrentVersion',
            0x8554: 'PidLidCurrentVersionName',
            0x8560: 'PidLidReminderSignalTime',
            0x8570: 'PidLidImapDeleted',
            0x8578: 'PidLidHeaderItem',
            0x8580: 'PidLidInternetAccountName',
            0x8581: 'PidLidInternetAccountStamp',
            0x8582: 'PidLidUseTnef',
            0x8584: 'PidLidContactLinkSearchKey',
            0x8585: 'PidLidContactLinkEntry',
            0x8586: 'PidLidContactLinkName',
            0x8593: 'PidLidImageAttachmentsCompressionLevel',
            0x859B: 'PidLidIsInterpersonalFax',
            0x859C: 'PidLidSpamOriginalFolder',
            0x85A0: 'PidLidToDoOrdinalDate',
            0x85A1: 'PidLidToDoSubOrdinal',
            0x85A4: 'PidLidToDoTitle',
            0x85A5: 'PidLidFShouldTNEF',
            0x85B5: 'PidLidClassified',
            0x85B6: 'PidLidClassification',
            0x85B7: 'PidLidClassificationDescription',
            0x85B8: 'PidLidClassificationGuid',
            0x85B9: 'PidLidOfflineStatus',
            0x85BA: 'PidLidClassificationKeep',
            0x85BD: 'PidLidReferenceEntryId',
            0x85BF: 'PidLidValidFlagStringProof',
            0x85C0: 'PidLidFlagString',
            0x8700: 'PidLidLogType',
            0x8706: 'PidLidLogStart',
            0x8707: 'PidLidLogDuration',
            0x8708: 'PidLidLogEnd',
            0x870C: 'PidLidLogFlags',
            0x870E: 'PidLidLogDocumentPrinted',
            0x870F: 'PidLidLogDocumentSaved',
            0x8710: 'PidLidLogDocumentRouted',
            0x8711: 'PidLidLogDocumentPosted',
            0x8712: 'PidLidLogTypeDesc',
            0x8900: 'PidLidPostRssChannelLink',
            0x8904: 'PidLidPostRssChannel',
            0x8A01: 'PidLidSharingProviderGuid',
            0x8A02: 'PidLidSharingProviderName',
            0x8A03: 'PidLidSharingProviderUrl',
            0x8A05: 'PidLidSharingRemoteName',
            0x8A06: 'PidLidSharingRemoteUid',
            0x8A07: 'PidLidSharingInitiatorName',
            0x8A08: 'PidLidSharingInitiatorSmtp',
            0x8A09: 'PidLidSharingInitiatorEntryId',
            0x8A14: 'PidLidSharingLocalType',
            0x8A17: 'PidLidSharingCapabilities',
            0x8A18: 'PidLidSharingFlavor',
            0x8A1D: 'PidLidSharingRemoteType',
            0x8A24: 'PidLidSharingConfigurationUrl',
            0x8A27: 'PidLidSharingResponseType',
            0x8A28: 'PidLidSharingResponseTime',
            0x8A48: 'PidLidSharingRemoteStoreUid',
            0x8B00: 'PidLidNoteColor',
            0x8B02: 'PidLidNoteWidth',
            0x8B03: 'PidLidNoteHeight',
            0x8B04: 'PidLidNoteX',
            0x8B05: 'PidLidNoteY',
            0x8D00: 'PidLidResendTime',
            0x8F01: 'PidLidRemoteEntryId',
            0x8F02: 'PidLidRemoteMessageClass',
            0x8F03: 'PidLidRemoteTransport',
            0x8F04: 'PidLidRemoteTransferTime',
            0x8F05: 'PidLidRemoteTransferSize',
            0x8F06: 'PidLidRemoteSearchKey',
            0x8F07: 'PidLidRemoteAttachment',
            0xFFFE: 'PidTagEmsAbServer',
        }

        oParser = optparse.OptionParser()
        oParser.add_option('-n', '--nodecode', action='store_true', default=False, help='Do not decode data')
        oParser.add_option('-k', '--known', action='store_true', default=False, help='Only display known hexcodes')
        (options, args) = oParser.parse_args(self.options.split(' '))

        def GetCode(hexcode):
            if not hexcode in dCodes:
                return dPropertyIDs.get(int(hexcode, 16), '?')
            else:
                return dCodes[hexcode]

        def ParseData(propertyType, data):
            if propertyType == 0x0003:
                return '%d' % cStruct(data).Unpack('<I')
            elif propertyType == 0x000B:
                return '%d' % cStruct(data).Unpack('<I')
            elif propertyType == 0x0040:
                return FormatFiletime(cStruct(data).Unpack('<Q'))
            elif propertyType in (0x001F, 0x0102):
                return '%d 0x%08x' % cStruct(data).Unpack('<II')
            return ''

        def GetFlag(flag):
            if not flag in (0, 1, 2, 4, 3, 5, 6, 7):
                return '0x%04x' % flag
            result = ''
            if flag & 0x01:
                result += 'M'
            if flag & 0x02:
                result += 'R'
            if flag & 0x04:
                result += 'W'
            return '%5s' % result

        self.ran = True
        oMatch = re.search('_[0-9A-F]{8}', self.streamname[-1])
        if oMatch != None:
            hexcode = oMatch.group()[1:5]
            hextype = oMatch.group()[5:]
            if hextype == '001F':
                decoded = self.stream.decode('utf16')
            elif hextype == '0102':
                decoded = repr(self.stream)
            else:
                decoded = ''
            line = '%s %s: %s %s' % (hexcode, hextype, dTypes.get(hextype, '?  '), GetCode(hexcode))
            if options.nodecode:
                pass
            else:
                line = (line + ' ' * 40)[0:40] + ' ' + decoded[0:40]
            if not options.known or options.known and hexcode in dCodes:
                result.append(line)
        elif self.streamname[-1] == '__properties_version1.0':
            oStruct = cStruct(self.stream)
            if len(self.streamname) == 1:
                reserved1, nextRecipientID, nextAttachmentID, recipientCount, attachmentCount, reserved2 = oStruct.Unpack('<QIIIIQ')
                result.append('Reserved1 = %016x' % reserved1)
                result.append('Next Recipient ID = %d' % nextRecipientID)
                result.append('Next Attachment ID = %d' % nextAttachmentID)
                result.append('Recipient Count = %d' % recipientCount)
                result.append('Attachment Count = %d' % attachmentCount)
                result.append('Reserved2 = %016x' % reserved2)
            else:
                reserved = oStruct.Unpack('<Q')
                result.append('Reserved = %016x' % reserved)
            while oStruct.Length() > 0:
                propertyType, propertyID, flags = oStruct.Unpack('<HHI')
                data = oStruct.GetBytes(8)
                result.append('0x%04x 0x%04x %s %s %s: %s' % (propertyType, propertyID, GetFlag(flags), dPropertyTypes.get(propertyType, '?'), dPropertyIDs.get(propertyID, '?'), ParseData(propertyType, data)))
        return result

AddPlugin(cMSG)
