/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal;

import java.util.concurrent.atomic.AtomicInteger;
import javax.mail.MessagingException;
import javax.mail.Session;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.internal.authenticatedsockssupport.socks5server.AnonymousSocks5Server;
import org.simplejavamail.api.mailer.config.OperationalConfig;
import org.simplejavamail.mailer.internal.AbstractProxyServerSyncingClosure;
import org.simplejavamail.mailer.internal.MailerException;
import org.simplejavamail.mailer.internal.util.SessionLogger;
import org.simplejavamail.mailer.internal.util.TransportRunner;

class TestConnectionClosure
extends AbstractProxyServerSyncingClosure {
    @NotNull
    private final OperationalConfig operationalConfig;
    @NotNull
    private final Session session;
    private final boolean async;

    TestConnectionClosure(@NotNull OperationalConfig operationalConfig, @NotNull Session session, @Nullable AnonymousSocks5Server proxyServer, boolean async, @NotNull AtomicInteger smtpConnectionCounter) {
        super(smtpConnectionCounter, proxyServer);
        this.operationalConfig = operationalConfig;
        this.session = session;
        this.async = async;
    }

    @Override
    public void executeClosure() {
        LOGGER.debug("testing connection...");
        try {
            SessionLogger.logSession(this.session, this.async, "connection test");
            if (this.operationalConfig.getCustomMailer() != null) {
                this.operationalConfig.getCustomMailer().testConnection(this.operationalConfig, this.session);
            } else {
                TransportRunner.connect(this.operationalConfig.getClusterKey(), this.session);
            }
        }
        catch (MessagingException e2) {
            throw new MailerException("Was unable to connect to SMTP server", e2);
        }
        catch (Exception e3) {
            LOGGER.error("Failed to test connection email");
            throw e3;
        }
    }
}

