/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal;

import javax.net.ssl.SSLSocketFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.mailer.config.ServerConfig;
import org.simplejavamail.internal.util.MiscUtil;

class ServerConfigImpl
implements ServerConfig {
    @NotNull
    private final String host;
    @NotNull
    private final Integer port;
    @Nullable
    private final String username;
    @Nullable
    private final String password;
    @Nullable
    private final String customSSLFactoryClass;
    @Nullable
    private final SSLSocketFactory customSSLFactoryInstance;

    ServerConfigImpl(@NotNull String host, @NotNull Integer port, @Nullable String username, @Nullable String password, @Nullable String customSSLFactoryClass, @Nullable SSLSocketFactory customSSLFactoryInstance) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.customSSLFactoryClass = customSSLFactoryClass;
        this.customSSLFactoryInstance = customSSLFactoryInstance;
        if (MiscUtil.valueNullOrEmpty(this.username) && !MiscUtil.valueNullOrEmpty(this.password)) {
            throw new IllegalArgumentException("Password provided but not a username");
        }
    }

    public String toString() {
        String str = String.format("%s:%s", this.host, this.port);
        if (this.username != null) {
            str = str + String.format(", username: %s", this.username);
        }
        if (this.password != null) {
            str = str + " (authenticated)";
        }
        return str;
    }

    @Override
    @NotNull
    public String getHost() {
        return this.host;
    }

    @Override
    @NotNull
    public Integer getPort() {
        return this.port;
    }

    @Override
    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Override
    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Override
    @Nullable
    public String getCustomSSLFactoryClass() {
        return this.customSSLFactoryClass;
    }

    @Override
    @Nullable
    public SSLSocketFactory getCustomSSLFactoryInstance() {
        return this.customSSLFactoryInstance;
    }
}

