/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.hazlewood.connor.bottema.emailaddress.EmailAddressCriteria;
import org.hazlewood.connor.bottema.emailaddress.EmailAddressValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.MailException;
import org.simplejavamail.api.email.AttachmentResource;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.internal.modules.ModuleLoader;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.mailer.MailValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailerHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailerHelper.class);

    public static boolean validate(@NotNull Email email, @NotNull EnumSet<EmailAddressCriteria> emailAddressCriteria) throws MailException {
        LOGGER.debug("validating email...");
        if (email.getRecipients().size() == 0) {
            throw new MailValidationException("Email is not valid: missing recipients");
        }
        if (email.getFromRecipient() == null) {
            throw new MailValidationException("Email is not valid: missing sender. Provide with emailBuilder.from(...)");
        }
        if (email.isUseDispositionNotificationTo() && email.getDispositionNotificationTo() == null) {
            throw new MailValidationException("Email is not valid: it is set to use \"Disposition Notification To\", but the address is empty");
        }
        if (email.isUseReturnReceiptTo() && email.getReturnReceiptTo() == null) {
            throw new MailValidationException("Email is not valid: it is set to use \"Return Receipt To\", but the address is empty");
        }
        if (!emailAddressCriteria.isEmpty()) {
            if (!EmailAddressValidator.isValid(email.getFromRecipient().getAddress(), emailAddressCriteria)) {
                throw new MailValidationException(String.format("Invalid FROM address: %s", email));
            }
            for (Recipient recipient : email.getRecipients()) {
                if (EmailAddressValidator.isValid(recipient.getAddress(), emailAddressCriteria)) continue;
                throw new MailValidationException(String.format("Invalid TO address: %s", email));
            }
            if (email.getReplyToRecipient() != null && !EmailAddressValidator.isValid(email.getReplyToRecipient().getAddress(), emailAddressCriteria)) {
                throw new MailValidationException(String.format("Invalid REPLY TO address: %s", email));
            }
            if (email.getBounceToRecipient() != null && !EmailAddressValidator.isValid(email.getBounceToRecipient().getAddress(), emailAddressCriteria)) {
                throw new MailValidationException(String.format("Invalid BOUNCE TO address: %s", email));
            }
            if (email.isUseDispositionNotificationTo() && !EmailAddressValidator.isValid(Preconditions.checkNonEmptyArgument(email.getDispositionNotificationTo(), "dispositionNotificationTo").getAddress(), emailAddressCriteria)) {
                throw new MailValidationException(String.format("Invalid \"Disposition Notification To\" address: %s", email));
            }
            if (email.isUseReturnReceiptTo() && !EmailAddressValidator.isValid(Preconditions.checkNonEmptyArgument(email.getReturnReceiptTo(), "returnReceiptTo").getAddress(), emailAddressCriteria)) {
                throw new MailValidationException(String.format("Invalid \"Return Receipt To\" address: %s", email));
            }
        }
        MailerHelper.scanForInjectionAttack(email.getSubject(), "email.subject");
        for (Map.Entry entry : email.getHeaders().entrySet()) {
            for (String headerValue : (Collection)entry.getValue()) {
                MailerHelper.scanForInjectionAttack((String)entry.getKey(), "email.header.mapEntryKey");
                if (((String)entry.getKey()).equals("References")) {
                    MailerHelper.scanForInjectionAttack(MimeUtility.unfold(headerValue), "email.header.References");
                    continue;
                }
                MailerHelper.scanForInjectionAttack(headerValue, "email.header." + (String)entry.getKey());
            }
        }
        for (AttachmentResource attachmentResource : email.getAttachments()) {
            MailerHelper.scanForInjectionAttack(attachmentResource.getName(), "email.attachment.name");
            MailerHelper.scanForInjectionAttack(attachmentResource.getDataSource().getName(), "email.attachment.datasource.name");
        }
        for (AttachmentResource attachmentResource : email.getEmbeddedImages()) {
            MailerHelper.scanForInjectionAttack(attachmentResource.getName(), "email.embeddedImage.name");
            MailerHelper.scanForInjectionAttack(attachmentResource.getDataSource().getName(), "email.embeddedImage.datasource.name");
        }
        MailerHelper.scanForInjectionAttack(email.getFromRecipient().getName(), "email.fromRecipient.name");
        MailerHelper.scanForInjectionAttack(email.getFromRecipient().getAddress(), "email.fromRecipient.address");
        if (!MiscUtil.valueNullOrEmpty(email.getReplyToRecipient())) {
            MailerHelper.scanForInjectionAttack(email.getReplyToRecipient().getName(), "email.replyToRecipient.name");
            MailerHelper.scanForInjectionAttack(email.getReplyToRecipient().getAddress(), "email.replyToRecipient.address");
        }
        if (!MiscUtil.valueNullOrEmpty(email.getBounceToRecipient())) {
            MailerHelper.scanForInjectionAttack(email.getBounceToRecipient().getName(), "email.bounceToRecipient.name");
            MailerHelper.scanForInjectionAttack(email.getBounceToRecipient().getAddress(), "email.bounceToRecipient.address");
        }
        for (Recipient recipient : email.getRecipients()) {
            MailerHelper.scanForInjectionAttack(recipient.getName(), "email.recipient.name");
            MailerHelper.scanForInjectionAttack(recipient.getAddress(), "email.recipient.address");
        }
        LOGGER.debug("...no problems found");
        return true;
    }

    private static void scanForInjectionAttack(@Nullable String value, String valueLabel) {
        if (value != null && (value.contains("\n") || value.contains("\r") || value.contains("%0A"))) {
            throw new MailValidationException(String.format("Suspected of injection attack, field: %s with suspicious value: %s", valueLabel, value));
        }
    }

    public static MimeMessage signMessageWithDKIM(@NotNull MimeMessage messageToSign, @NotNull Email emailContainingSigningDetails) {
        return ModuleLoader.loadDKIMModule().signMessageWithDKIM(messageToSign, emailContainingSigningDetails);
    }

    public static MimeMessage signAndOrEncryptMessageWithSmime(@NotNull Session session, @NotNull MimeMessage messageToProtect, @NotNull Email emailContainingSmimeDetails) {
        return ModuleLoader.loadSmimeModule().signAndOrEncryptEmail(session, messageToProtect, emailContainingSmimeDetails);
    }
}

