/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.MailException;
import org.simplejavamail.internal.util.MiscUtil;

public class CertificationUtil {
    private static final String BOUNCY_CASTLE_PROVIDER_CLASS = "org.bouncycastle.jce.provider.BouncyCastleProvider";

    public static X509Certificate readFromPem(File pemFile) throws CertificateException, NoSuchProviderException, FileNotFoundException {
        return CertificationUtil.readFromPem(new FileInputStream(pemFile));
    }

    public static X509Certificate readFromPem(InputStream pemData) throws CertificateException, NoSuchProviderException {
        if (MiscUtil.classAvailable(BOUNCY_CASTLE_PROVIDER_CLASS)) {
            try {
                Class<Provider> bouncyCastleClass = Class.forName(BOUNCY_CASTLE_PROVIDER_CLASS);
                Security.addProvider(CertificationUtil.getProvider(bouncyCastleClass));
            }
            catch (ClassNotFoundException e2) {
                throw new IllegalStateException(String.format("Class found but also not found??? (%s)", BOUNCY_CASTLE_PROVIDER_CLASS));
            }
        } else {
            throw new SmimeSupportMissingException();
        }
        return (X509Certificate)CertificateFactory.getInstance("X.509", "BC").generateCertificate(pemData);
    }

    @NotNull
    private static Provider getProvider(Class<Provider> bouncyCastleClass) {
        try {
            return bouncyCastleClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (SecurityException e2) {
            throw new RuntimeException("unable to invoke parameterless constructor; security problem", e2);
        }
        catch (InstantiationException e3) {
            throw new RuntimeException("unable to complete instantiation of object", e3);
        }
        catch (IllegalAccessException e4) {
            throw new RuntimeException("unable to access parameterless constructor", e4);
        }
        catch (InvocationTargetException e5) {
            throw new RuntimeException("unable to invoke parameterless constructor", e5);
        }
        catch (NoSuchMethodException e6) {
            throw new RuntimeException("unable to find parameterless constructor (not public?)", e6);
        }
    }

    private static class SmimeSupportMissingException
    extends MailException {
        SmimeSupportMissingException() {
            super("Can't read x509 certificate from PEM file (missing BouncyCastle Provider). Is the S/MIME module on the class path?");
        }
    }
}

