/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.email.internal;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.EmailPopulatingBuilder;
import org.simplejavamail.api.email.EmailStartingBuilder;
import org.simplejavamail.converter.EmailConverter;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageParser;
import org.simplejavamail.email.internal.EmailException;
import org.simplejavamail.email.internal.EmailPopulatingBuilderImpl;
import org.simplejavamail.email.internal.InternalEmailPopulatingBuilder;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;

public final class EmailStartingBuilderImpl
implements EmailStartingBuilder {
    private boolean applyDefaults = true;

    @Deprecated
    public EmailStartingBuilderImpl() {
    }

    @Override
    public EmailStartingBuilder ignoringDefaults() {
        this.applyDefaults = false;
        return this;
    }

    @Override
    public EmailPopulatingBuilder startingBlank() {
        return new EmailPopulatingBuilderImpl(this.applyDefaults);
    }

    @Override
    public EmailPopulatingBuilder replyingTo(@NotNull Email email) {
        return this.replyingTo(EmailConverter.emailToMimeMessage(email), false, "<blockquote style=\"color: gray; border-left: 1px solid #4f4f4f; padding-left: 1cm\">%s</blockquote>");
    }

    @Override
    public EmailPopulatingBuilder replyingToAll(@NotNull Email email) {
        return this.replyingTo(EmailConverter.emailToMimeMessage(email), true, "<blockquote style=\"color: gray; border-left: 1px solid #4f4f4f; padding-left: 1cm\">%s</blockquote>");
    }

    @Override
    public EmailPopulatingBuilder replyingToAll(@NotNull Email email, @NotNull String customQuotingTemplate) {
        return this.replyingTo(EmailConverter.emailToMimeMessage(email), true, customQuotingTemplate);
    }

    @Override
    public EmailPopulatingBuilder replyingTo(@NotNull Email email, @NotNull String customQuotingTemplate) {
        return this.replyingTo(EmailConverter.emailToMimeMessage(email), false, customQuotingTemplate);
    }

    @Override
    public EmailPopulatingBuilder replyingTo(@NotNull MimeMessage message) {
        return this.replyingTo(message, false, "<blockquote style=\"color: gray; border-left: 1px solid #4f4f4f; padding-left: 1cm\">%s</blockquote>");
    }

    @Override
    public EmailPopulatingBuilder replyingTo(@NotNull MimeMessage message, @NotNull String customQuotingTemplate) {
        return this.replyingTo(message, false, customQuotingTemplate);
    }

    @Override
    public EmailPopulatingBuilder replyingToAll(@NotNull MimeMessage message, @NotNull String customQuotingTemplate) {
        return this.replyingTo(message, true, customQuotingTemplate);
    }

    @Override
    public EmailPopulatingBuilder replyingToAll(@NotNull MimeMessage message) {
        return this.replyingTo(message, true, "<blockquote style=\"color: gray; border-left: 1px solid #4f4f4f; padding-left: 1cm\">%s</blockquote>");
    }

    @Override
    public EmailPopulatingBuilder replyingTo(@NotNull MimeMessage emailMessage, boolean repyToAll, @NotNull String htmlTemplate) {
        MimeMessage replyMessage;
        try {
            replyMessage = (MimeMessage)emailMessage.reply(repyToAll);
            replyMessage.setText("ignore");
            replyMessage.setFrom("ignore@ignore.ignore");
        }
        catch (MessagingException e2) {
            throw new EmailException("was unable to parse mimemessage to produce a reply for", e2);
        }
        Email repliedTo = EmailConverter.mimeMessageToEmail(emailMessage);
        Email generatedReply = EmailConverter.mimeMessageToEmail(replyMessage);
        return this.startingBlank().withSubject(generatedReply.getSubject()).to(generatedReply.getRecipients()).withPlainText(EmailStartingBuilder.LINE_START_PATTERN.matcher(MiscUtil.defaultTo(repliedTo.getPlainText(), "")).replaceAll("> ")).withHTMLText(String.format(htmlTemplate, MiscUtil.defaultTo(repliedTo.getHTMLText(), ""))).withHeaders(generatedReply.getHeaders()).withEmbeddedImages(repliedTo.getEmbeddedImages());
    }

    @Override
    public EmailPopulatingBuilder forwarding(@NotNull Email email) {
        return this.forwarding(EmailConverter.emailToMimeMessage(email));
    }

    @Override
    public EmailPopulatingBuilder forwarding(@NotNull MimeMessage message) {
        return ((InternalEmailPopulatingBuilder)this.startingBlank()).withForward(message).withSubject("Fwd: " + MimeMessageParser.parseSubject(message));
    }

    @Override
    public EmailPopulatingBuilder copying(@NotNull MimeMessage message) {
        return this.copying(EmailConverter.mimeMessageToEmail(message));
    }

    @Override
    public EmailPopulatingBuilder copying(@NotNull EmailPopulatingBuilder emailBuilder) {
        return this.copying(emailBuilder.buildEmail());
    }

    @Override
    public EmailPopulatingBuilder copying(@NotNull Email email) {
        EmailPopulatingBuilderImpl builder = new EmailPopulatingBuilderImpl(this.applyDefaults);
        if (email.getId() != null) {
            builder.fixingMessageId(email.getId());
        }
        if (email.getFromRecipient() != null) {
            builder.from(email.getFromRecipient());
        }
        if (email.getReplyToRecipient() != null) {
            builder.withReplyTo(email.getReplyToRecipient());
        }
        if (email.getBounceToRecipient() != null) {
            builder.withBounceTo(email.getBounceToRecipient());
        }
        if (email.getPlainText() != null) {
            builder.withPlainText(email.getPlainText());
        }
        if (email.getHTMLText() != null) {
            builder.withHTMLText(email.getHTMLText());
        }
        if (email.getSubject() != null) {
            builder.withSubject(email.getSubject());
        }
        builder.withRecipients(email.getRecipients());
        builder.withEmbeddedImages(email.getEmbeddedImages());
        builder.withAttachments(email.getAttachments());
        ((InternalEmailPopulatingBuilder)builder).withHeaders(email.getHeaders(), true);
        if (email.getSentDate() != null) {
            builder.fixingSentDate(email.getSentDate());
        }
        if (email.getDkimPrivateKeyData() != null) {
            builder.signWithDomainKey(email.getDkimPrivateKeyData(), Preconditions.assumeNonNull(email.getDkimSigningDomain()), Preconditions.assumeNonNull(email.getDkimSelector()));
        }
        if (email.getDispositionNotificationTo() != null) {
            builder.withDispositionNotificationTo(email.getDispositionNotificationTo());
        }
        if (email.getReturnReceiptTo() != null) {
            builder.withReturnReceiptTo(email.getReturnReceiptTo());
        }
        if (email.getCalendarMethod() != null) {
            builder.withCalendarText(email.getCalendarMethod(), email.getCalendarText());
        }
        if (email.getEmailToForward() != null) {
            ((InternalEmailPopulatingBuilder)builder).withForward(email.getEmailToForward());
        }
        ((InternalEmailPopulatingBuilder)builder).withDecryptedAttachments(email.getDecryptedAttachments());
        if (email.getSmimeSignedEmail() != null) {
            ((InternalEmailPopulatingBuilder)builder).withSmimeSignedEmail(email.getSmimeSignedEmail());
        }
        ((InternalEmailPopulatingBuilder)builder).withOriginalSmimeDetails(email.getOriginalSmimeDetails());
        if (!email.wasMergedWithSmimeSignedMessage()) {
            builder.notMergingSingleSMIMESignedAttachment();
        }
        return builder;
    }
}

