/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.email;

import java.io.Serializable;
import java.util.Objects;
import javax.mail.Message;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.internal.util.Preconditions;

public final class Recipient
implements Serializable {
    private static final long serialVersionUID = 1234567L;
    @Nullable
    private final String name;
    @NotNull
    private final String address;
    @Nullable
    private final Message.RecipientType type;

    public Recipient(@Nullable String name, @NotNull String address, @Nullable Message.RecipientType type) {
        this.name = name;
        this.address = Preconditions.checkNonEmptyArgument(address, "address");
        this.type = type;
    }

    public boolean equals(@Nullable Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Recipient recipient = (Recipient)o2;
        return Objects.equals(this.name, recipient.name) && Objects.equals(this.address, recipient.address) && Objects.equals(this.type, recipient.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.address, this.type);
    }

    @NotNull
    public String toString() {
        return "Recipient{name='" + this.name + '\'' + ", address='" + this.address + '\'' + ", type=" + this.type + '}';
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getAddress() {
        return this.address;
    }

    @Nullable
    public Message.RecipientType getType() {
        return this.type;
    }
}

