/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class CircularLossyQueue<T> {
    private final AtomicReference<T>[] circularArray;
    private final int maxSize;
    private final AtomicLong currentIndex = new AtomicLong(-1L);

    public CircularLossyQueue(int size) {
        this.circularArray = new AtomicReference[size];
        for (int i2 = 0; i2 < size; ++i2) {
            this.circularArray[i2] = new AtomicReference();
        }
        this.maxSize = size;
    }

    public void push(T newVal) {
        int index = (int)(this.currentIndex.incrementAndGet() % (long)this.maxSize);
        this.circularArray[index].set(newVal);
    }

    public T[] toArray(T[] type) {
        System.getProperties();
        if (type.length > this.maxSize) {
            throw new IllegalArgumentException("Size of array passed in cannot be greater than " + this.maxSize);
        }
        int curIndex = this.getCurrentIndex();
        for (int k2 = 0; k2 < type.length; ++k2) {
            int index = this.getIndex(curIndex - k2);
            type[k2] = this.circularArray[index].get();
        }
        return type;
    }

    private int getIndex(int index) {
        return index < 0 ? index + this.maxSize : index;
    }

    public T peek() {
        if (this.depth() == 0) {
            return null;
        }
        return this.circularArray[this.getIndex(this.getCurrentIndex())].get();
    }

    public boolean isEmtpy() {
        return this.depth() == 0;
    }

    private int getCurrentIndex() {
        return (int)(this.currentIndex.get() % (long)this.maxSize);
    }

    public int depth() {
        long currInd = this.currentIndex.get() + 1L;
        return currInd >= (long)this.maxSize ? this.maxSize : (int)currInd;
    }
}

