/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.text.ParseException;
import java.util.TimeZone;
import org.quartz.CronExpression;
import org.quartz.CronTrigger;
import org.quartz.DateBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.MutableTrigger;

public class CronScheduleBuilder
extends ScheduleBuilder<CronTrigger> {
    private CronExpression cronExpression;
    private int misfireInstruction = 0;

    protected CronScheduleBuilder(CronExpression cronExpression) {
        if (cronExpression == null) {
            throw new NullPointerException("cronExpression cannot be null");
        }
        this.cronExpression = cronExpression;
    }

    @Override
    public MutableTrigger build() {
        CronTriggerImpl ct2 = new CronTriggerImpl();
        ct2.setCronExpression(this.cronExpression);
        ct2.setTimeZone(this.cronExpression.getTimeZone());
        ct2.setMisfireInstruction(this.misfireInstruction);
        return ct2;
    }

    public static CronScheduleBuilder cronSchedule(String cronExpression) {
        try {
            return CronScheduleBuilder.cronSchedule(new CronExpression(cronExpression));
        }
        catch (ParseException e2) {
            throw new RuntimeException("CronExpression '" + cronExpression + "' is invalid.", e2);
        }
    }

    public static CronScheduleBuilder cronScheduleNonvalidatedExpression(String cronExpression) throws ParseException {
        return CronScheduleBuilder.cronSchedule(new CronExpression(cronExpression));
    }

    private static CronScheduleBuilder cronScheduleNoParseException(String presumedValidCronExpression) {
        try {
            return CronScheduleBuilder.cronSchedule(new CronExpression(presumedValidCronExpression));
        }
        catch (ParseException e2) {
            throw new RuntimeException("CronExpression '" + presumedValidCronExpression + "' is invalid, which should not be possible, please report bug to Quartz developers.", e2);
        }
    }

    public static CronScheduleBuilder cronSchedule(CronExpression cronExpression) {
        return new CronScheduleBuilder(cronExpression);
    }

    public static CronScheduleBuilder dailyAtHourAndMinute(int hour, int minute) {
        DateBuilder.validateHour(hour);
        DateBuilder.validateMinute(minute);
        String cronExpression = String.format("0 %d %d ? * *", minute, hour);
        return CronScheduleBuilder.cronScheduleNoParseException(cronExpression);
    }

    public static CronScheduleBuilder atHourAndMinuteOnGivenDaysOfWeek(int hour, int minute, Integer ... daysOfWeek) {
        if (daysOfWeek == null || daysOfWeek.length == 0) {
            throw new IllegalArgumentException("You must specify at least one day of week.");
        }
        Integer[] arr$ = daysOfWeek;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int dayOfWeek = arr$[i$];
            DateBuilder.validateDayOfWeek(dayOfWeek);
        }
        DateBuilder.validateHour(hour);
        DateBuilder.validateMinute(minute);
        String cronExpression = String.format("0 %d %d ? * %d", minute, hour, daysOfWeek[0]);
        for (int i2 = 1; i2 < daysOfWeek.length; ++i2) {
            cronExpression = cronExpression + "," + daysOfWeek[i2];
        }
        return CronScheduleBuilder.cronScheduleNoParseException(cronExpression);
    }

    public static CronScheduleBuilder weeklyOnDayAndHourAndMinute(int dayOfWeek, int hour, int minute) {
        DateBuilder.validateDayOfWeek(dayOfWeek);
        DateBuilder.validateHour(hour);
        DateBuilder.validateMinute(minute);
        String cronExpression = String.format("0 %d %d ? * %d", minute, hour, dayOfWeek);
        return CronScheduleBuilder.cronScheduleNoParseException(cronExpression);
    }

    public static CronScheduleBuilder monthlyOnDayAndHourAndMinute(int dayOfMonth, int hour, int minute) {
        DateBuilder.validateDayOfMonth(dayOfMonth);
        DateBuilder.validateHour(hour);
        DateBuilder.validateMinute(minute);
        String cronExpression = String.format("0 %d %d %d * ?", minute, hour, dayOfMonth);
        return CronScheduleBuilder.cronScheduleNoParseException(cronExpression);
    }

    public CronScheduleBuilder inTimeZone(TimeZone timezone) {
        this.cronExpression.setTimeZone(timezone);
        return this;
    }

    public CronScheduleBuilder withMisfireHandlingInstructionIgnoreMisfires() {
        this.misfireInstruction = -1;
        return this;
    }

    public CronScheduleBuilder withMisfireHandlingInstructionDoNothing() {
        this.misfireInstruction = 2;
        return this;
    }

    public CronScheduleBuilder withMisfireHandlingInstructionFireAndProceed() {
        this.misfireInstruction = 1;
        return this;
    }
}

