/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class Dot11BssMembershipSelector
extends NamedNumber<Byte, Dot11BssMembershipSelector> {
    private static final long serialVersionUID = -8967573178793261461L;
    public static final Dot11BssMembershipSelector HT_PHY = new Dot11BssMembershipSelector((byte)127, "HT PHY");
    private static final Map<Byte, Dot11BssMembershipSelector> registry = new HashMap<Byte, Dot11BssMembershipSelector>();

    public Dot11BssMembershipSelector(Byte value, String name) {
        super(value, name);
        if (value < 0) {
            throw new IllegalArgumentException("The value must be between 0 to 127 but actually is: " + value);
        }
    }

    public static Dot11BssMembershipSelector getInstance(Byte value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new Dot11BssMembershipSelector(value, "unknown");
    }

    public static boolean isRegistered(Byte value) {
        return registry.containsKey(value);
    }

    public static Dot11BssMembershipSelector register(Dot11BssMembershipSelector number) {
        return registry.put((Byte)number.value(), number);
    }

    @Override
    public int compareTo(Dot11BssMembershipSelector o2) {
        return ((Byte)this.value()).compareTo((Byte)o2.value());
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Byte)this.value() & 0xFF);
    }

    static {
        registry.put((Byte)HT_PHY.value(), HT_PHY);
    }
}

