/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.util.ByteArrays;

public final class UnknownRadiotapData
implements RadiotapPacket.RadiotapData {
    private static final long serialVersionUID = 6405498375843386046L;
    private final byte[] rawData;

    public static UnknownRadiotapData newInstance(byte[] rawData, int offset, int length) {
        ByteArrays.validateBounds(rawData, offset, length);
        return new UnknownRadiotapData(rawData, offset, length);
    }

    private UnknownRadiotapData(byte[] rawData, int offset, int length) {
        this.rawData = ByteArrays.getSubArray(rawData, offset, length);
    }

    private UnknownRadiotapData(Builder builder) {
        if (builder == null || builder.rawData == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.rawData: ").append(builder.rawData);
            throw new NullPointerException(sb.toString());
        }
        this.rawData = ByteArrays.clone(builder.rawData);
    }

    @Override
    public int length() {
        return this.rawData.length;
    }

    @Override
    public byte[] getRawData() {
        return ByteArrays.clone(this.rawData);
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls2 = System.getProperty("line.separator");
        sb.append(indent).append("Unknown Data: ").append(ls2).append(indent).append("  data: ").append(ByteArrays.toHexString(this.rawData, "")).append(ls2);
        return sb.toString();
    }

    public int hashCode() {
        return Arrays.hashCode(this.rawData);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        UnknownRadiotapData other = (UnknownRadiotapData)obj;
        return Arrays.equals(this.rawData, other.rawData);
    }

    public static final class Builder {
        private byte[] rawData;

        public Builder() {
        }

        private Builder(UnknownRadiotapData obj) {
            this.rawData = obj.rawData;
        }

        public Builder rawData(byte[] rawData) {
            this.rawData = rawData;
            return this;
        }

        public UnknownRadiotapData build() {
            return new UnknownRadiotapData(this);
        }
    }
}

