/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.Ssh2BinaryPacket;
import org.pcap4j.packet.Ssh2VersionExchangePacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SshPacket
extends AbstractPacket {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SshPacket.class);

    public static Packet newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        try {
            return Ssh2VersionExchangePacket.newPacket(rawData, offset, length);
        }
        catch (IllegalRawDataException e2) {
            logger.debug("rawData seems not SSH2 version exchange packet.", e2);
            return Ssh2BinaryPacket.newPacket(rawData, offset, length);
        }
    }

    private SshPacket() {
        throw new AssertionError();
    }

    @Override
    public Packet.Builder getBuilder() {
        throw new UnsupportedOperationException();
    }
}

