/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.util.ByteArrays;

abstract class SimplePacket
extends AbstractPacket {
    private static final long serialVersionUID = -1565433651791063490L;
    private final byte[] rawData;

    protected SimplePacket(byte[] rawData, int offset, int length) {
        this.rawData = new byte[length];
        System.arraycopy(rawData, offset, this.rawData, 0, length);
    }

    protected SimplePacket(Builder builder) {
        if (builder == null || builder.rawData == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.rawData: ").append(builder.rawData);
            throw new NullPointerException(sb.toString());
        }
        this.rawData = new byte[builder.rawData.length];
        System.arraycopy(builder.rawData, 0, this.rawData, 0, builder.rawData.length);
    }

    @Override
    public int length() {
        return this.rawData.length;
    }

    @Override
    public byte[] getRawData() {
        byte[] copy = new byte[this.rawData.length];
        System.arraycopy(this.rawData, 0, copy, 0, copy.length);
        return copy;
    }

    @Override
    protected String buildString() {
        StringBuilder sb = new StringBuilder();
        String ls2 = System.getProperty("line.separator");
        sb.append("[").append(this.modifier()).append("data (").append(this.length()).append(" bytes)]").append(ls2);
        sb.append("  Hex stream: ").append(ByteArrays.toHexString(this.rawData, " ")).append(ls2);
        return sb.toString();
    }

    protected abstract String modifier();

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        SimplePacket other = (SimplePacket)obj;
        return Arrays.equals(this.rawData, other.rawData);
    }

    @Override
    protected int calcHashCode() {
        return Arrays.hashCode(this.rawData);
    }

    public static abstract class Builder
    extends AbstractPacket.AbstractBuilder {
        private byte[] rawData;

        public Builder() {
        }

        protected Builder(SimplePacket packet) {
            this.rawData = packet.rawData;
        }

        protected void setRawData(byte[] rawData) {
            this.rawData = rawData;
        }
    }
}

