/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.nio.ByteOrder;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.util.ByteArrays;

public final class RadiotapDataLockQuality
implements RadiotapPacket.RadiotapData {
    private static final long serialVersionUID = -7889325752343077807L;
    private static final int LENGTH = 2;
    private final short lockQuality;

    public static RadiotapDataLockQuality newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new RadiotapDataLockQuality(rawData, offset, length);
    }

    private RadiotapDataLockQuality(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 2) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a RadiotapLockQuality (").append(2).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.lockQuality = ByteArrays.getShort(rawData, offset, ByteOrder.LITTLE_ENDIAN);
    }

    private RadiotapDataLockQuality(Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is null.");
        }
        this.lockQuality = builder.lockQuality;
    }

    public short getLockQuality() {
        return this.lockQuality;
    }

    public int getLockQualityAsInt() {
        return this.lockQuality & 0xFFFF;
    }

    @Override
    public int length() {
        return 2;
    }

    @Override
    public byte[] getRawData() {
        return ByteArrays.toByteArray(this.lockQuality, ByteOrder.LITTLE_ENDIAN);
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls2 = System.getProperty("line.separator");
        sb.append(indent).append("Lock quality: ").append(ls2).append(indent).append("  Lock quality: ").append(this.getLockQualityAsInt()).append(ls2);
        return sb.toString();
    }

    public int hashCode() {
        return this.lockQuality;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        RadiotapDataLockQuality other = (RadiotapDataLockQuality)obj;
        return this.lockQuality == other.lockQuality;
    }

    public static final class Builder {
        private short lockQuality;

        public Builder() {
        }

        private Builder(RadiotapDataLockQuality obj) {
            this.lockQuality = obj.lockQuality;
        }

        public Builder lockQuality(short lockQuality) {
            this.lockQuality = lockQuality;
            return this;
        }

        public RadiotapDataLockQuality build() {
            return new RadiotapDataLockQuality(this);
        }
    }
}

