/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IcmpV6InvokingPacketPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.util.ByteArrays;

public final class IcmpV6ParameterProblemPacket
extends IcmpV6InvokingPacketPacket {
    private static final long serialVersionUID = -7613453030792043352L;
    private final IcmpV6ParameterProblemHeader header;

    public static IcmpV6ParameterProblemPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        IcmpV6ParameterProblemHeader header = new IcmpV6ParameterProblemHeader(rawData, offset, length);
        int payloadLength = length - header.length();
        if (payloadLength > 0) {
            return new IcmpV6ParameterProblemPacket(header, rawData, offset + header.length(), payloadLength);
        }
        return new IcmpV6ParameterProblemPacket(header);
    }

    private IcmpV6ParameterProblemPacket(IcmpV6ParameterProblemHeader header) {
        this.header = header;
    }

    private IcmpV6ParameterProblemPacket(IcmpV6ParameterProblemHeader header, byte[] rawData, int payloadOffset, int payloadLength) {
        super(rawData, payloadOffset, payloadLength);
        this.header = header;
    }

    private IcmpV6ParameterProblemPacket(Builder builder) {
        super(builder);
        this.header = new IcmpV6ParameterProblemHeader(builder);
    }

    @Override
    public IcmpV6ParameterProblemHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IcmpV6ParameterProblemHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -3743068221589212767L;
        private static final int POINTER_OFFSET = 0;
        private static final int POINTER_SIZE = 4;
        private static final int ICMPV6_PARAMETER_PROBLEM_HEADER_SIZE = 4;
        private final int pointer;

        private IcmpV6ParameterProblemHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 4) {
                StringBuilder sb = new StringBuilder(80);
                sb.append("The data is too short to build an ICMPv6 Parameter Problem Header(").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.pointer = ByteArrays.getInt(rawData, 0 + offset);
        }

        private IcmpV6ParameterProblemHeader(Builder builder) {
            this.pointer = builder.pointer;
        }

        public int getPointer() {
            return this.pointer;
        }

        public long getPointerAsLong() {
            return (long)this.pointer & 0xFFFFFFFFL;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(this.pointer));
            return rawFields;
        }

        @Override
        public int length() {
            return 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls2 = System.getProperty("line.separator");
            sb.append("[ICMPv6 Parameter Problem Header (").append(this.length()).append(" bytes)]").append(ls2);
            sb.append("  Pointer: ").append(this.pointer).append(ls2);
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            IcmpV6ParameterProblemHeader other = (IcmpV6ParameterProblemHeader)obj;
            return this.pointer == other.pointer;
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.pointer;
            return result;
        }
    }

    public static final class Builder
    extends IcmpV6InvokingPacketPacket.Builder {
        private int pointer;

        public Builder() {
        }

        private Builder(IcmpV6ParameterProblemPacket packet) {
            super(packet);
            this.pointer = packet.getHeader().pointer;
        }

        public Builder pointer(int pointer) {
            this.pointer = pointer;
            return this;
        }

        @Override
        public Builder payload(Packet payload) {
            super.payload(payload);
            return this;
        }

        @Override
        public IcmpV6ParameterProblemPacket build() {
            return new IcmpV6ParameterProblemPacket(this);
        }
    }
}

