/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IcmpV4InvokingPacketPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.util.ByteArrays;

public final class IcmpV4SourceQuenchPacket
extends IcmpV4InvokingPacketPacket {
    private static final long serialVersionUID = 5977981249980504735L;
    private final IcmpV4SourceQuenchHeader header;

    public static IcmpV4SourceQuenchPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        IcmpV4SourceQuenchHeader header = new IcmpV4SourceQuenchHeader(rawData, offset, length);
        int payloadLength = length - header.length();
        if (payloadLength > 0) {
            return new IcmpV4SourceQuenchPacket(header, rawData, offset + header.length(), payloadLength);
        }
        return new IcmpV4SourceQuenchPacket(header);
    }

    private IcmpV4SourceQuenchPacket(IcmpV4SourceQuenchHeader header) {
        this.header = header;
    }

    private IcmpV4SourceQuenchPacket(IcmpV4SourceQuenchHeader header, byte[] rawData, int payloadOffset, int payloadLength) {
        super(rawData, payloadOffset, payloadLength);
        this.header = header;
    }

    private IcmpV4SourceQuenchPacket(Builder builder) {
        super(builder);
        this.header = new IcmpV4SourceQuenchHeader(builder);
    }

    @Override
    public IcmpV4SourceQuenchHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IcmpV4SourceQuenchHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -3569475573220386469L;
        private static final int UNUSED_OFFSET = 0;
        private static final int UNUSED_SIZE = 4;
        private static final int ICMPV4_SOURCE_QUENCH_HEADER_SIZE = 4;
        private final int unused;

        private IcmpV4SourceQuenchHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 4) {
                StringBuilder sb = new StringBuilder(80);
                sb.append("The data is too short to build an ICMPv4 Source Quench Header(").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.unused = ByteArrays.getInt(rawData, 0 + offset);
        }

        private IcmpV4SourceQuenchHeader(Builder builder) {
            this.unused = builder.unused;
        }

        public int getUnused() {
            return this.unused;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(this.unused));
            return rawFields;
        }

        @Override
        public int length() {
            return 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls2 = System.getProperty("line.separator");
            sb.append("[ICMPv4 Source Quench Header (").append(this.length()).append(" bytes)]").append(ls2);
            sb.append("  Unused: ").append(this.unused).append(ls2);
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            IcmpV4SourceQuenchHeader other = (IcmpV4SourceQuenchHeader)obj;
            return this.unused == other.unused;
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.unused;
            return result;
        }
    }

    public static final class Builder
    extends IcmpV4InvokingPacketPacket.Builder {
        private int unused;

        public Builder() {
        }

        private Builder(IcmpV4SourceQuenchPacket packet) {
            super(packet);
            this.unused = packet.getHeader().unused;
        }

        public Builder unused(int unused) {
            this.unused = unused;
            return this;
        }

        @Override
        public Builder payload(Packet payload) {
            super.payload(payload);
            return this;
        }

        @Override
        public IcmpV4SourceQuenchPacket build() {
            return new IcmpV4SourceQuenchPacket(this);
        }
    }
}

