/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.DnsResourceRecord;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public final class DnsRDataTxt
implements DnsResourceRecord.DnsRData {
    private static final long serialVersionUID = 469382715852386597L;
    private final List<String> texts;

    public static DnsRDataTxt newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new DnsRDataTxt(rawData, offset, length);
    }

    private DnsRDataTxt(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        int txtLen;
        this.texts = new ArrayList<String>();
        for (int cursor = 0; cursor < length; cursor += txtLen) {
            txtLen = rawData[offset + cursor] & 0xFF;
            if (txtLen > length - ++cursor) {
                StringBuilder sb = new StringBuilder(200);
                sb.append("The data is too short to build a txt in DnsRDataTxt. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length).append(", cursor: ").append(cursor);
                throw new IllegalRawDataException(sb.toString());
            }
            this.texts.add(new String(rawData, offset + cursor, txtLen));
        }
    }

    private DnsRDataTxt(Builder builder) {
        if (builder == null || builder.texts == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.texts: ").append(builder.texts);
            throw new NullPointerException(sb.toString());
        }
        for (String text : builder.texts) {
            if (text.getBytes().length <= 255) continue;
            throw new IllegalArgumentException("Length of a text must be less than 256. text: " + text);
        }
        this.texts = new ArrayList<String>(builder.texts);
    }

    public List<String> getTexts() {
        return new ArrayList<String>(this.texts);
    }

    @Override
    public int length() {
        int len = 0;
        for (String text : this.texts) {
            len += text.getBytes().length + 1;
        }
        return len;
    }

    @Override
    public byte[] getRawData() {
        ArrayList<byte[]> rawTexts = new ArrayList<byte[]>();
        int len = 0;
        for (String text : this.texts) {
            byte[] rawText = text.getBytes();
            rawTexts.add(rawText);
            len += rawText.length + 1;
        }
        byte[] data = new byte[len];
        int cursor = 0;
        for (byte[] rawText : rawTexts) {
            data[cursor] = (byte)rawText.length;
            System.arraycopy(rawText, 0, data, ++cursor, rawText.length);
            cursor += rawText.length;
        }
        return data;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.convertToString("", null);
    }

    @Override
    public String toString(String indent) {
        return this.convertToString(indent, null);
    }

    @Override
    public String toString(String indent, byte[] headerRawData) {
        if (headerRawData == null) {
            throw new NullPointerException("headerRawData is null.");
        }
        return this.convertToString(indent, headerRawData);
    }

    private String convertToString(String indent, byte[] headerRawData) {
        StringBuilder sb = new StringBuilder();
        String ls2 = System.getProperty("line.separator");
        sb.append(indent).append("TXT RDATA:").append(ls2);
        for (String text : this.texts) {
            sb.append(indent).append("  TEXT: ").append(text).append(ls2);
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.texts.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DnsRDataTxt other = (DnsRDataTxt)obj;
        return this.texts.equals(other.texts);
    }

    public static final class Builder {
        private List<String> texts;

        public Builder() {
        }

        private Builder(DnsRDataTxt obj) {
            this.texts = obj.texts;
        }

        public Builder texts(List<String> texts) {
            this.texts = texts;
            return this;
        }

        public DnsRDataTxt build() {
            return new DnsRDataTxt(this);
        }
    }
}

