/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.DnsResourceRecord;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public final class DnsRDataCaa
implements DnsResourceRecord.DnsRData {
    private static final int CAA_RR_MIN_LEN = 2;
    private static final long serialVersionUID = -1015182073420031158L;
    private final boolean critical;
    private final byte reservedFlags;
    private final String tag;
    private final String value;

    public static DnsRDataCaa newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new DnsRDataCaa(rawData, offset, length);
    }

    private DnsRDataCaa(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        int tagLen;
        if (length < 2) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a DnsRDataCaa (Min: ").append(2).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.critical = (rawData[offset] & 0x80) != 0;
        this.reservedFlags = (byte)(rawData[offset] & 0x7F);
        int cursor = 1;
        if (length < ++cursor + (tagLen = rawData[offset + cursor] & 0xFF)) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a DnsRDataCaa (Tag Length: ").append(tagLen).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.tag = new String(rawData, offset + cursor, tagLen);
        this.value = new String(rawData, offset + (cursor += tagLen), length - cursor);
    }

    private DnsRDataCaa(Builder builder) {
        if (builder.tag == null || builder.value == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(" builder.tag: ").append(builder.tag).append(" builder.value: ").append(builder.value);
            throw new NullPointerException(sb.toString());
        }
        if ((builder.reservedFlags & 0x80) != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("(builder.reservedFlags & 0x80) must be zero. builder.reservedFlags: ").append(builder.reservedFlags);
            throw new IllegalArgumentException(sb.toString());
        }
        if (builder.tag.getBytes().length > 255) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder.tag.getBytes().length must be less than 256. builder.tag: ").append(builder.tag);
            throw new IllegalArgumentException(sb.toString());
        }
        this.critical = builder.critical;
        this.reservedFlags = builder.reservedFlags;
        this.tag = builder.tag;
        this.value = builder.value;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public byte getReservedFlags() {
        return this.reservedFlags;
    }

    public String getTag() {
        return this.tag;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public int length() {
        return 2 + this.tag.getBytes().length + this.value.getBytes().length;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = this.reservedFlags;
        if (this.critical) {
            rawData[0] = (byte)(rawData[0] | 0x80);
        }
        byte[] tagBytes = this.tag.getBytes();
        rawData[1] = (byte)tagBytes.length;
        int cursor = 2;
        System.arraycopy(tagBytes, 0, rawData, cursor, tagBytes.length);
        byte[] valueBytes = this.value.getBytes();
        System.arraycopy(valueBytes, 0, rawData, cursor += tagBytes.length, valueBytes.length);
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    @Override
    public String toString(String indent) {
        String ls2 = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append(indent).append("CAA RDATA:").append(ls2).append(indent).append("  Issuer Critical: ").append(this.critical).append(ls2).append(indent).append("  Reserved Flags: 0x").append(ByteArrays.toHexString(this.reservedFlags, "")).append(ls2).append(indent).append("  Tag: ").append(this.tag).append(ls2).append(indent).append("  Value: ").append(this.value).append(ls2);
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent, byte[] headerRawData) {
        return this.toString(indent);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        DnsRDataCaa that = (DnsRDataCaa)o2;
        if (this.critical != that.critical) {
            return false;
        }
        if (this.reservedFlags != that.reservedFlags) {
            return false;
        }
        if (!this.tag.equals(that.tag)) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.critical ? 1 : 0;
        result = 31 * result + this.reservedFlags;
        result = 31 * result + this.tag.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public static final class Builder {
        private boolean critical;
        private byte reservedFlags;
        private String tag;
        private String value;

        public Builder() {
        }

        private Builder(DnsRDataCaa obj) {
            this.critical = obj.critical;
            this.reservedFlags = obj.reservedFlags;
            this.tag = obj.tag;
            this.value = obj.value;
        }

        public Builder critical(boolean critical) {
            this.critical = critical;
            return this;
        }

        public Builder reservedFlags(byte reservedFlags) {
            this.reservedFlags = reservedFlags;
            return this;
        }

        public Builder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public DnsRDataCaa build() {
            return new DnsRDataCaa(this);
        }
    }
}

