/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import java.math.RoundingMode;
import org.joda.convert.FromString;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.joda.time.base.BaseDuration;
import org.joda.time.field.FieldUtils;

public final class Duration
extends BaseDuration
implements ReadableDuration,
Serializable {
    public static final Duration ZERO = new Duration(0L);
    private static final long serialVersionUID = 2471658376918L;

    @FromString
    public static Duration parse(String string) {
        return new Duration(string);
    }

    public static Duration standardDays(long l2) {
        if (l2 == 0L) {
            return ZERO;
        }
        return new Duration(FieldUtils.safeMultiply(l2, 86400000));
    }

    public static Duration standardHours(long l2) {
        if (l2 == 0L) {
            return ZERO;
        }
        return new Duration(FieldUtils.safeMultiply(l2, 3600000));
    }

    public static Duration standardMinutes(long l2) {
        if (l2 == 0L) {
            return ZERO;
        }
        return new Duration(FieldUtils.safeMultiply(l2, 60000));
    }

    public static Duration standardSeconds(long l2) {
        if (l2 == 0L) {
            return ZERO;
        }
        return new Duration(FieldUtils.safeMultiply(l2, 1000));
    }

    public static Duration millis(long l2) {
        if (l2 == 0L) {
            return ZERO;
        }
        return new Duration(l2);
    }

    public Duration(long l2) {
        super(l2);
    }

    public Duration(long l2, long l3) {
        super(l2, l3);
    }

    public Duration(ReadableInstant readableInstant, ReadableInstant readableInstant2) {
        super(readableInstant, readableInstant2);
    }

    public Duration(Object object) {
        super(object);
    }

    public long getStandardDays() {
        return this.getMillis() / 86400000L;
    }

    public long getStandardHours() {
        return this.getMillis() / 3600000L;
    }

    public long getStandardMinutes() {
        return this.getMillis() / 60000L;
    }

    public long getStandardSeconds() {
        return this.getMillis() / 1000L;
    }

    public Duration toDuration() {
        return this;
    }

    public Days toStandardDays() {
        long l2 = this.getStandardDays();
        return Days.days(FieldUtils.safeToInt(l2));
    }

    public Hours toStandardHours() {
        long l2 = this.getStandardHours();
        return Hours.hours(FieldUtils.safeToInt(l2));
    }

    public Minutes toStandardMinutes() {
        long l2 = this.getStandardMinutes();
        return Minutes.minutes(FieldUtils.safeToInt(l2));
    }

    public Seconds toStandardSeconds() {
        long l2 = this.getStandardSeconds();
        return Seconds.seconds(FieldUtils.safeToInt(l2));
    }

    public Duration withMillis(long l2) {
        if (l2 == this.getMillis()) {
            return this;
        }
        return new Duration(l2);
    }

    public Duration withDurationAdded(long l2, int n2) {
        if (l2 == 0L || n2 == 0) {
            return this;
        }
        long l3 = FieldUtils.safeMultiply(l2, n2);
        long l4 = FieldUtils.safeAdd(this.getMillis(), l3);
        return new Duration(l4);
    }

    public Duration withDurationAdded(ReadableDuration readableDuration, int n2) {
        if (readableDuration == null || n2 == 0) {
            return this;
        }
        return this.withDurationAdded(readableDuration.getMillis(), n2);
    }

    public Duration plus(long l2) {
        return this.withDurationAdded(l2, 1);
    }

    public Duration plus(ReadableDuration readableDuration) {
        if (readableDuration == null) {
            return this;
        }
        return this.withDurationAdded(readableDuration.getMillis(), 1);
    }

    public Duration minus(long l2) {
        return this.withDurationAdded(l2, -1);
    }

    public Duration minus(ReadableDuration readableDuration) {
        if (readableDuration == null) {
            return this;
        }
        return this.withDurationAdded(readableDuration.getMillis(), -1);
    }

    public Duration multipliedBy(long l2) {
        if (l2 == 1L) {
            return this;
        }
        return new Duration(FieldUtils.safeMultiply(this.getMillis(), l2));
    }

    public Duration dividedBy(long l2) {
        if (l2 == 1L) {
            return this;
        }
        return new Duration(FieldUtils.safeDivide(this.getMillis(), l2));
    }

    public Duration dividedBy(long l2, RoundingMode roundingMode) {
        if (l2 == 1L) {
            return this;
        }
        return new Duration(FieldUtils.safeDivide(this.getMillis(), l2, roundingMode));
    }

    public Duration negated() {
        if (this.getMillis() == Long.MIN_VALUE) {
            throw new ArithmeticException("Negation of this duration would overflow");
        }
        return new Duration(-this.getMillis());
    }

    public Duration abs() {
        if (this.getMillis() < 0L) {
            return this.negated();
        }
        return this;
    }
}

