/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres.internal;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class BitStringEnumSetColumnMapper<E extends Enum<E>>
implements ColumnMapper<EnumSet<E>> {
    private final Class<E> enumType;
    private final E[] enumConstants;

    BitStringEnumSetColumnMapper(Class<E> enumType) {
        this.enumType = enumType;
        this.enumConstants = (Enum[])enumType.getEnumConstants();
    }

    @Override
    public EnumSet<E> map(ResultSet r2, int columnNumber, StatementContext ctx) throws SQLException {
        String bits = r2.getString(columnNumber);
        if (bits == null) {
            return null;
        }
        if (bits.length() != this.enumConstants.length) {
            throw new IllegalArgumentException("bit string \"" + bits + "\" for " + this.enumType + " should not contain " + bits.length() + " characters");
        }
        return IntStream.range(0, bits.length()).filter(i2 -> {
            char bit = bits.charAt(i2);
            switch (bit) {
                case '1': {
                    return true;
                }
                case '0': {
                    return false;
                }
            }
            throw new IllegalArgumentException("bit string \"" + bits + "\" contains non-bit character " + bit);
        }).mapToObj(i2 -> this.enumConstants[i2]).collect(Collectors.toCollection(() -> EnumSet.noneOf(this.enumType)));
    }
}

