/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import org.jdbi.v3.core.statement.ParsedSql;
import org.jdbi.v3.core.statement.SqlParser;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.meta.Beta;

abstract class CachingSqlParser
implements SqlParser {
    private final LoadingCache<String, ParsedSql> parsedSqlCache;

    CachingSqlParser() {
        this(Caffeine.newBuilder().maximumSize(1000L));
    }

    CachingSqlParser(Caffeine<Object, Object> cache) {
        this.parsedSqlCache = cache.build(this::internalParse);
    }

    @Override
    public ParsedSql parse(String sql, StatementContext ctx) {
        try {
            return this.parsedSqlCache.get(sql);
        }
        catch (IllegalArgumentException e2) {
            throw new UnableToCreateStatementException("Exception parsing for named parameter replacement", e2, ctx);
        }
    }

    @Beta
    public CacheStats cacheStats() {
        return this.parsedSqlCache.stats();
    }

    abstract ParsedSql internalParse(String var1);
}

