/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.gelfclient.transport;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import org.graylog2.gelfclient.GelfConfiguration;
import org.graylog2.gelfclient.encoder.GelfCompressionGzipEncoder;
import org.graylog2.gelfclient.encoder.GelfCompressionZlibEncoder;
import org.graylog2.gelfclient.encoder.GelfMessageChunkEncoder;
import org.graylog2.gelfclient.encoder.GelfMessageJsonEncoder;
import org.graylog2.gelfclient.encoder.GelfMessageUdpEncoder;
import org.graylog2.gelfclient.transport.AbstractGelfTransport;
import org.graylog2.gelfclient.transport.GelfSenderThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GelfUdpTransport
extends AbstractGelfTransport {
    private static final Logger LOG = LoggerFactory.getLogger(GelfUdpTransport.class);

    public GelfUdpTransport(GelfConfiguration config) {
        super(config);
    }

    @Override
    protected void createBootstrap(EventLoopGroup workerGroup) {
        Bootstrap bootstrap = new Bootstrap();
        final GelfSenderThread senderThread = new GelfSenderThread(this.queue, this.config.getMaxInflightSends());
        this.senderThreadReference.set(senderThread);
        ((Bootstrap)((Bootstrap)bootstrap.group(workerGroup)).channel(NioDatagramChannel.class)).handler(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch2) throws Exception {
                ch2.pipeline().addLast(new GelfMessageUdpEncoder(GelfUdpTransport.this.config.getRemoteAddress()));
                ch2.pipeline().addLast(new GelfMessageChunkEncoder());
                switch (GelfUdpTransport.this.config.getCompression()) {
                    case GZIP: {
                        ch2.pipeline().addLast(new GelfCompressionGzipEncoder());
                        break;
                    }
                    case ZLIB: {
                        ch2.pipeline().addLast(new GelfCompressionZlibEncoder());
                        break;
                    }
                }
                ch2.pipeline().addLast(new GelfMessageJsonEncoder());
                ch2.pipeline().addLast(new SimpleChannelInboundHandler<DatagramPacket>(){

                    @Override
                    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) throws Exception {
                    }

                    @Override
                    public void channelActive(ChannelHandlerContext ctx) throws Exception {
                        senderThread.start(ctx.channel());
                    }

                    @Override
                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        senderThread.stop();
                    }

                    @Override
                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        LOG.error("Exception caught", cause);
                    }
                });
            }
        });
        if (this.config.getSendBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_SNDBUF, this.config.getSendBufferSize());
        }
        bootstrap.bind(0);
    }
}

