/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.internal.inject.ExtractorException;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;

final class PrimitiveValueOfExtractor
implements MultivaluedParameterExtractor<Object> {
    private final Method valueOf;
    private final String parameter;
    private final String defaultStringValue;
    private final Object defaultValue;
    private final Object defaultPrimitiveTypeValue;

    public PrimitiveValueOfExtractor(Method valueOf, String parameter, String defaultStringValue, Object defaultPrimitiveTypeValue) {
        this.valueOf = valueOf;
        this.parameter = parameter;
        this.defaultStringValue = defaultStringValue;
        this.defaultValue = defaultStringValue != null ? this.getValue(defaultStringValue) : null;
        this.defaultPrimitiveTypeValue = defaultPrimitiveTypeValue;
    }

    @Override
    public String getName() {
        return this.parameter;
    }

    @Override
    public String getDefaultValueString() {
        return this.defaultStringValue;
    }

    private Object getValue(String v2) {
        try {
            return this.valueOf.invoke(null, v2);
        }
        catch (InvocationTargetException ex2) {
            Throwable target = ex2.getTargetException();
            if (target instanceof WebApplicationException) {
                throw (WebApplicationException)target;
            }
            throw new ExtractorException(target);
        }
        catch (Exception ex3) {
            throw new ProcessingException(ex3);
        }
    }

    @Override
    public Object extract(MultivaluedMap<String, String> parameters) {
        String v2 = parameters.getFirst(this.parameter);
        if (v2 != null && !v2.trim().isEmpty()) {
            return this.getValue(v2);
        }
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        return this.defaultPrimitiveTypeValue;
    }
}

