/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

final class GrammarUtil {
    public static final int TOKEN = 0;
    public static final int QUOTED_STRING = 1;
    public static final int COMMENT = 2;
    public static final int SEPARATOR = 3;
    public static final int CONTROL = 4;
    private static final char[] WHITE_SPACE = new char[]{'\t', '\r', '\n', ' '};
    private static final char[] SEPARATORS = new char[]{'(', ')', '<', '>', '@', ',', ';', ':', '\\', '\"', '/', '[', ']', '?', '=', '{', '}', ' ', '\t'};
    private static final int[] TYPE_TABLE = GrammarUtil.createEventTable();
    private static final boolean[] IS_WHITE_SPACE = GrammarUtil.createWhiteSpaceTable();
    private static final boolean[] IS_TOKEN = GrammarUtil.createTokenTable();

    private static int[] createEventTable() {
        int i2;
        int[] table = new int[128];
        int control_char_bound = 32;
        for (i2 = 0; i2 < 32; ++i2) {
            table[i2] = 4;
        }
        table[127] = 4;
        for (i2 = 32; i2 < 127; ++i2) {
            table[i2] = 0;
        }
        for (char c2 : SEPARATORS) {
            table[c2] = 3;
        }
        table[40] = 2;
        table[34] = 1;
        for (char c2 : WHITE_SPACE) {
            table[c2] = -1;
        }
        return table;
    }

    private static boolean[] createWhiteSpaceTable() {
        boolean[] table = new boolean[128];
        for (char c2 : WHITE_SPACE) {
            table[c2] = true;
        }
        return table;
    }

    private static boolean[] createTokenTable() {
        boolean[] table = new boolean[128];
        for (int i2 = 0; i2 <= 127; ++i2) {
            table[i2] = TYPE_TABLE[i2] == 0;
        }
        return table;
    }

    public static boolean isWhiteSpace(char c2) {
        return c2 <= '\u007f' && IS_WHITE_SPACE[c2];
    }

    public static boolean isToken(char c2) {
        return c2 <= '\u007f' && IS_TOKEN[c2];
    }

    public static int getType(char c2) {
        if (c2 > '\u007f') {
            throw new IllegalArgumentException("Unsupported character - ordinal value too high: " + c2);
        }
        return TYPE_TABLE[c2];
    }

    public static boolean isSeparator(char c2) {
        return c2 <= '\u007f' && TYPE_TABLE[c2] == 3;
    }

    public static boolean isTokenString(String s2) {
        for (char c2 : s2.toCharArray()) {
            if (GrammarUtil.isToken(c2)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsWhiteSpace(String s2) {
        for (char c2 : s2.toCharArray()) {
            if (!GrammarUtil.isWhiteSpace(c2)) continue;
            return true;
        }
        return false;
    }

    public static String filterToken(CharSequence s2, int start, int end) {
        return GrammarUtil.filterToken(s2, start, end, false);
    }

    public static String filterToken(CharSequence s2, int start, int end, boolean preserveBackslash) {
        StringBuilder sb = new StringBuilder();
        boolean gotEscape = false;
        boolean gotCR = false;
        for (int i2 = start; i2 < end; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 == '\n' && gotCR) {
                gotCR = false;
                continue;
            }
            gotCR = false;
            if (!gotEscape) {
                if (!preserveBackslash && c2 == '\\') {
                    gotEscape = true;
                    continue;
                }
                if (c2 == '\r') {
                    gotCR = true;
                    continue;
                }
                sb.append(c2);
                continue;
            }
            sb.append(c2);
            gotEscape = false;
        }
        return sb.toString();
    }

    private GrammarUtil() {
    }
}

