/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.glassfish.grizzly.utils.ServiceConfigurationError;

public final class ServiceFinder<T>
implements Iterable<T> {
    private static final String prefix = "META-INF/services/";
    private final Class<T> serviceClass;
    private final ClassLoader classLoader;

    public static <T> ServiceFinder<T> find(Class<T> service, ClassLoader loader) {
        return new ServiceFinder<T>(service, loader);
    }

    public static <T> ServiceFinder<T> find(Class<T> service) {
        return ServiceFinder.find(service, Thread.currentThread().getContextClassLoader());
    }

    private ServiceFinder(Class<T> service, ClassLoader loader) {
        this.serviceClass = service;
        this.classLoader = loader;
    }

    @Override
    public Iterator<T> iterator() {
        return new LazyIterator(this.serviceClass, this.classLoader);
    }

    public T[] toArray() {
        ArrayList<T> result = new ArrayList<T>();
        for (T t2 : this) {
            result.add(t2);
        }
        return result.toArray((Object[])Array.newInstance(this.serviceClass, result.size()));
    }

    private static void fail(Class service, String msg, Throwable cause) throws ServiceConfigurationError {
        ServiceConfigurationError sce = new ServiceConfigurationError(service.getName() + ": " + msg);
        sce.initCause(cause);
        throw sce;
    }

    private static void fail(Class service, String msg) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg);
    }

    private static void fail(Class service, URL u2, int line, String msg) throws ServiceConfigurationError {
        ServiceFinder.fail(service, u2 + ":" + line + ": " + msg);
    }

    private static int parseLine(Class service, URL u2, BufferedReader r2, int lc2, List<String> names, Set<String> returned) throws IOException, ServiceConfigurationError {
        int n2;
        String ln2 = r2.readLine();
        if (ln2 == null) {
            return -1;
        }
        int ci2 = ln2.indexOf(35);
        if (ci2 >= 0) {
            ln2 = ln2.substring(0, ci2);
        }
        if ((n2 = (ln2 = ln2.trim()).length()) != 0) {
            int cp2;
            if (ln2.indexOf(32) >= 0 || ln2.indexOf(9) >= 0) {
                ServiceFinder.fail(service, u2, lc2, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(cp2 = ln2.codePointAt(0))) {
                ServiceFinder.fail(service, u2, lc2, "Illegal provider-class name: " + ln2);
            }
            for (int i2 = Character.charCount(cp2); i2 < n2; i2 += Character.charCount(cp2)) {
                cp2 = ln2.codePointAt(i2);
                if (Character.isJavaIdentifierPart(cp2) || cp2 == 46) continue;
                ServiceFinder.fail(service, u2, lc2, "Illegal provider-class name: " + ln2);
            }
            if (!returned.contains(ln2)) {
                names.add(ln2);
                returned.add(ln2);
            }
        }
        return lc2 + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Iterator<String> parse(Class service, URL u2, Set<String> returned) throws ServiceConfigurationError {
        InputStream in2 = null;
        BufferedReader r2 = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            in2 = u2.openStream();
            r2 = new BufferedReader(new InputStreamReader(in2, "utf-8"));
            int lc2 = 1;
            while ((lc2 = ServiceFinder.parseLine(service, u2, r2, lc2, names, returned)) >= 0) {
            }
        }
        catch (IOException x2) {
            ServiceFinder.fail(service, ": " + x2);
        }
        finally {
            try {
                if (r2 != null) {
                    r2.close();
                }
                if (in2 != null) {
                    in2.close();
                }
            }
            catch (IOException y2) {
                ServiceFinder.fail(service, ": " + y2);
            }
        }
        return names.iterator();
    }

    private static class LazyIterator<T>
    implements Iterator<T> {
        final Class<T> service;
        final ClassLoader loader;
        Enumeration<URL> configs = null;
        Iterator<String> pending = null;
        final Set<String> returned = new TreeSet<String>();
        String nextName = null;
        URL currentConfig = null;

        private LazyIterator(Class<T> service, ClassLoader loader) {
            this.service = service;
            this.loader = loader;
        }

        @Override
        public boolean hasNext() throws ServiceConfigurationError {
            if (this.nextName != null) {
                return true;
            }
            if (this.configs == null) {
                try {
                    String fullName = ServiceFinder.prefix + this.service.getName();
                    this.configs = this.loader == null ? ClassLoader.getSystemResources(fullName) : this.loader.getResources(fullName);
                }
                catch (IOException x2) {
                    ServiceFinder.fail(this.service, ": " + x2);
                }
            }
            while (this.pending == null || !this.pending.hasNext()) {
                if (!this.configs.hasMoreElements()) {
                    return false;
                }
                this.currentConfig = this.configs.nextElement();
                this.pending = ServiceFinder.parse(this.service, this.currentConfig, this.returned);
            }
            this.nextName = this.pending.next();
            return true;
        }

        @Override
        public T next() throws ServiceConfigurationError {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String cn2 = this.nextName;
            this.nextName = null;
            try {
                return this.service.cast(Class.forName(cn2, true, this.loader).newInstance());
            }
            catch (ClassNotFoundException x2) {
                ServiceFinder.fail(this.service, "Provider " + cn2 + " is specified in " + this.currentConfig + " but not found");
            }
            catch (Exception x3) {
                ServiceFinder.fail(this.service, "Provider " + cn2 + " is specified in " + this.currentConfig + "but could not be instantiated: " + x3, x3);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

