/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.strategies;

import java.io.IOException;
import java.util.EnumSet;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventLifeCycleListener;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.asyncqueue.AsyncQueue;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

public abstract class AbstractIOStrategy
implements IOStrategy {
    private static final EnumSet<IOEvent> READ_WRITE_EVENT_SET = EnumSet.of(IOEvent.READ, IOEvent.WRITE);
    private static final EnumSet<IOEvent> WORKER_THREAD_EVENT_SET = EnumSet.of(IOEvent.READ, IOEvent.CLOSED);
    protected static final IOEventLifeCycleListener ENABLE_INTEREST_LIFECYCLE_LISTENER = new EnableInterestLifeCycleListener();

    @Override
    public ThreadPoolConfig createDefaultWorkerPoolConfig(Transport transport) {
        ThreadPoolConfig config = ThreadPoolConfig.defaultConfig().copy();
        int coresCount = Runtime.getRuntime().availableProcessors();
        config.setPoolName("Grizzly-worker");
        config.setCorePoolSize(coresCount * 2);
        config.setMaxPoolSize(coresCount * 2);
        config.setMemoryManager(transport.getMemoryManager());
        return config;
    }

    @Override
    public final boolean executeIoEvent(Connection connection, IOEvent ioEvent) throws IOException {
        return this.executeIoEvent(connection, ioEvent, true);
    }

    @Override
    public Executor getThreadPoolFor(Connection connection, IOEvent ioEvent) {
        return WORKER_THREAD_EVENT_SET.contains((Object)ioEvent) ? connection.getTransport().getWorkerThreadPool() : null;
    }

    protected static boolean isReadWrite(IOEvent ioEvent) {
        return READ_WRITE_EVENT_SET.contains((Object)ioEvent);
    }

    protected static void fireIOEvent(Connection connection, IOEvent ioEvent, IOEventLifeCycleListener listener, Logger logger) {
        try {
            connection.getTransport().fireIOEvent(ioEvent, connection, listener);
        }
        catch (Exception e2) {
            logger.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_IOSTRATEGY_UNCAUGHT_EXCEPTION(), e2);
            connection.closeSilently();
        }
    }

    private static final class EnableInterestLifeCycleListener
    extends IOEventLifeCycleListener.Adapter {
        private EnableInterestLifeCycleListener() {
        }

        @Override
        public void onReregister(Context context) throws IOException {
            this.onComplete(context, null);
        }

        @Override
        public void onComplete(Context context, Object data) throws IOException {
            IOEvent ioEvent = context.getIoEvent();
            Connection connection = context.getConnection();
            if (AsyncQueue.EXPECTING_MORE_OPTION.equals(data)) {
                connection.simulateIOEvent(ioEvent);
            } else {
                connection.enableIOEvent(ioEvent);
            }
        }
    }
}

