/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.ByteChunk;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.HexUtils;

public class URLDecoder {
    public static void decode(DataChunk dataChunk) throws CharConversionException {
        URLDecoder.decode(dataChunk, true);
    }

    public static void decode(DataChunk dataChunk, boolean allowEncodedSlash) throws CharConversionException {
        URLDecoder.decodeAscii(dataChunk, dataChunk, allowEncodedSlash);
    }

    public static void decode(DataChunk srcDataChunk, DataChunk dstDataChunk, boolean allowEncodedSlash) throws CharConversionException {
        URLDecoder.decodeAscii(srcDataChunk, dstDataChunk, allowEncodedSlash);
    }

    public static void decode(DataChunk srcDataChunk, DataChunk dstDataChunk, boolean allowEncodedSlash, String enc) throws CharConversionException {
        switch (srcDataChunk.getType()) {
            case Bytes: {
                ByteChunk srcByteChunk = srcDataChunk.getByteChunk();
                ByteChunk dstByteChunk = dstDataChunk.getByteChunk();
                if (dstByteChunk != srcByteChunk) {
                    dstByteChunk.allocate(srcByteChunk.getLength(), -1);
                }
                URLDecoder.decode(srcByteChunk, dstByteChunk, allowEncodedSlash);
                return;
            }
            case Buffer: {
                BufferChunk srcBufferChunk = srcDataChunk.getBufferChunk();
                if (dstDataChunk != srcDataChunk) {
                    ByteChunk dstByteChunk = dstDataChunk.getByteChunk();
                    dstByteChunk.allocate(srcBufferChunk.getLength(), -1);
                    URLDecoder.decode(srcBufferChunk, dstByteChunk, allowEncodedSlash);
                } else {
                    URLDecoder.decode(srcBufferChunk, srcBufferChunk, allowEncodedSlash);
                }
                return;
            }
            case String: {
                dstDataChunk.setString(URLDecoder.decode(srcDataChunk.toString(), allowEncodedSlash, enc));
                return;
            }
            case Chars: {
                CharChunk srcCharChunk = srcDataChunk.getCharChunk();
                CharChunk dstCharChunk = dstDataChunk.getCharChunk();
                if (dstDataChunk != srcDataChunk) {
                    dstCharChunk.ensureCapacity(srcCharChunk.getLength());
                    URLDecoder.decode(srcCharChunk, dstCharChunk, allowEncodedSlash, enc);
                } else {
                    URLDecoder.decode(srcCharChunk, srcCharChunk, allowEncodedSlash, enc);
                }
                dstDataChunk.setChars(dstCharChunk.getChars(), dstCharChunk.getStart(), dstCharChunk.getEnd());
                return;
            }
        }
        throw new NullPointerException();
    }

    public static void decodeAscii(DataChunk srcDataChunk, DataChunk dstDataChunk, boolean allowEncodedSlash) throws CharConversionException {
        switch (srcDataChunk.getType()) {
            case Bytes: {
                ByteChunk srcByteChunk = srcDataChunk.getByteChunk();
                ByteChunk dstByteChunk = dstDataChunk.getByteChunk();
                if (dstByteChunk != srcByteChunk) {
                    dstByteChunk.allocate(srcByteChunk.getLength(), -1);
                }
                URLDecoder.decode(srcByteChunk, dstByteChunk, allowEncodedSlash);
                return;
            }
            case Buffer: {
                BufferChunk srcBufferChunk = srcDataChunk.getBufferChunk();
                if (dstDataChunk != srcDataChunk) {
                    ByteChunk dstByteChunk = dstDataChunk.getByteChunk();
                    dstByteChunk.allocate(srcBufferChunk.getLength(), -1);
                    URLDecoder.decode(srcBufferChunk, dstByteChunk, allowEncodedSlash);
                } else {
                    URLDecoder.decode(srcBufferChunk, srcBufferChunk, allowEncodedSlash);
                }
                return;
            }
            case String: {
                dstDataChunk.setString(URLDecoder.decodeAscii(srcDataChunk.toString(), allowEncodedSlash));
                return;
            }
            case Chars: {
                CharChunk srcCharChunk = srcDataChunk.getCharChunk();
                CharChunk dstCharChunk = dstDataChunk.getCharChunk();
                if (dstDataChunk != srcDataChunk) {
                    dstCharChunk.ensureCapacity(srcCharChunk.getLength());
                    URLDecoder.decodeAscii(srcCharChunk, dstCharChunk, allowEncodedSlash);
                } else {
                    URLDecoder.decodeAscii(srcCharChunk, srcCharChunk, allowEncodedSlash);
                }
                dstDataChunk.setChars(dstCharChunk.getChars(), dstCharChunk.getStart(), dstCharChunk.getEnd());
                return;
            }
        }
        throw new NullPointerException();
    }

    public static void decode(ByteChunk byteChunk, boolean allowEncodedSlash) throws CharConversionException {
        URLDecoder.decode(byteChunk, byteChunk, allowEncodedSlash);
    }

    public static void decode(ByteChunk srcByteChunk, ByteChunk dstByteChunk, boolean allowEncodedSlash) throws CharConversionException {
        byte[] srcBuffer = srcByteChunk.getBuffer();
        int srcStart = srcByteChunk.getStart();
        int srcEnd = srcByteChunk.getEnd();
        byte[] dstBuffer = dstByteChunk.getBuffer();
        int idx = dstByteChunk.getStart();
        int j2 = srcStart;
        while (j2 < srcEnd) {
            byte b2 = srcBuffer[j2];
            if (b2 == 43) {
                dstBuffer[idx] = 32;
            } else if (b2 != 37) {
                dstBuffer[idx] = b2;
            } else {
                if (j2 + 2 >= srcEnd) {
                    throw new IllegalStateException("Unexpected termination");
                }
                byte b1 = srcBuffer[j2 + 1];
                byte b22 = srcBuffer[j2 + 2];
                if (!HexUtils.isHexDigit(b1) || !HexUtils.isHexDigit(b22)) {
                    throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - %" + (char)b1 + "" + (char)b22);
                }
                j2 += 2;
                int res = URLDecoder.x2c(b1, b22);
                if (!allowEncodedSlash && res == 47) {
                    throw new CharConversionException("Encoded slashes are not allowed");
                }
                dstBuffer[idx] = (byte)res;
            }
            ++j2;
            ++idx;
        }
        dstByteChunk.setEnd(idx);
    }

    public static void decode(BufferChunk srcBufferChunk, ByteChunk dstByteChunk, boolean allowEncodedSlash) throws CharConversionException {
        Buffer srcBuffer = srcBufferChunk.getBuffer();
        int srcStart = srcBufferChunk.getStart();
        int srcEnd = srcBufferChunk.getEnd();
        byte[] dstBuffer = dstByteChunk.getBuffer();
        int idx = dstByteChunk.getStart();
        int j2 = srcStart;
        while (j2 < srcEnd) {
            byte b2 = srcBuffer.get(j2);
            if (b2 == 43) {
                dstBuffer[idx] = 32;
            } else if (b2 != 37) {
                dstBuffer[idx] = b2;
            } else {
                if (j2 + 2 >= srcEnd) {
                    throw new IllegalStateException("Unexpected termination");
                }
                byte b1 = srcBuffer.get(j2 + 1);
                byte b22 = srcBuffer.get(j2 + 2);
                if (!HexUtils.isHexDigit(b1) || !HexUtils.isHexDigit(b22)) {
                    throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - %" + (char)b1 + "" + (char)b22);
                }
                j2 += 2;
                int res = URLDecoder.x2c(b1, b22);
                if (!allowEncodedSlash && res == 47) {
                    throw new CharConversionException("Encoded slashes are not allowed");
                }
                dstBuffer[idx] = (byte)res;
            }
            ++j2;
            ++idx;
        }
        dstByteChunk.setEnd(idx);
    }

    public static void decode(ByteChunk srcByteChunk, BufferChunk dstBufferChunk, boolean allowEncodedSlash) throws CharConversionException {
        byte[] srcBuffer = srcByteChunk.getBuffer();
        int srcStart = srcByteChunk.getStart();
        int srcEnd = srcByteChunk.getEnd();
        Buffer dstBuffer = dstBufferChunk.getBuffer();
        int idx = dstBufferChunk.getStart();
        int j2 = srcStart;
        while (j2 < srcEnd) {
            byte b2 = srcBuffer[j2];
            if (b2 == 43) {
                dstBuffer.put(idx, (byte)32);
            } else if (b2 != 37) {
                dstBuffer.put(idx, b2);
            } else {
                if (j2 + 2 >= srcEnd) {
                    throw new IllegalStateException("Unexpected termination");
                }
                byte b1 = srcBuffer[j2 + 1];
                byte b22 = srcBuffer[j2 + 2];
                if (!HexUtils.isHexDigit(b1) || !HexUtils.isHexDigit(b22)) {
                    throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - %" + (char)b1 + "" + (char)b22);
                }
                j2 += 2;
                int res = URLDecoder.x2c(b1, b22);
                if (!allowEncodedSlash && res == 47) {
                    throw new CharConversionException("Encoded slashes are not allowed");
                }
                dstBuffer.put(idx, (byte)res);
            }
            ++j2;
            ++idx;
        }
        dstBufferChunk.setEnd(idx);
    }

    public static void decode(BufferChunk bufferChunk, boolean allowEncodedSlash) throws CharConversionException {
        URLDecoder.decode(bufferChunk, bufferChunk, allowEncodedSlash);
    }

    public static void decode(BufferChunk srcBufferChunk, BufferChunk dstBufferChunk, boolean allowEncodedSlash) throws CharConversionException {
        Buffer srcBuffer = srcBufferChunk.getBuffer();
        int srcStart = srcBufferChunk.getStart();
        int srcEnd = srcBufferChunk.getEnd();
        Buffer dstBuffer = dstBufferChunk.getBuffer();
        int idx = dstBufferChunk.getStart();
        int j2 = srcStart;
        while (j2 < srcEnd) {
            byte b2 = srcBuffer.get(j2);
            if (b2 == 43) {
                dstBuffer.put(idx, (byte)32);
            } else if (b2 != 37) {
                dstBuffer.put(idx, b2);
            } else {
                if (j2 + 2 >= srcEnd) {
                    throw new IllegalStateException("Unexpected termination");
                }
                byte b1 = srcBuffer.get(j2 + 1);
                byte b22 = srcBuffer.get(j2 + 2);
                if (!HexUtils.isHexDigit(b1) || !HexUtils.isHexDigit(b22)) {
                    throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - %" + (char)b1 + "" + (char)b22);
                }
                j2 += 2;
                int res = URLDecoder.x2c(b1, b22);
                if (!allowEncodedSlash && res == 47) {
                    throw new CharConversionException("Encoded slashes are not allowed");
                }
                dstBuffer.put(idx, (byte)res);
            }
            ++j2;
            ++idx;
        }
        dstBufferChunk.setEnd(idx);
    }

    public static void decode(CharChunk charChunk, boolean allowEncodedSlash) throws CharConversionException {
        URLDecoder.decodeAscii(charChunk, charChunk, allowEncodedSlash);
    }

    public static void decode(CharChunk srcCharChunk, CharChunk dstCharChunk, boolean allowEncodedSlash) throws CharConversionException {
        URLDecoder.decodeAscii(srcCharChunk, dstCharChunk, allowEncodedSlash);
    }

    public static void decode(CharChunk srcCharChunk, CharChunk dstCharChunk, boolean allowEncodedSlash, String enc) throws CharConversionException {
        byte[] bytes = null;
        char[] srcBuffer = srcCharChunk.getBuffer();
        int srcStart = srcCharChunk.getStart();
        int srcEnd = srcCharChunk.getEnd();
        int srcLen = srcEnd - srcStart;
        char[] dstBuffer = dstCharChunk.getBuffer();
        int idx = dstCharChunk.getStart();
        int j2 = srcStart;
        while (j2 < srcEnd) {
            char c2 = srcBuffer[j2];
            if (c2 == '+') {
                dstBuffer[idx++] = 32;
                ++j2;
                continue;
            }
            if (c2 != '%') {
                dstBuffer[idx++] = c2;
                ++j2;
                continue;
            }
            try {
                if (bytes == null) {
                    bytes = new byte[(srcLen - j2) / 3];
                }
                int pos = 0;
                while (j2 + 2 < srcLen && c2 == '%') {
                    char c1 = srcBuffer[j2 + 1];
                    char c22 = srcBuffer[j2 + 2];
                    if (!HexUtils.isHexDigit(c1) || !HexUtils.isHexDigit(c22)) {
                        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - %" + c1 + "" + c22);
                    }
                    int v2 = URLDecoder.x2c(c1, c22);
                    if (v2 < 0) {
                        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - negative value");
                    }
                    bytes[pos++] = (byte)v2;
                    if ((j2 += 3) >= srcLen) continue;
                    c2 = srcBuffer[j2];
                }
                if (j2 < srcLen && c2 == '%') {
                    throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                }
                String decodedChunk = new String(bytes, 0, pos, enc);
                if (!allowEncodedSlash && decodedChunk.indexOf(47) != -1) {
                    throw new CharConversionException("Encoded slashes are not allowed");
                }
                int chunkLen = decodedChunk.length();
                decodedChunk.getChars(0, chunkLen, dstBuffer, idx);
                idx += chunkLen;
            }
            catch (NumberFormatException e2) {
                throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + e2.getMessage());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
        }
        dstCharChunk.setEnd(idx);
    }

    public static void decodeAscii(CharChunk srcCharChunk, CharChunk dstCharChunk, boolean allowEncodedSlash) throws CharConversionException {
        char[] srcBuffer = srcCharChunk.getBuffer();
        int srcStart = srcCharChunk.getStart();
        int srcEnd = srcCharChunk.getEnd();
        char[] dstBuffer = dstCharChunk.getBuffer();
        int idx = dstCharChunk.getStart();
        int j2 = srcStart;
        while (j2 < srcEnd) {
            char c2 = srcBuffer[j2];
            if (c2 == '+') {
                dstBuffer[idx] = 32;
            } else if (c2 != '%') {
                dstBuffer[idx] = c2;
            } else {
                if (j2 + 2 >= srcEnd) {
                    throw new IllegalStateException("Unexpected termination");
                }
                char c1 = srcBuffer[j2 + 1];
                char c22 = srcBuffer[j2 + 2];
                if (!HexUtils.isHexDigit(c1) || !HexUtils.isHexDigit(c22)) {
                    throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - %" + c1 + "" + c22);
                }
                j2 += 2;
                int res = URLDecoder.x2c(c1, c22);
                if (!allowEncodedSlash && res == 47) {
                    throw new CharConversionException("Encoded slashes are not allowed");
                }
                dstBuffer[idx] = (char)res;
            }
            ++j2;
            ++idx;
        }
        dstCharChunk.setEnd(idx);
    }

    public static String decode(String str) throws CharConversionException {
        return URLDecoder.decodeAscii(str, true);
    }

    public static String decode(String str, boolean allowEncodedSlash) throws CharConversionException {
        return URLDecoder.decodeAscii(str, allowEncodedSlash);
    }

    public static String decode(String s2, boolean allowEncodedSlash, String enc) throws CharConversionException {
        boolean needToChange = false;
        int numChars = s2.length();
        StringBuilder sb = new StringBuilder(numChars > 500 ? numChars / 2 : numChars);
        int i2 = 0;
        byte[] bytes = null;
        block7: while (i2 < numChars) {
            char c2 = s2.charAt(i2);
            switch (c2) {
                case '+': {
                    sb.append(' ');
                    ++i2;
                    needToChange = true;
                    continue block7;
                }
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i2) / 3];
                        }
                        int pos = 0;
                        while (i2 + 2 < numChars && c2 == '%') {
                            int v2 = Integer.parseInt(s2.substring(i2 + 1, i2 + 3), 16);
                            if (v2 < 0) {
                                throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - negative value");
                            }
                            bytes[pos++] = (byte)v2;
                            if ((i2 += 3) >= numChars) continue;
                            c2 = s2.charAt(i2);
                        }
                        if (i2 < numChars && c2 == '%') {
                            throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                        }
                        String decodedChunk = new String(bytes, 0, pos, enc);
                        if (!allowEncodedSlash && decodedChunk.indexOf(47) != -1) {
                            throw new CharConversionException("Encoded slashes are not allowed");
                        }
                        sb.append(decodedChunk);
                    }
                    catch (NumberFormatException e2) {
                        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + e2.getMessage());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    needToChange = true;
                    continue block7;
                }
            }
            sb.append(c2);
            ++i2;
        }
        return needToChange ? sb.toString() : s2;
    }

    public static String decodeAscii(String str, boolean allowEncodedSlash) throws CharConversionException {
        if (str == null) {
            return null;
        }
        int mPos = 0;
        int strPos = 0;
        int strLen = str.length();
        StringBuilder dec = null;
        while (strPos < strLen) {
            boolean isNorm;
            char metaChar = str.charAt(strPos);
            boolean isPlus = metaChar == '+';
            boolean bl2 = isNorm = !isPlus && metaChar != '%';
            if (isNorm) {
                ++strPos;
                continue;
            }
            if (dec == null) {
                dec = new StringBuilder(strLen);
            }
            if (mPos < strPos) {
                dec.append(str, mPos, strPos);
            }
            if (isPlus) {
                dec.append(' ');
            } else {
                char res = (char)Integer.parseInt(str.substring(strPos + 1, strPos + 3), 16);
                if (!allowEncodedSlash && res == '/') {
                    throw new CharConversionException("Encoded slashes are not allowed");
                }
                dec.append(res);
                strPos += 3;
            }
            mPos = ++strPos;
        }
        if (dec != null) {
            if (mPos < strPos) {
                dec.append(str, mPos, strPos);
            }
            return dec.toString();
        }
        return str;
    }

    private static int x2c(byte b1, byte b2) {
        return (HexUtils.hexDigit2Dec(b1) << 4) + HexUtils.hexDigit2Dec(b2);
    }

    private static int x2c(int c1, int c2) {
        return (HexUtils.hexDigit2Dec(c1) << 4) + HexUtils.hexDigit2Dec(c2);
    }
}

