/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.util.ByteChunk;
import org.glassfish.grizzly.http.util.C2BConverter;

public final class UEncoder {
    private static final Logger logger = Grizzly.logger(UEncoder.class);
    private static final BitSet initialSafeChars = new BitSet(128);
    private final BitSet safeChars = (BitSet)initialSafeChars.clone();
    private C2BConverter c2b;
    private ByteChunk bb;
    private String encoding = "UTF8";
    private static final int debug = 0;

    public void setEncoding(String s2) {
        this.encoding = s2;
    }

    public void addSafeCharacter(char c2) {
        this.safeChars.set(c2);
    }

    public void urlEncode(Writer buf, String s2) throws IOException {
        this.urlEncode(buf, s2, false);
    }

    public void urlEncode(Writer buf, String s2, boolean toHexUpperCase) throws IOException {
        if (this.c2b == null) {
            this.bb = new ByteChunk(16);
            this.c2b = C2BConverter.getInstance(this.bb, this.encoding);
        }
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char d2;
            char c2 = s2.charAt(i2);
            if (this.safeChars.get(c2)) {
                buf.write(c2);
                continue;
            }
            this.c2b.convert(c2);
            if (c2 >= '\ud800' && c2 <= '\udbff' && i2 + 1 < s2.length() && (d2 = s2.charAt(i2 + 1)) >= '\udc00' && d2 <= '\udfff') {
                this.c2b.convert(d2);
                ++i2;
            }
            this.urlEncode(buf, this.bb.getBuffer(), this.bb.getStart(), this.bb.getLength(), toHexUpperCase);
            this.bb.recycle();
        }
    }

    public void urlEncode(Writer buf, byte[] bytes, int off, int len) throws IOException {
        this.urlEncode(buf, bytes, off, len, false);
    }

    public void urlEncode(Writer buf, byte[] bytes, int off, int len, boolean toHexUpperCase) throws IOException {
        for (int j2 = off; j2 < len; ++j2) {
            buf.write(37);
            char ch2 = Character.forDigit(bytes[j2] >> 4 & 0xF, 16);
            if (toHexUpperCase) {
                ch2 = Character.toUpperCase(ch2);
            }
            buf.write(ch2);
            ch2 = Character.forDigit(bytes[j2] & 0xF, 16);
            if (toHexUpperCase) {
                ch2 = Character.toUpperCase(ch2);
            }
            buf.write(ch2);
        }
    }

    public String encodeURL(String url) {
        return this.encodeURL(url, false);
    }

    public String encodeURL(String uri, boolean toHexUpperCase) {
        String outUri = null;
        try {
            CharArrayWriter out = new CharArrayWriter();
            this.urlEncode(out, uri, toHexUpperCase);
            outUri = out.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outUri;
    }

    private static void initSafeChars() {
        int i2;
        for (i2 = 97; i2 <= 122; ++i2) {
            initialSafeChars.set(i2);
        }
        for (i2 = 65; i2 <= 90; ++i2) {
            initialSafeChars.set(i2);
        }
        for (i2 = 48; i2 <= 57; ++i2) {
            initialSafeChars.set(i2);
        }
        initialSafeChars.set(36);
        initialSafeChars.set(45);
        initialSafeChars.set(95);
        initialSafeChars.set(46);
        initialSafeChars.set(33);
        initialSafeChars.set(42);
        initialSafeChars.set(39);
        initialSafeChars.set(40);
        initialSafeChars.set(41);
        initialSafeChars.set(44);
    }

    private static void log(String s2) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(s2);
        }
    }

    static {
        UEncoder.initSafeChars();
    }
}

