/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ExpandJar {
    public static String expand(URL jar) throws IOException {
        return ExpandJar.expand(jar, System.getProperty("java.io.tmpdir"));
    }

    public static String expand(URL jar, String workFolder) throws IOException {
        int slash;
        int period;
        String pathname = jar.toString().replace('\\', '/');
        if (pathname.endsWith("!/")) {
            pathname = pathname.substring(0, pathname.length() - 2);
        }
        if ((period = pathname.lastIndexOf(46)) >= pathname.length() - 4) {
            pathname = pathname.substring(0, period);
        }
        if ((slash = pathname.lastIndexOf(47)) >= 0) {
            pathname = pathname.substring(slash + 1);
        }
        return ExpandJar.expand(jar, pathname, workFolder);
    }

    public static String expand(URL jar, String pathname, String dirname) throws IOException {
        File appBase = new File(dirname);
        File docBase = new File(appBase, pathname);
        if (!docBase.mkdir()) {
            throw new IllegalStateException(String.format("Unable to create directory: %s", docBase.getAbsolutePath()));
        }
        JarURLConnection juc = (JarURLConnection)jar.openConnection();
        juc.setUseCaches(false);
        JarFile jarFile = null;
        InputStream input = null;
        try {
            jarFile = juc.getJarFile();
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                File parent;
                JarEntry jarEntry = jarEntries.nextElement();
                String name = jarEntry.getName();
                int last = name.lastIndexOf(47);
                if (last >= 0 && !(parent = new File(docBase, name.substring(0, last))).mkdirs()) {
                    throw new IllegalStateException(String.format("Unable to create directory: %s", parent.getAbsolutePath()));
                }
                if (name.endsWith("/")) continue;
                input = jarFile.getInputStream(jarEntry);
                ExpandJar.expand(input, docBase, name);
                input.close();
                input = null;
            }
        }
        catch (IOException e2) {
            ExpandJar.deleteDir(docBase);
            throw e2;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable throwable) {}
                input = null;
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable) {}
                jarFile = null;
            }
        }
        return docBase.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File src, File dest) {
        String[] files;
        boolean result = true;
        if (src.isDirectory()) {
            files = src.list();
            result = dest.mkdir();
        } else {
            files = new String[]{""};
        }
        if (files == null) {
            files = new String[]{};
        }
        for (int i2 = 0; i2 < files.length && result; ++i2) {
            File fileSrc = new File(src, files[i2]);
            File fileDest = new File(dest, files[i2]);
            if (fileSrc.isDirectory()) {
                result = ExpandJar.copy(fileSrc, fileDest);
                continue;
            }
            FileChannel ic2 = null;
            AbstractInterruptibleChannel oc = null;
            try {
                ic2 = new FileInputStream(fileSrc).getChannel();
                oc = new FileOutputStream(fileDest).getChannel();
                ic2.transferTo(0L, ic2.size(), (WritableByteChannel)((Object)oc));
                continue;
            }
            catch (IOException e2) {
                result = false;
                continue;
            }
            finally {
                if (ic2 != null) {
                    try {
                        ic2.close();
                    }
                    catch (IOException iOException) {}
                }
                if (oc != null) {
                    try {
                        oc.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return result;
    }

    public static boolean delete(File dir) {
        if (dir.isDirectory()) {
            return ExpandJar.deleteDir(dir);
        }
        return dir.delete();
    }

    public static boolean deleteDir(File dir) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        for (int i2 = 0; i2 < files.length; ++i2) {
            File file = new File(dir, files[i2]);
            if (file.isDirectory()) {
                ExpandJar.deleteDir(file);
                continue;
            }
            if (file.delete()) continue;
            throw new IllegalStateException(String.format("Unable to delete file: %s", file.getAbsolutePath()));
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void expand(InputStream input, File docBase, String name) throws IOException {
        File file = new File(docBase, name);
        FilterOutputStream output = null;
        try {
            int n2;
            output = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[2048];
            while ((n2 = input.read(buffer)) > 0) {
                ((BufferedOutputStream)output).write(buffer, 0, n2);
            }
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

