/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.attributes;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.attributes.DefaultAttributeBuilder;

class AttributeBuilderInitializer {
    private static final String PROP = "org.glassfish.grizzly.DEFAULT_ATTRIBUTE_BUILDER";
    private static final Logger LOGGER = Grizzly.logger(AttributeBuilderInitializer.class);

    AttributeBuilderInitializer() {
    }

    static AttributeBuilder initBuilder() {
        String className = System.getProperty(PROP);
        if (className != null) {
            try {
                Class<?> builderClass = Class.forName(className, true, AttributeBuilder.class.getClassLoader());
                return (AttributeBuilder)builderClass.newInstance();
            }
            catch (Exception e2) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "Unable to load or create a new instance of AttributeBuilder {0}.  Cause: {1}", new Object[]{className, e2.getMessage()});
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e2.toString(), e2);
                }
                return new DefaultAttributeBuilder();
            }
        }
        return new DefaultAttributeBuilder();
    }
}

